/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.facebook;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.firebase.client.Firebase;
import com.firebase.ui.auth.core.FirebaseAuthProvider;
import com.firebase.ui.auth.core.FirebaseLoginError;
import com.firebase.ui.auth.core.FirebaseOAuthToken;
import com.firebase.ui.auth.core.FirebaseResponse;
import com.firebase.ui.auth.core.SocialProvider;
import com.firebase.ui.auth.core.TokenAuthHandler;
import java.util.Arrays;
import java.util.List;

public class FacebookAuthProvider
extends FirebaseAuthProvider {
    public static final String PROVIDER_NAME = "facebook";
    public static final SocialProvider PROVIDER_TYPE = SocialProvider.facebook;
    private final String TAG = "FacebookAuthProvider";
    public CallbackManager mCallbackManager;
    private LoginManager mLoginManager;
    private TokenAuthHandler mHandler;
    private Activity mActivity;
    private Firebase mRef;
    private Boolean isReady = false;

    public FacebookAuthProvider(Context context, Firebase ref, final TokenAuthHandler handler) {
        this.mActivity = (Activity)context;
        FacebookSdk.sdkInitialize((Context)context.getApplicationContext());
        this.mLoginManager = LoginManager.getInstance();
        this.mCallbackManager = CallbackManager.Factory.create();
        this.mHandler = handler;
        this.mRef = ref;
        this.mLoginManager.registerCallback(this.mCallbackManager, (FacebookCallback)new FacebookCallback<LoginResult>(){

            public void onSuccess(LoginResult loginResult) {
                AccessToken token = loginResult.getAccessToken();
                FirebaseOAuthToken foToken = new FirebaseOAuthToken(FacebookAuthProvider.PROVIDER_NAME, token.getToken().toString());
                FacebookAuthProvider.this.onFirebaseTokenReceived(foToken, handler);
            }

            public void onCancel() {
                FacebookAuthProvider.this.mHandler.onUserError(new FirebaseLoginError(FirebaseResponse.LOGIN_CANCELLED, "User closed login dialog."));
            }

            public void onError(FacebookException ex) {
                FacebookAuthProvider.this.mHandler.onProviderError(new FirebaseLoginError(FirebaseResponse.MISC_PROVIDER_ERROR, ex.toString()));
            }
        });
        String facebookAppId = "";
        try {
            ApplicationInfo ai = this.mActivity.getPackageManager().getApplicationInfo(this.mActivity.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            facebookAppId = bundle.getString("com.facebook.sdk.ApplicationId");
        }
        catch (PackageManager.NameNotFoundException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (facebookAppId == null) {
            this.mHandler.onProviderError(new FirebaseLoginError(FirebaseResponse.MISSING_PROVIDER_APP_ID, "Missing Facebook Application ID, is it set in your AndroidManifest.xml?"));
            return;
        }
        if (facebookAppId.compareTo("") == 0) {
            this.mHandler.onProviderError(new FirebaseLoginError(FirebaseResponse.INVALID_PROVIDER_APP_ID, "Invalid Facebook Application ID, is it set in your res/values/strings.xml?"));
            return;
        }
        this.isReady = true;
    }

    @Override
    public void login() {
        if (this.isReady.booleanValue()) {
            List<String> permissions = Arrays.asList("public_profile");
            this.mLoginManager.logInWithReadPermissions(this.mActivity, permissions);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mCallbackManager.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public String getProviderName() {
        return PROVIDER_NAME;
    }

    @Override
    public SocialProvider getProviderType() {
        return PROVIDER_TYPE;
    }

    @Override
    public Firebase getFirebaseRef() {
        return this.mRef;
    }

    @Override
    public void logout() {
        this.mLoginManager.logOut();
    }
}

