/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2awizard.networking;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import androidx.compose.runtime.internal.StabilityInferred;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import com.fintecsystems.xs2awizard.R;
import com.fintecsystems.xs2awizard.networking.UrlEncodedRequest;
import com.fintecsystems.xs2awizard.networking.encryption.Encryptor;
import com.fintecsystems.xs2awizard.networking.utils.ContextExtensionsKt;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0012\u001a\u00020\u0013J6\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00130\u0017J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001f2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/fintecsystems/xs2awizard/networking/NetworkingService;", "Landroid/net/ConnectivityManager$NetworkCallback;", "context", "Landroid/content/Context;", "sessionKey", "", "backendURL", "<init>", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;)V", "requestQueue", "Lcom/android/volley/RequestQueue;", "encryptor", "Lcom/fintecsystems/xs2awizard/networking/encryption/Encryptor;", "isConnected", "", "offlineRequests", "", "Lcom/android/volley/Request;", "finalize", "", "encodeAndSendMessage", "message", "onSuccess", "Lkotlin/Function1;", "onError", "Lcom/android/volley/VolleyError;", "onAvailable", "network", "Landroid/net/Network;", "onLost", "constructBody", "", "xs2awizard_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nNetworkingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkingService.kt\ncom/fintecsystems/xs2awizard/networking/NetworkingService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1869#2,2:85\n*S KotlinDebug\n*F\n+ 1 NetworkingService.kt\ncom/fintecsystems/xs2awizard/networking/NetworkingService\n*L\n68#1:85,2\n*E\n"})
public final class NetworkingService
extends ConnectivityManager.NetworkCallback {
    @NotNull
    private final Context context;
    @NotNull
    private final String sessionKey;
    @NotNull
    private final String backendURL;
    @NotNull
    private final RequestQueue requestQueue;
    @NotNull
    private final Encryptor encryptor;
    private boolean isConnected;
    @NotNull
    private List<Request<?>> offlineRequests;
    public static final int $stable = 8;

    public NetworkingService(@NotNull Context context, @NotNull String sessionKey, @NotNull String backendURL) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sessionKey, (String)"sessionKey");
        Intrinsics.checkNotNullParameter((Object)backendURL, (String)"backendURL");
        this.context = context;
        this.sessionKey = sessionKey;
        this.backendURL = backendURL;
        RequestQueue requestQueue = Volley.newRequestQueue((Context)this.context);
        Intrinsics.checkNotNullExpressionValue((Object)requestQueue, (String)"newRequestQueue(...)");
        this.requestQueue = requestQueue;
        String string2 = this.context.getString(R.string.networking_public_key_modulus);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String string3 = this.context.getString(R.string.networking_public_key_exponent);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        this.encryptor = new Encryptor(string2, string3);
        this.offlineRequests = new ArrayList();
        ContextExtensionsKt.registerNetworkCallback(this.context, this);
    }

    public final void finalize() {
        ContextExtensionsKt.unregisterNetworkCallback(this.context, this);
    }

    public final void encodeAndSendMessage(@NotNull String message, @NotNull Function1<? super String, Unit> onSuccess, @NotNull Function1<? super VolleyError, Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        UrlEncodedRequest request = new UrlEncodedRequest(1, this.backendURL, this.constructBody(message), (Response.Listener<String>)((Response.Listener)arg_0 -> NetworkingService.encodeAndSendMessage$lambda$0(onSuccess, arg_0)), arg_0 -> NetworkingService.encodeAndSendMessage$lambda$1(onError, arg_0));
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(180000, Integer.MAX_VALUE, 1.0f));
        Comparable comparable = this.isConnected ? (Comparable)this.requestQueue.add((Request)request) : (Comparable)Boolean.valueOf(this.offlineRequests.add((Request<?>)request));
    }

    public void onAvailable(@NotNull Network network) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        this.isConnected = true;
        Iterable $this$forEach$iv = this.offlineRequests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Request it = (Request)element$iv;
            boolean bl = false;
            this.requestQueue.add(it);
        }
        this.offlineRequests.clear();
    }

    public void onLost(@NotNull Network network) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        this.isConnected = false;
    }

    private final Map<String, String> constructBody(String message) {
        Pair[] pairArray = new Pair[]{new Pair((Object)"data", (Object)this.encryptor.encodeMessage(message)), new Pair((Object)"key", (Object)this.sessionKey)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private static final void encodeAndSendMessage$lambda$0(Function1 $onSuccess, String it) {
        Intrinsics.checkNotNull((Object)it);
        $onSuccess.invoke((Object)it);
    }

    private static final void encodeAndSendMessage$lambda$1(Function1 $onError, VolleyError it) {
        Intrinsics.checkNotNull((Object)it);
        $onError.invoke((Object)it);
    }
}

