/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2awizard.components;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.Uri;
import android.os.Bundle;
import androidx.activity.ComponentActivity;
import androidx.annotation.RequiresApi;
import androidx.biometric.BiometricPrompt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.LinkAnnotation;
import androidx.core.util.Consumer;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.SavedStateHandle;
import com.android.volley.VolleyError;
import com.fintecsystems.xs2awizard.R;
import com.fintecsystems.xs2awizard.components.XS2AWizardCallbackListener;
import com.fintecsystems.xs2awizard.components.XS2AWizardError;
import com.fintecsystems.xs2awizard.components.XS2AWizardLanguage;
import com.fintecsystems.xs2awizard.components.XS2AWizardStep;
import com.fintecsystems.xs2awizard.components.XS2AWizardViewModel;
import com.fintecsystems.xs2awizard.components.networking.ConnectionState;
import com.fintecsystems.xs2awizard.form.CheckBoxLineData;
import com.fintecsystems.xs2awizard.form.CredentialFormLineData;
import com.fintecsystems.xs2awizard.form.FormLineData;
import com.fintecsystems.xs2awizard.form.FormResponse;
import com.fintecsystems.xs2awizard.form.ParagraphLineData;
import com.fintecsystems.xs2awizard.form.RedirectLineData;
import com.fintecsystems.xs2awizard.form.SubmitLineData;
import com.fintecsystems.xs2awizard.form.ValueFormLineData;
import com.fintecsystems.xs2awizard.helper.Crypto;
import com.fintecsystems.xs2awizard.helper.JSONFormatter;
import com.fintecsystems.xs2awizard.helper.MarkupParser;
import com.fintecsystems.xs2awizard.helper.Utils;
import com.fintecsystems.xs2awizard.networking.NetworkingService;
import com.fintecsystems.xs2awizard.networking.utils.ContextExtensionsKt;
import java.lang.ref.WeakReference;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00bb\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0011*\u00012\b\u0007\u0018\u0000 \u007f2\u00020\u0001:\u0001\u007fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JS\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u001d2\b\u0010G\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010H\u001a\u00020=H\u0000\u00a2\u0006\u0002\bIJ\r\u0010J\u001a\u00020EH\u0000\u00a2\u0006\u0002\bKJ\b\u0010L\u001a\u00020EH\u0002J\u0006\u0010M\u001a\u00020\u0013J\b\u0010N\u001a\u00020\u0013H\u0002J\u0006\u0010O\u001a\u00020EJ\u0006\u0010P\u001a\u00020EJ\u0006\u0010Q\u001a\u00020EJ!\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u001d2\n\b\u0002\u0010U\u001a\u0004\u0018\u00010SH\u0000\u00a2\u0006\u0002\bVJ\r\u0010W\u001a\u00020EH\u0000\u00a2\u0006\u0002\bXJ\u0015\u0010W\u001a\u00020E2\u0006\u0010T\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\bXJ\u001f\u0010W\u001a\u00020E2\u0006\u0010Y\u001a\u00020Z2\b\b\u0002\u0010[\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\bXJ\u0018\u0010W\u001a\u00020E2\u0006\u0010Y\u001a\u00020\u001d2\u0006\u0010[\u001a\u00020\u0013H\u0002J)\u0010\\\u001a\u00020E2\u0006\u0010T\u001a\u00020\u001d2\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020E0^H\u0000\u00a2\u0006\u0002\b_J\u0015\u0010`\u001a\u00020E2\u0006\u0010a\u001a\u00020bH\u0000\u00a2\u0006\u0002\bcJ\u0010\u0010d\u001a\u00020E2\u0006\u0010e\u001a\u00020\u001dH\u0002J \u0010f\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 H\u0002J\u0012\u0010g\u001a\u00020\u00132\b\u0010:\u001a\u0004\u0018\u00010\u001dH\u0002J\u0010\u0010h\u001a\u00020E2\u0006\u0010:\u001a\u00020\u001dH\u0002J\b\u0010i\u001a\u00020EH\u0003J\u0016\u0010j\u001a\u00020E2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 H\u0003J\b\u0010k\u001a\u00020EH\u0003J\b\u0010l\u001a\u00020EH\u0003J\u0010\u0010m\u001a\u00020E2\u0006\u0010n\u001a\u00020oH\u0002J\u0010\u0010p\u001a\u00020E2\u0006\u0010q\u001a\u00020\u001dH\u0002J\r\u0010r\u001a\u00020EH\u0000\u00a2\u0006\u0002\bsJ\u0010\u0010t\u001a\u00020E2\u0006\u0010q\u001a\u00020\u001dH\u0002J\u0015\u0010u\u001a\u00020E2\u0006\u0010q\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\bvJ\u0006\u0010w\u001a\u00020\u0013J\u0006\u0010x\u001a\u00020\u0013J\u0010\u0010y\u001a\u00020\u00132\u0006\u0010q\u001a\u00020\u001dH\u0002J\u0017\u0010z\u001a\u00020\u00132\b\u0010q\u001a\u0004\u0018\u00010\u001dH\u0000\u00a2\u0006\u0002\b{J\u0015\u0010|\u001a\u00020E2\u0006\u0010}\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b~R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u000e\u0010\u001b\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020!\u0018\u00010 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\"\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020!\u0018\u00010 0#8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001c\u0010&\u001a\u0010\u0012\f\u0012\n '*\u0004\u0018\u00010\u00130\u00130\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130#8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010%R\u0016\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0#8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010%R\u001c\u0010-\u001a\u0010\u0012\f\u0012\n '*\u0004\u0018\u00010.0.0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020.0#8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010%R\u0010\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00103R\u0014\u00104\u001a\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0010\u00108\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010=0<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010>\u001a\u0004\u0018\u00010?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010@\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010A\u001a\b\u0012\u0004\u0012\u00020C0BX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0080\u0001"}, d2={"Lcom/fintecsystems/xs2awizard/components/XS2AWizardViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "<init>", "(Landroid/app/Application;Landroidx/lifecycle/SavedStateHandle;)V", "callbackListener", "Lcom/fintecsystems/xs2awizard/components/XS2AWizardCallbackListener;", "getCallbackListener", "()Lcom/fintecsystems/xs2awizard/components/XS2AWizardCallbackListener;", "setCallbackListener", "(Lcom/fintecsystems/xs2awizard/components/XS2AWizardCallbackListener;)V", "networkingService", "Lcom/fintecsystems/xs2awizard/networking/NetworkingService;", "language", "Lcom/fintecsystems/xs2awizard/components/XS2AWizardLanguage;", "enableScroll", "", "getEnableScroll$xs2awizard_release", "()Z", "setEnableScroll$xs2awizard_release", "(Z)V", "enableBackButton", "getEnableBackButton$xs2awizard_release", "setEnableBackButton$xs2awizard_release", "enableAutomaticRetry", "redirectDeepLink", "", "_form", "Landroidx/lifecycle/MutableLiveData;", "", "Lcom/fintecsystems/xs2awizard/form/FormLineData;", "form", "Landroidx/lifecycle/LiveData;", "getForm$xs2awizard_release", "()Landroidx/lifecycle/LiveData;", "_loadingIndicatorLock", "kotlin.jvm.PlatformType", "loadingIndicatorLock", "getLoadingIndicatorLock$xs2awizard_release", "_currentWebViewUrl", "currentWebViewUrl", "getCurrentWebViewUrl$xs2awizard_release", "_connectionState", "Lcom/fintecsystems/xs2awizard/components/networking/ConnectionState;", "connectionState", "getConnectionState$xs2awizard_release", "networkCallback", "com/fintecsystems/xs2awizard/components/XS2AWizardViewModel$networkCallback$1", "Lcom/fintecsystems/xs2awizard/components/XS2AWizardViewModel$networkCallback$1;", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "currentStep", "Lcom/fintecsystems/xs2awizard/components/XS2AWizardStep;", "provider", "currentActivity", "Ljava/lang/ref/WeakReference;", "Landroid/app/Activity;", "currentBiometricPromp", "Landroidx/biometric/BiometricPrompt;", "currentState", "onNewIntentListener", "Landroidx/core/util/Consumer;", "Landroid/content/Intent;", "onStart", "", "sessionKey", "backendURL", "activity", "onStart$xs2awizard_release", "onStop", "onStop$xs2awizard_release", "initForm", "backButtonIsPresent", "shouldAbortNetworkRequest", "goBack", "abort", "restart", "constructJsonBody", "Lkotlinx/serialization/json/JsonObject;", "action", "values", "constructJsonBody$xs2awizard_release", "submitForm", "submitForm$xs2awizard_release", "jsonBody", "Lkotlinx/serialization/json/JsonElement;", "showIndicator", "submitFormWithCallback", "onSuccess", "Lkotlin/Function1;", "submitFormWithCallback$xs2awizard_release", "handleLinkAnnotationClick", "annotation", "Landroidx/compose/ui/text/LinkAnnotation$Clickable;", "handleLinkAnnotationClick$xs2awizard_release", "onFormReceived", "jsonString", "filterFormResponseForm", "isProviderInStore", "storeProvider", "tryToStoreCredentials", "storeCredentials", "tryToAutoFillCredentials", "autoFillCredentials", "parseCallback", "response", "Lcom/fintecsystems/xs2awizard/form/FormResponse;", "openWebView", "url", "closeWebView", "closeWebView$xs2awizard_release", "openExternalUrl", "openRedirectURL", "openRedirectURL$xs2awizard_release", "isBankSearch", "isLogin", "urlSupportsAppRedirection", "isRedirectDeepLink", "isRedirectDeepLink$xs2awizard_release", "redirectionCallback", "success", "redirectionCallback$xs2awizard_release", "Companion", "xs2awizard_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nXS2AWizardViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XS2AWizardViewModel.kt\ncom/fintecsystems/xs2awizard/components/XS2AWizardViewModel\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n+ 5 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,758:1\n29#2,3:759\n29#2,3:765\n29#2,3:768\n29#2,3:771\n29#2,2:774\n31#2:780\n29#2,3:782\n1761#3,3:762\n1869#3,2:776\n1869#3,2:778\n774#3:785\n865#3:786\n2746#3,3:787\n866#3:790\n295#3,2:791\n1869#3,2:793\n2746#3,3:795\n1869#3,2:798\n222#4:781\n29#5:800\n*S KotlinDebug\n*F\n+ 1 XS2AWizardViewModel.kt\ncom/fintecsystems/xs2awizard/components/XS2AWizardViewModel\n*L\n202#1:759,3\n241#1:765,3\n254#1:768,3\n264#1:771,3\n277#1:774,2\n277#1:780\n411#1:782,3\n220#1:762,3\n278#1:776,2\n293#1:778,2\n438#1:785\n438#1:786\n447#1:787,3\n438#1:790\n498#1:791,2\n532#1:793,2\n556#1:795,3\n584#1:798,2\n398#1:781\n705#1:800\n*E\n"})
public final class XS2AWizardViewModel
extends AndroidViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private XS2AWizardCallbackListener callbackListener;
    @Nullable
    private NetworkingService networkingService;
    @Nullable
    private XS2AWizardLanguage language;
    private boolean enableScroll;
    private boolean enableBackButton;
    private boolean enableAutomaticRetry;
    @Nullable
    private String redirectDeepLink;
    @NotNull
    private final MutableLiveData<List<FormLineData>> _form;
    @NotNull
    private final MutableLiveData<Boolean> _loadingIndicatorLock;
    @NotNull
    private final MutableLiveData<String> _currentWebViewUrl;
    @NotNull
    private final MutableLiveData<ConnectionState> _connectionState;
    @NotNull
    private final networkCallback.1 networkCallback;
    @Nullable
    private XS2AWizardStep currentStep;
    @Nullable
    private String provider;
    @NotNull
    private WeakReference<Activity> currentActivity;
    @Nullable
    private BiometricPrompt currentBiometricPromp;
    @Nullable
    private String currentState;
    @NotNull
    private final Consumer<Intent> onNewIntentListener;
    public static final int $stable = 8;
    @NotNull
    private static final String rememberLoginName = "store_credentials";
    @NotNull
    private static final String sharedPreferencesFileName = "xs2a_credentials";
    @NotNull
    private static final String storedProvidersKey = "providers";
    @NotNull
    private static final String masterKeyAlias = "xs2a_credentials_master_key";
    @NotNull
    private static final List<String> supportedAppRedirectionURLs;

    public XS2AWizardViewModel(@NotNull Application application, @NotNull SavedStateHandle savedStateHandle) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        super(application);
        this.enableScroll = true;
        this.enableBackButton = true;
        this.enableAutomaticRetry = true;
        this._form = new MutableLiveData();
        this._loadingIndicatorLock = new MutableLiveData((Object)false);
        this._currentWebViewUrl = new MutableLiveData(null);
        this._connectionState = new MutableLiveData((Object)ConnectionState.UNKNOWN);
        this.networkCallback = new ConnectivityManager.NetworkCallback(this){
            final /* synthetic */ XS2AWizardViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAvailable(Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                XS2AWizardViewModel.access$get_connectionState$p(this.this$0).postValue((Object)((Object)ConnectionState.CONNECTED));
            }

            public void onLost(Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                XS2AWizardViewModel.access$get_connectionState$p(this.this$0).postValue((Object)((Object)ConnectionState.DISCONNECTED));
            }
        };
        this.currentActivity = new WeakReference<Object>(null);
        this.onNewIntentListener = arg_0 -> XS2AWizardViewModel.onNewIntentListener$lambda$0(this, arg_0);
        Bundle xs2aWizardBundle = (Bundle)savedStateHandle.get("xs2aWizardConfig");
        if (xs2aWizardBundle != null) {
            this._currentWebViewUrl.setValue((Object)xs2aWizardBundle.getString("currentWebViewUrl"));
        }
        savedStateHandle.setSavedStateProvider("xs2aWizardConfig", () -> XS2AWizardViewModel._init_$lambda$2(this));
    }

    @Nullable
    public final XS2AWizardCallbackListener getCallbackListener() {
        return this.callbackListener;
    }

    public final void setCallbackListener(@Nullable XS2AWizardCallbackListener xS2AWizardCallbackListener) {
        this.callbackListener = xS2AWizardCallbackListener;
    }

    public final boolean getEnableScroll$xs2awizard_release() {
        return this.enableScroll;
    }

    public final void setEnableScroll$xs2awizard_release(boolean bl) {
        this.enableScroll = bl;
    }

    public final boolean getEnableBackButton$xs2awizard_release() {
        return this.enableBackButton;
    }

    public final void setEnableBackButton$xs2awizard_release(boolean bl) {
        this.enableBackButton = bl;
    }

    @NotNull
    public final LiveData<List<FormLineData>> getForm$xs2awizard_release() {
        return (LiveData)this._form;
    }

    @NotNull
    public final LiveData<Boolean> getLoadingIndicatorLock$xs2awizard_release() {
        return (LiveData)this._loadingIndicatorLock;
    }

    @NotNull
    public final LiveData<String> getCurrentWebViewUrl$xs2awizard_release() {
        return (LiveData)this._currentWebViewUrl;
    }

    @NotNull
    public final LiveData<ConnectionState> getConnectionState$xs2awizard_release() {
        return (LiveData)this._connectionState;
    }

    private final Context getContext() {
        Context context = this.getApplication().getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
        return context;
    }

    public final void onStart$xs2awizard_release(@NotNull String sessionKey, @Nullable String backendURL, @Nullable XS2AWizardLanguage language, boolean enableScroll, boolean enableBackButton, boolean enableAutomaticRetry, @Nullable String redirectDeepLink, @NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)sessionKey, (String)"sessionKey");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.language = language;
        this.enableScroll = enableScroll;
        this.enableBackButton = enableBackButton;
        this.enableAutomaticRetry = enableAutomaticRetry;
        this.redirectDeepLink = redirectDeepLink;
        this.currentActivity = new WeakReference<Activity>(activity);
        Context context = this.getContext();
        String string2 = backendURL;
        if (string2 == null) {
            String string3 = this.getContext().getString(R.string.networking_backend_url);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        }
        this.networkingService = new NetworkingService(context, sessionKey, string2);
        ContextExtensionsKt.registerNetworkCallback(this.getContext(), this.networkCallback);
        ComponentActivity componentActivity = activity instanceof ComponentActivity ? (ComponentActivity)activity : null;
        if (componentActivity != null) {
            componentActivity.addOnNewIntentListener(this.onNewIntentListener);
        }
        this.initForm();
    }

    public final void onStop$xs2awizard_release() {
        this._loadingIndicatorLock.setValue((Object)false);
        this._currentWebViewUrl.setValue(null);
        this._form.setValue((Object)CollectionsKt.emptyList());
        this.language = null;
        this.currentStep = null;
        this.enableScroll = true;
        this.enableBackButton = true;
        this.enableAutomaticRetry = true;
        this.redirectDeepLink = null;
        Object t = this.currentActivity.get();
        ComponentActivity componentActivity = t instanceof ComponentActivity ? (ComponentActivity)t : null;
        if (componentActivity != null) {
            componentActivity.removeOnNewIntentListener(this.onNewIntentListener);
        }
        this.currentActivity = new WeakReference<Object>(null);
        this._connectionState.setValue((Object)ConnectionState.UNKNOWN);
        ContextExtensionsKt.unregisterNetworkCallback(this.getContext(), this.networkCallback);
        NetworkingService networkingService = this.networkingService;
        if (networkingService != null) {
            networkingService.finalize();
        }
        this.networkingService = null;
    }

    /*
     * WARNING - void declaration
     */
    private final void initForm() {
        void $this$initForm_u24lambda_u243;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl = false;
        $this$initForm_u24lambda_u243.put("version", (JsonElement)JsonElementKt.JsonPrimitive((String)"6.0.1"));
        $this$initForm_u24lambda_u243.put("client", (JsonElement)JsonElementKt.JsonPrimitive((String)this.getContext().getString(R.string.networking_xs2a_client_tag)));
        if (this.redirectDeepLink != null) {
            $this$initForm_u24lambda_u243.put("location", (JsonElement)JsonElementKt.JsonPrimitive((String)this.redirectDeepLink));
        }
        xS2AWizardViewModel.submitForm$xs2awizard_release((JsonElement)builder$iv.build(), true);
    }

    public final boolean backButtonIsPresent() {
        boolean bl;
        block5: {
            List list = (List)this.getForm$xs2awizard_release().getValue();
            if (list != null) {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CharSequence charSequence;
                        FormLineData it = (FormLineData)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof SubmitLineData && !((charSequence = (CharSequence)((SubmitLineData)it).getBackLabel()) == null || charSequence.length() == 0) || it instanceof RedirectLineData && !((charSequence = (CharSequence)((RedirectLineData)it).getBackLabel()) == null || charSequence.length() == 0))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean shouldAbortNetworkRequest() {
        return !this.enableAutomaticRetry && this.getConnectionState$xs2awizard_release().getValue() == ConnectionState.DISCONNECTED;
    }

    /*
     * WARNING - void declaration
     */
    public final void goBack() {
        void $this$goBack_u24lambda_u245;
        JsonObjectBuilder builder$iv;
        if (!this.backButtonIsPresent()) {
            return;
        }
        XS2AWizardCallbackListener xS2AWizardCallbackListener = this.callbackListener;
        if (xS2AWizardCallbackListener != null) {
            xS2AWizardCallbackListener.onBack();
        }
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl = false;
        $this$goBack_u24lambda_u245.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)"back"));
        XS2AWizardViewModel.submitForm$xs2awizard_release$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void abort() {
        void $this$abort_u24lambda_u246;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl = false;
        $this$abort_u24lambda_u246.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)"abort"));
        XS2AWizardViewModel.submitForm$xs2awizard_release$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void restart() {
        void $this$restart_u24lambda_u247;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        XS2AWizardViewModel xS2AWizardViewModel = this;
        boolean bl = false;
        $this$restart_u24lambda_u247.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)"restart"));
        XS2AWizardViewModel.submitForm$xs2awizard_release$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
    }

    @NotNull
    public final JsonObject constructJsonBody$xs2awizard_release(@NotNull String action, @Nullable JsonObject values) {
        JsonObjectBuilder builder$iv;
        block4: {
            Object it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            boolean $i$f$buildJsonObject = false;
            JsonObjectBuilder $this$constructJsonBody_u24lambda_u2410 = builder$iv = new JsonObjectBuilder();
            boolean bl = false;
            List list = (List)this.getForm$xs2awizard_release().getValue();
            if (list != null) {
                $this$forEach$iv = list;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonElement jsonElement;
                    it = (FormLineData)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof ValueFormLineData) || it instanceof CheckBoxLineData && !((jsonElement = ((CheckBoxLineData)it).getValue()) != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? Intrinsics.areEqual((Object)JsonElementKt.getBooleanOrNull((JsonPrimitive)jsonElement), (Object)true) : false)) continue;
                    String string2 = ((ValueFormLineData)it).getName();
                    JsonElement jsonElement2 = ((ValueFormLineData)it).getValue();
                    if (jsonElement2 == null || (jsonElement2 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement2)) == null) {
                        jsonElement2 = (JsonPrimitive)JsonNull.INSTANCE;
                    }
                    $this$constructJsonBody_u24lambda_u2410.put(string2, jsonElement2);
                }
            }
            $this$constructJsonBody_u24lambda_u2410.put("action", (JsonElement)JsonElementKt.JsonPrimitive((String)action));
            Object object = values;
            if (object == null || (object = object.entrySet()) == null) break block4;
            $this$forEach$iv = (Iterable)object;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Map.Entry)element$iv;
                boolean bl3 = false;
                JsonElementBuildersKt.put((JsonObjectBuilder)$this$constructJsonBody_u24lambda_u2410, (String)((String)it.getKey()), (String)JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)it.getValue())).getContent());
            }
        }
        return builder$iv.build();
    }

    public static /* synthetic */ JsonObject constructJsonBody$xs2awizard_release$default(XS2AWizardViewModel xS2AWizardViewModel, String string2, JsonObject jsonObject, int n, Object object) {
        if ((n & 2) != 0) {
            jsonObject = null;
        }
        return xS2AWizardViewModel.constructJsonBody$xs2awizard_release(string2, jsonObject);
    }

    public final void submitForm$xs2awizard_release() {
        this.submitForm$xs2awizard_release("submit");
    }

    public final void submitForm$xs2awizard_release(@NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.submitForm$xs2awizard_release((JsonElement)XS2AWizardViewModel.constructJsonBody$xs2awizard_release$default(this, action, null, 2, null), true);
    }

    public final void submitForm$xs2awizard_release(@NotNull JsonElement jsonBody, boolean showIndicator) {
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        this.submitForm(jsonBody.toString(), showIndicator);
    }

    public static /* synthetic */ void submitForm$xs2awizard_release$default(XS2AWizardViewModel xS2AWizardViewModel, JsonElement jsonElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        xS2AWizardViewModel.submitForm$xs2awizard_release(jsonElement, bl);
    }

    private final void submitForm(String jsonBody, boolean showIndicator) {
        NetworkingService networkingService = this.networkingService;
        if (networkingService == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        NetworkingService networkingService2 = networkingService;
        if (this.shouldAbortNetworkRequest()) {
            return;
        }
        if (showIndicator) {
            this._loadingIndicatorLock.setValue((Object)true);
        }
        BiometricPrompt biometricPrompt = this.currentBiometricPromp;
        if (biometricPrompt != null) {
            biometricPrompt.cancelAuthentication();
        }
        if (Utils.INSTANCE.isMarshmallow() && Crypto.INSTANCE.isDeviceSecure(this.getContext())) {
            this.tryToStoreCredentials();
        }
        networkingService2.encodeAndSendMessage(jsonBody, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                XS2AWizardViewModel.access$onFormReceived((XS2AWizardViewModel)((Object)this.receiver), p0);
            }
        }), (Function1<? super VolleyError, Unit>)((Function1)arg_0 -> XS2AWizardViewModel.submitForm$lambda$11(this, arg_0)));
    }

    public final void submitFormWithCallback$xs2awizard_release(@NotNull String action, @NotNull Function1<? super String, Unit> onSuccess) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        NetworkingService networkingService = this.networkingService;
        if (networkingService == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        NetworkingService networkingService2 = networkingService;
        if (this.shouldAbortNetworkRequest()) {
            return;
        }
        networkingService2.encodeAndSendMessage(XS2AWizardViewModel.constructJsonBody$xs2awizard_release$default(this, action, null, 2, null).toString(), onSuccess, (Function1<? super VolleyError, Unit>)((Function1)arg_0 -> XS2AWizardViewModel.submitFormWithCallback$lambda$12(this, arg_0)));
    }

    public final void handleLinkAnnotationClick$xs2awizard_release(@NotNull LinkAnnotation.Clickable annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        JsonObject jsonBody = MarkupParser.INSTANCE.parseAutoSubmitPayloadAsJson(annotation.getTag());
        XS2AWizardViewModel.submitForm$xs2awizard_release$default(this, (JsonElement)this.constructJsonBody$xs2awizard_release("autosubmit", jsonBody), false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void onFormReceived(String jsonString) {
        Json this_$iv = JSONFormatter.INSTANCE.getFormatter();
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        FormResponse formResponse = (FormResponse)this_$iv.decodeFromString((DeserializationStrategy)FormResponse.Companion.serializer(), jsonString);
        if (Utils.INSTANCE.checkIfLanguageNeedsToBeChanged(formResponse.getLanguage(), this.language)) {
            void $this$onFormReceived_u24lambda_u2413;
            JsonObjectBuilder builder$iv;
            XS2AWizardLanguage xS2AWizardLanguage = this.language;
            if (xS2AWizardLanguage == null) {
                String string2 = Locale.getDefault().getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLanguage(...)");
                xS2AWizardLanguage = XS2AWizardLanguage.Companion.fromString$default(XS2AWizardLanguage.Companion, string2, null, 2, null);
            }
            XS2AWizardLanguage languageToChangeTo = xS2AWizardLanguage;
            boolean $i$f$buildJsonObject = false;
            JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
            XS2AWizardViewModel xS2AWizardViewModel = this;
            boolean bl = false;
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$onFormReceived_u24lambda_u2413, (String)"action", (String)"change-language");
            String string3 = languageToChangeTo.toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$onFormReceived_u24lambda_u2413, (String)"language", (String)string3);
            XS2AWizardViewModel.submitForm$xs2awizard_release$default(xS2AWizardViewModel, (JsonElement)builder$iv.build(), false, 2, null);
            return;
        }
        this.parseCallback(formResponse);
        this._form.setValue(this.filterFormResponseForm(formResponse.getForm()));
        if (Utils.INSTANCE.isMarshmallow() && Crypto.INSTANCE.isDeviceSecure(this.getContext())) {
            this.tryToAutoFillCredentials();
        }
        this._loadingIndicatorLock.setValue((Object)false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<FormLineData> filterFormResponseForm(List<? extends FormLineData> form) {
        List list;
        List<? extends FormLineData> list2 = form;
        if (list2 != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block10: {
                    FormLineData formLineData = (FormLineData)element$iv$iv;
                    boolean bl2 = false;
                    if (!(formLineData instanceof ParagraphLineData)) {
                        bl = true;
                    } else if (!Intrinsics.areEqual((Object)((ParagraphLineData)formLineData).getSeverity(), (Object)"error")) {
                        bl = true;
                    } else {
                        Iterable $this$none$iv = form;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                CharSequence charSequence;
                                FormLineData it = (FormLineData)element$iv;
                                boolean bl3 = false;
                                if (!(it instanceof ValueFormLineData && !((charSequence = (CharSequence)((ValueFormLineData)it).getValidationError()) == null || charSequence.length() == 0) && Intrinsics.areEqual((Object)((ValueFormLineData)it).getValidationError(), (Object)((ParagraphLineData)formLineData).getText()))) continue;
                                bl = false;
                                break block10;
                            }
                            bl = true;
                        }
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    private final boolean isProviderInStore(String provider) {
        Set set = this.getContext().getSharedPreferences(sharedPreferencesFileName, 0).getStringSet(storedProvidersKey, null);
        return set != null ? set.contains(provider) : false;
    }

    private final void storeProvider(String provider) {
        SharedPreferences sharedPreferences;
        SharedPreferences $this$storeProvider_u24lambda_u2417 = sharedPreferences = this.getContext().getSharedPreferences(sharedPreferencesFileName, 0);
        boolean bl = false;
        Set it = $this$storeProvider_u24lambda_u2417.getStringSet(storedProvidersKey, null);
        boolean bl2 = false;
        Set providers = new LinkedHashSet();
        if (it != null) {
            providers.addAll(providers);
        }
        providers.add(provider);
        $this$storeProvider_u24lambda_u2417.edit().putStringSet(storedProvidersKey, providers).apply();
    }

    @RequiresApi(value=23)
    private final void tryToStoreCredentials() {
        CheckBoxLineData consentCheckBoxLineData;
        CheckBoxLineData checkBoxLineData;
        Object v1;
        block3: {
            CharSequence charSequence;
            if (this.getForm$xs2awizard_release().getValue() == null || (charSequence = (CharSequence)this.provider) == null || charSequence.length() == 0) {
                return;
            }
            Object object = this.getForm$xs2awizard_release().getValue();
            Intrinsics.checkNotNull((Object)object);
            Iterable $this$firstOrNull$iv = (Iterable)object;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FormLineData it = (FormLineData)element$iv;
                boolean bl = false;
                if (!(it instanceof CheckBoxLineData && Intrinsics.areEqual((Object)((CheckBoxLineData)it).getName(), (Object)rememberLoginName))) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        if (!((checkBoxLineData = (consentCheckBoxLineData = (CheckBoxLineData)v1)) != null && (checkBoxLineData = checkBoxLineData.getValue()) != null && (checkBoxLineData = JsonElementKt.getJsonPrimitive((JsonElement)checkBoxLineData)) != null ? JsonElementKt.getBoolean((JsonPrimitive)checkBoxLineData) : false)) {
            return;
        }
        Object object = this.getForm$xs2awizard_release().getValue();
        Intrinsics.checkNotNull((Object)object);
        List formCopy = (List)object;
        Object t = this.currentActivity.get();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type androidx.fragment.app.FragmentActivity");
        FragmentActivity fragmentActivity = (FragmentActivity)t;
        String string2 = this.getContext().getString(R.string.save_credentials_prompt_title);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String string3 = this.getContext().getString(R.string.save_credentials_prompt_description);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        String string4 = this.getContext().getString(R.string.cancel);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
        this.currentBiometricPromp = Crypto.INSTANCE.openBiometricPrompt(fragmentActivity, string2, string3, string4, 15, (Function1<? super BiometricPrompt.AuthenticationResult, Unit>)((Function1)arg_0 -> XS2AWizardViewModel.tryToStoreCredentials$lambda$19(this, formCopy, arg_0)), (Function2<? super Integer, ? super CharSequence, Unit>)((Function2)XS2AWizardViewModel::tryToStoreCredentials$lambda$20));
    }

    @RequiresApi(value=23)
    private final void storeCredentials(List<? extends FormLineData> form) {
        SharedPreferences.Editor editor;
        String string2 = this.provider;
        Intrinsics.checkNotNull((Object)string2);
        this.storeProvider(string2);
        SharedPreferences.Editor $this$storeCredentials_u24lambda_u2422 = editor = Crypto.INSTANCE.createEncryptedSharedPreferences(this.getContext(), sharedPreferencesFileName, masterKeyAlias).edit();
        boolean bl = false;
        Iterable $this$forEach$iv = form;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SharedPreferences.Editor editor2;
            FormLineData it = (FormLineData)element$iv;
            boolean bl2 = false;
            if (!(it instanceof CredentialFormLineData) || !Intrinsics.areEqual((Object)((CredentialFormLineData)it).isLoginCredential(), (Object)true)) continue;
            if (it instanceof CheckBoxLineData) {
                JsonElement jsonElement;
                CheckBoxLineData checkBoxLineData = (CheckBoxLineData)it;
                String string3 = this.provider;
                Intrinsics.checkNotNull((Object)string3);
                editor2 = $this$storeCredentials_u24lambda_u2422.putBoolean(checkBoxLineData.getProviderName(string3), (jsonElement = ((CheckBoxLineData)it).getValue()) != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? JsonElementKt.getBoolean((JsonPrimitive)jsonElement) : false);
                continue;
            }
            CredentialFormLineData credentialFormLineData = (CredentialFormLineData)it;
            String string4 = this.provider;
            Intrinsics.checkNotNull((Object)string4);
            String string5 = credentialFormLineData.getProviderName(string4);
            Object object = ((CredentialFormLineData)it).getValue();
            if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = object.getContent()) == null) {
                object = "";
            }
            editor2 = $this$storeCredentials_u24lambda_u2422.putString(string5, (String)object);
        }
        $this$storeCredentials_u24lambda_u2422.apply();
    }

    @RequiresApi(value=23)
    private final void tryToAutoFillCredentials() {
        block12: {
            block11: {
                boolean bl;
                if (this.getForm$xs2awizard_release().getValue() == null) break block11;
                List list = (List)this.getForm$xs2awizard_release().getValue();
                if (list != null) {
                    boolean bl2;
                    block10: {
                        Iterable $this$none$iv = list;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                FormLineData it = (FormLineData)element$iv;
                                boolean bl3 = false;
                                if (!(it instanceof CredentialFormLineData && Intrinsics.areEqual((Object)((CredentialFormLineData)it).isLoginCredential(), (Object)true))) continue;
                                bl2 = false;
                                break block10;
                            }
                            bl2 = true;
                        }
                    }
                    bl = bl2;
                } else {
                    bl = false;
                }
                if (!bl) break block12;
            }
            return;
        }
        CharSequence charSequence = this.provider;
        if (charSequence == null || charSequence.length() == 0 || !this.isProviderInStore(this.provider)) {
            return;
        }
        Object t = this.currentActivity.get();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type androidx.fragment.app.FragmentActivity");
        FragmentActivity fragmentActivity = (FragmentActivity)t;
        String string2 = this.getContext().getString(R.string.fill_credentials_prompt_title);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String string3 = this.getContext().getString(R.string.fill_credentials_prompt_description);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        String string4 = this.getContext().getString(R.string.cancel);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
        this.currentBiometricPromp = Crypto.INSTANCE.openBiometricPrompt(fragmentActivity, string2, string3, string4, 15, (Function1<? super BiometricPrompt.AuthenticationResult, Unit>)((Function1)arg_0 -> XS2AWizardViewModel.tryToAutoFillCredentials$lambda$24(this, arg_0)), (Function2<? super Integer, ? super CharSequence, Unit>)((Function2)XS2AWizardViewModel::tryToAutoFillCredentials$lambda$25));
    }

    @RequiresApi(value=23)
    private final void autoFillCredentials() {
        SharedPreferences sharedPreferences = Crypto.INSTANCE.createEncryptedSharedPreferences(this.getContext(), sharedPreferencesFileName, masterKeyAlias);
        Object object = this.getForm$xs2awizard_release().getValue();
        Intrinsics.checkNotNull((Object)object);
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FormLineData it = (FormLineData)element$iv;
            boolean bl = false;
            if (!(it instanceof CredentialFormLineData) || !Intrinsics.areEqual((Object)((CredentialFormLineData)it).isLoginCredential(), (Object)true)) continue;
            CredentialFormLineData credentialFormLineData = (CredentialFormLineData)it;
            String string2 = this.provider;
            Intrinsics.checkNotNull((Object)string2);
            String key = credentialFormLineData.getProviderName(string2);
            if (it instanceof CheckBoxLineData) {
                if (!sharedPreferences.contains(key)) continue;
                ((CheckBoxLineData)it).setValue((JsonElement)JsonElementKt.JsonPrimitive((Boolean)sharedPreferences.getBoolean(key, false)));
                continue;
            }
            if (!sharedPreferences.contains(key)) continue;
            ((CredentialFormLineData)it).setValue((JsonElement)JsonElementKt.JsonPrimitive((String)sharedPreferences.getString(key, "")));
        }
        this.submitForm$xs2awizard_release();
    }

    private final void parseCallback(FormResponse response) {
        block10: {
            this.currentState = response.getStep();
            String string2 = response.getCallback();
            if (Intrinsics.areEqual((Object)string2, (Object)"finish")) {
                XS2AWizardCallbackListener xS2AWizardCallbackListener = this.callbackListener;
                if (xS2AWizardCallbackListener != null) {
                    JsonElement jsonElement = response.getCallbackParams();
                    xS2AWizardCallbackListener.onFinish(jsonElement != null && (jsonElement = (JsonElement)CollectionsKt.getOrNull(jsonElement, (int)0)) != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? jsonElement.getContent() : null);
                }
            } else if (Intrinsics.areEqual((Object)string2, (Object)"abort")) {
                XS2AWizardCallbackListener xS2AWizardCallbackListener = this.callbackListener;
                if (xS2AWizardCallbackListener != null) {
                    xS2AWizardCallbackListener.onAbort();
                }
            } else {
                this.currentStep = XS2AWizardStep.Companion.getRelevantStep(response.getCallback());
                if (this.currentStep != null) {
                    XS2AWizardCallbackListener xS2AWizardCallbackListener = this.callbackListener;
                    if (xS2AWizardCallbackListener != null) {
                        XS2AWizardStep xS2AWizardStep = this.currentStep;
                        Intrinsics.checkNotNull((Object)xS2AWizardStep);
                        xS2AWizardCallbackListener.onStep(xS2AWizardStep);
                    }
                }
            }
            List<JsonElement> list = response.getCallbackParams();
            JsonElement it = list != null ? (JsonElement)CollectionsKt.first(list) : null;
            boolean bl = false;
            if (it instanceof JsonObject && ((JsonObject)it).containsKey((Object)"provider")) {
                Object object = ((JsonObject)it).get((Object)"provider");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonPrimitive");
                this.provider = ((JsonPrimitive)object).getContent();
            }
            if (response.getError() == null) break block10;
            XS2AWizardCallbackListener xS2AWizardCallbackListener = this.callbackListener;
            if (xS2AWizardCallbackListener != null) {
                Boolean bl2 = response.isErrorRecoverable();
                xS2AWizardCallbackListener.onError(XS2AWizardError.Companion.getRelevantError(response.getError(), bl2 != null ? bl2 : false));
            }
        }
    }

    private final void openWebView(String url) {
        this._currentWebViewUrl.setValue((Object)url);
    }

    public final void closeWebView$xs2awizard_release() {
        this._currentWebViewUrl.setValue(null);
    }

    private final void openExternalUrl(String url) {
        Intent webIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        Object t = this.currentActivity.get();
        Intrinsics.checkNotNull(t);
        ((Activity)t).startActivity(webIntent);
    }

    public final void openRedirectURL$xs2awizard_release(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.urlSupportsAppRedirection(url)) {
            AlertDialog.Builder builder;
            Object t = this.currentActivity.get();
            Intrinsics.checkNotNull(t);
            AlertDialog.Builder $this$openRedirectURL_u24lambda_u2430 = builder = new AlertDialog.Builder((Context)t);
            boolean bl = false;
            $this$openRedirectURL_u24lambda_u2430.setTitle(R.string.redirect_dialog_title);
            $this$openRedirectURL_u24lambda_u2430.setMessage(R.string.redirect_dialog_message);
            $this$openRedirectURL_u24lambda_u2430.setPositiveButton(R.string.redirect_dialog_banking_app_button_title, (arg_0, arg_1) -> XS2AWizardViewModel.openRedirectURL$lambda$30$lambda$28(this, url, arg_0, arg_1));
            $this$openRedirectURL_u24lambda_u2430.setNegativeButton(R.string.redirect_dialog_website_button_title, (arg_0, arg_1) -> XS2AWizardViewModel.openRedirectURL$lambda$30$lambda$29(this, url, arg_0, arg_1));
            $this$openRedirectURL_u24lambda_u2430.show();
        } else {
            this.openWebView(url);
        }
    }

    public final boolean isBankSearch() {
        return Intrinsics.areEqual((Object)this.currentState, (Object)"bank");
    }

    public final boolean isLogin() {
        return Intrinsics.areEqual((Object)this.currentState, (Object)"login");
    }

    private final boolean urlSupportsAppRedirection(String url) {
        String $this$toUri$iv = url;
        boolean $i$f$toUri = false;
        return CollectionsKt.contains((Iterable)supportedAppRedirectionURLs, (Object)Uri.parse((String)$this$toUri$iv).getHost());
    }

    public final boolean isRedirectDeepLink$xs2awizard_release(@Nullable String url) {
        return Intrinsics.areEqual((Object)url, (Object)this.redirectDeepLink);
    }

    public final void redirectionCallback$xs2awizard_release(boolean success) {
        this.closeWebView$xs2awizard_release();
        if (success) {
            this.submitForm$xs2awizard_release("post-code");
        }
    }

    private static final void onNewIntentListener$lambda$0(XS2AWizardViewModel this$0, Intent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Intrinsics.areEqual((Object)it.getAction(), (Object)"android.intent.action.VIEW") || it.getData() == null) {
            return;
        }
        if (this$0.isRedirectDeepLink$xs2awizard_release(it.getDataString())) {
            this$0.redirectionCallback$xs2awizard_release(true);
        }
    }

    private static final Bundle _init_$lambda$2(XS2AWizardViewModel this$0) {
        Bundle bundle;
        Bundle $this$lambda_u242_u24lambda_u241 = bundle = new Bundle();
        boolean bl = false;
        $this$lambda_u242_u24lambda_u241.putString("currentWebViewUrl", (String)this$0.getCurrentWebViewUrl$xs2awizard_release().getValue());
        return bundle;
    }

    private static final Unit submitForm$lambda$11(XS2AWizardViewModel this$0, VolleyError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        XS2AWizardCallbackListener xS2AWizardCallbackListener = this$0.callbackListener;
        if (xS2AWizardCallbackListener != null) {
            xS2AWizardCallbackListener.onNetworkError();
        }
        this$0._loadingIndicatorLock.setValue((Object)false);
        return Unit.INSTANCE;
    }

    private static final Unit submitFormWithCallback$lambda$12(XS2AWizardViewModel this$0, VolleyError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        XS2AWizardCallbackListener xS2AWizardCallbackListener = this$0.callbackListener;
        if (xS2AWizardCallbackListener != null) {
            xS2AWizardCallbackListener.onNetworkError();
        }
        this$0._loadingIndicatorLock.setValue((Object)false);
        return Unit.INSTANCE;
    }

    private static final Unit tryToStoreCredentials$lambda$19(XS2AWizardViewModel this$0, List $formCopy, BiometricPrompt.AuthenticationResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.storeCredentials($formCopy);
        return Unit.INSTANCE;
    }

    private static final Unit tryToStoreCredentials$lambda$20(int n, CharSequence charSequence) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final Unit tryToAutoFillCredentials$lambda$24(XS2AWizardViewModel this$0, BiometricPrompt.AuthenticationResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.autoFillCredentials();
        return Unit.INSTANCE;
    }

    private static final Unit tryToAutoFillCredentials$lambda$25(int n, CharSequence charSequence) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final void openRedirectURL$lambda$30$lambda$28(XS2AWizardViewModel this$0, String $url, DialogInterface dialogInterface, int n) {
        this$0.openExternalUrl($url);
    }

    private static final void openRedirectURL$lambda$30$lambda$29(XS2AWizardViewModel this$0, String $url, DialogInterface dialogInterface, int n) {
        this$0.openWebView($url);
    }

    public static final /* synthetic */ void access$onFormReceived(XS2AWizardViewModel $this, String jsonString) {
        $this.onFormReceived(jsonString);
    }

    public static final /* synthetic */ MutableLiveData access$get_connectionState$p(XS2AWizardViewModel $this) {
        return $this._connectionState;
    }

    static {
        Object[] objectArray = new String[]{"manage.xs2a.com", "myaccount.ing.com"};
        supportedAppRedirectionURLs = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/fintecsystems/xs2awizard/components/XS2AWizardViewModel$Companion;", "", "<init>", "()V", "rememberLoginName", "", "sharedPreferencesFileName", "storedProvidersKey", "masterKeyAlias", "supportedAppRedirectionURLs", "", "clearCredentials", "", "context", "Landroid/content/Context;", "xs2awizard_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void clearCredentials(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = context.getSharedPreferences(XS2AWizardViewModel.sharedPreferencesFileName, 0).edit();
            SharedPreferences.Editor $this$clearCredentials_u24lambda_u240 = object;
            boolean bl = false;
            $this$clearCredentials_u24lambda_u240.clear();
            $this$clearCredentials_u24lambda_u240.apply();
            Object $this$clearCredentials_u24lambda_u241 = object = KeyStore.getInstance("AndroidKeyStore");
            boolean bl2 = false;
            ((KeyStore)$this$clearCredentials_u24lambda_u241).load(null);
            ((KeyStore)$this$clearCredentials_u24lambda_u241).deleteEntry(XS2AWizardViewModel.masterKeyAlias);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

