/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2awizard.helper;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.RequiresApi;
import androidx.biometric.BiometricManager;
import androidx.biometric.BiometricPrompt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.fragment.app.FragmentActivity;
import androidx.security.crypto.EncryptedSharedPreferences;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\\\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00180\u001a\u00a8\u0006\u001c"}, d2={"Lcom/fintecsystems/xs2awizard/helper/Crypto;", "", "()V", "createEncryptedSharedPreferences", "Landroid/content/SharedPreferences;", "context", "Landroid/content/Context;", "fileName", "", "masterKeyAlias", "isDeviceSecure", "", "openBiometricPrompt", "Landroidx/biometric/BiometricPrompt;", "fragmentActivity", "Landroidx/fragment/app/FragmentActivity;", "title", "description", "negativeText", "allowedAuthenticators", "", "onSuccess", "Lkotlin/Function1;", "Landroidx/biometric/BiometricPrompt$AuthenticationResult;", "", "onError", "Lkotlin/Function2;", "", "xs2awizard_release"})
@RequiresApi(value=23)
@StabilityInferred(parameters=1)
public final class Crypto {
    @NotNull
    public static final Crypto INSTANCE = new Crypto();
    public static final int $stable;

    private Crypto() {
    }

    public final boolean isDeviceSecure(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return BiometricManager.from((Context)context).canAuthenticate(15) == 0;
    }

    @NotNull
    public final SharedPreferences createEncryptedSharedPreferences(@NotNull Context context, @NotNull String fileName, @NotNull String masterKeyAlias) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)masterKeyAlias, (String)"masterKeyAlias");
        SharedPreferences sharedPreferences = EncryptedSharedPreferences.create((String)fileName, (String)masterKeyAlias, (Context)context, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"create(...)");
        return sharedPreferences;
    }

    @NotNull
    public final BiometricPrompt openBiometricPrompt(@NotNull FragmentActivity fragmentActivity, @NotNull String title, @NotNull String description, @NotNull String negativeText, int allowedAuthenticators, @NotNull Function1<? super BiometricPrompt.AuthenticationResult, Unit> onSuccess, @NotNull Function2<? super Integer, ? super CharSequence, Unit> onError) {
        BiometricPrompt biometricPrompt;
        Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"fragmentActivity");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)negativeText, (String)"negativeText");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        BiometricPrompt.AuthenticationCallback authenticationCallback2 = new BiometricPrompt.AuthenticationCallback(onSuccess, onError){
            final /* synthetic */ Function1<BiometricPrompt.AuthenticationResult, Unit> $onSuccess;
            final /* synthetic */ Function2<Integer, CharSequence, Unit> $onError;
            {
                this.$onSuccess = $onSuccess;
                this.$onError = $onError;
            }

            public void onAuthenticationSucceeded(@NotNull BiometricPrompt.AuthenticationResult result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                super.onAuthenticationSucceeded(result);
                this.$onSuccess.invoke((Object)result);
            }

            public void onAuthenticationError(int errorCode, @NotNull CharSequence errString) {
                Intrinsics.checkNotNullParameter((Object)errString, (String)"errString");
                super.onAuthenticationError(errorCode, errString);
                this.$onError.invoke((Object)errorCode, (Object)errString);
            }
        };
        BiometricPrompt $this$openBiometricPrompt_u24lambda_u240 = biometricPrompt = new BiometricPrompt(fragmentActivity, authenticationCallback2);
        boolean bl = false;
        BiometricPrompt.PromptInfo promptInfo = new BiometricPrompt.PromptInfo.Builder().setTitle((CharSequence)title).setDescription((CharSequence)description).setNegativeButtonText((CharSequence)negativeText).setAllowedAuthenticators(allowedAuthenticators).build();
        Intrinsics.checkNotNullExpressionValue((Object)promptInfo, (String)"build(...)");
        BiometricPrompt.PromptInfo promptInfo2 = promptInfo;
        $this$openBiometricPrompt_u24lambda_u240.authenticate(promptInfo2);
        return biometricPrompt;
    }
}

