/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2awizard.helper;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.Base64;
import android.widget.Toast;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.AndroidImageBitmap_androidKt;
import androidx.compose.ui.graphics.ImageBitmap;
import com.fintecsystems.xs2awizard.R;
import com.fintecsystems.xs2awizard.components.XS2AWizardLanguage;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rJ \u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\n\b\u0000\u0010\u0014\u0018\u0001*\u00020\u0015*\u00020\u0011H\u0086\b\u00a2\u0006\u0002\u0010\u0016J)\u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u0015*\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0018\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u001a"}, d2={"Lcom/fintecsystems/xs2awizard/helper/Utils;", "", "()V", "isMarshmallow", "", "()Z", "checkIfLanguageNeedsToBeChanged", "language", "Lcom/fintecsystems/xs2awizard/components/XS2AWizardLanguage;", "targetLanguage", "decodeBase64Image", "Landroidx/compose/ui/graphics/ImageBitmap;", "base64String", "", "setClipboardText", "", "context", "Landroid/content/Context;", "text", "getActivity", "T", "Landroid/app/Activity;", "(Landroid/content/Context;)Landroid/app/Activity;", "type", "Lkotlin/reflect/KClass;", "(Landroid/content/Context;Lkotlin/reflect/KClass;)Landroid/app/Activity;", "xs2awizard_release"})
@StabilityInferred(parameters=0)
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    public static final int $stable;

    private Utils() {
    }

    @NotNull
    public final ImageBitmap decodeBase64Image(@NotNull String base64String) {
        Intrinsics.checkNotNullParameter((Object)base64String, (String)"base64String");
        String cleanImage = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)base64String, (String)"data:image/png;base64,", (String)"", (boolean)false, (int)4, null), (String)"data:image/jpeg;base64,", (String)"", (boolean)false, (int)4, null), (String)"data:image/gif;base64,", (String)"", (boolean)false, (int)4, null);
        byte[] imageDataBytes = Base64.decode((String)cleanImage, (int)0);
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])imageDataBytes, (int)0, (int)imageDataBytes.length);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"decodeByteArray(imageDat\u2026, 0, imageDataBytes.size)");
        return AndroidImageBitmap_androidKt.asImageBitmap((Bitmap)bitmap);
    }

    public final void setClipboardText(@NotNull Context context, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object object = context.getSystemService("clipboard");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager clipboard = (ClipboardManager)object;
        ClipData clip = ClipData.newPlainText((CharSequence)"Copied Text", (CharSequence)text);
        clipboard.setPrimaryClip(clip);
        Toast.makeText((Context)context, (CharSequence)context.getString(R.string.link_copied), (int)0).show();
    }

    public final /* synthetic */ <T extends Activity> T getActivity(Context $this$getActivity) {
        Intrinsics.checkNotNullParameter((Object)$this$getActivity, (String)"<this>");
        boolean $i$f$getActivity = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.getActivity($this$getActivity, Reflection.getOrCreateKotlinClass(Activity.class));
    }

    @Nullable
    public final <T extends Activity> T getActivity(@NotNull Context $this$getActivity, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)$this$getActivity, (String)"<this>");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (type.isInstance((Object)$this$getActivity)) {
            return (T)((Activity)KClasses.cast(type, (Object)$this$getActivity));
        }
        if ($this$getActivity instanceof ContextWrapper) {
            Context context = ((ContextWrapper)$this$getActivity).getBaseContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"baseContext");
            return this.getActivity(context, type);
        }
        return null;
    }

    public final boolean checkIfLanguageNeedsToBeChanged(@Nullable XS2AWizardLanguage language, @Nullable XS2AWizardLanguage targetLanguage) {
        if (language != null) {
            XS2AWizardLanguage xS2AWizardLanguage;
            XS2AWizardLanguage xS2AWizardLanguage2 = targetLanguage;
            if (xS2AWizardLanguage2 == null) {
                String string2 = Locale.getDefault().getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDefault().language");
                xS2AWizardLanguage = XS2AWizardLanguage.Companion.fromString$default(XS2AWizardLanguage.Companion, string2, null, 2, null);
            } else {
                xS2AWizardLanguage = xS2AWizardLanguage2;
            }
            XS2AWizardLanguage languageToCheck = xS2AWizardLanguage;
            return ArraysKt.contains((Object[])XS2AWizardLanguage.values(), (Object)((Object)languageToCheck)) && languageToCheck != language;
        }
        return false;
    }

    public static /* synthetic */ boolean checkIfLanguageNeedsToBeChanged$default(Utils utils, XS2AWizardLanguage xS2AWizardLanguage, XS2AWizardLanguage xS2AWizardLanguage2, int n, Object object) {
        if ((n & 2) != 0) {
            xS2AWizardLanguage2 = null;
        }
        return utils.checkIfLanguageNeedsToBeChanged(xS2AWizardLanguage, xS2AWizardLanguage2);
    }

    @ChecksSdkIntAtLeast(api=23)
    public final boolean isMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }
}

