/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;

public class DefaultToken
extends Token {
    public DefaultToken() {
    }

    public DefaultToken(Segment line, int beg, int end, int startOffset, int type) {
        this(line.array, beg, end, startOffset, type);
    }

    public DefaultToken(char[] line, int beg, int end, int startOffset, int type) {
        super(line, beg, end, startOffset, type);
    }

    public int getListOffset(RSyntaxTextArea textArea, TabExpander e, float x0, float x) {
        if (x0 >= x) {
            return this.offset;
        }
        float currX = x0;
        float nextX = x0;
        float stableX = x0;
        int last = this.offset;
        FontMetrics fm = null;
        for (Token token = this; token != null && token.isPaintable(); token = token.getNextToken()) {
            fm = textArea.getFontMetricsForTokenType(token.type);
            char[] text = token.text;
            int start = token.textOffset;
            int end = start + token.textCount;
            for (int i = start; i < end; ++i) {
                currX = nextX;
                if (text[i] == '\t') {
                    stableX = nextX = e.nextTabStop(nextX, 0);
                    start = i + 1;
                } else {
                    nextX = stableX + (float)fm.charsWidth(text, start, i - start + 1);
                }
                if (!(x >= currX) || !(x < nextX)) continue;
                if (x - currX < nextX - x) {
                    return last + i - token.textOffset;
                }
                return last + i + 1 - token.textOffset;
            }
            stableX = nextX;
            last += token.textCount;
        }
        return last;
    }

    public float getWidthUpTo(int numChars, RSyntaxTextArea textArea, TabExpander e, float x0) {
        float width = x0;
        FontMetrics fm = textArea.getFontMetricsForTokenType(this.type);
        if (fm != null) {
            int w;
            int currentStart = this.textOffset;
            int endBefore = this.textOffset + numChars;
            for (int i = currentStart; i < endBefore; ++i) {
                if (this.text[i] != '\t') continue;
                w = i - currentStart;
                if (w > 0) {
                    width += (float)fm.charsWidth(this.text, currentStart, w);
                }
                currentStart = i + 1;
                width = e.nextTabStop(width, 0);
            }
            w = endBefore - currentStart;
            width += (float)fm.charsWidth(this.text, currentStart, w);
        }
        return width - x0;
    }

    public Rectangle listOffsetToView(RSyntaxTextArea textArea, TabExpander e, int pos, int x0, Rectangle rect) {
        float stableX = x0;
        FontMetrics fm = null;
        for (Token token = this; token != null && token.isPaintable(); token = token.getNextToken()) {
            int i;
            fm = textArea.getFontMetricsForTokenType(token.type);
            if (fm == null) {
                return rect;
            }
            char[] text = token.text;
            int start = token.textOffset;
            int end = start + token.textCount;
            if (token.containsPosition(pos)) {
                end = start + (pos - token.offset);
                for (i = start; i < end; ++i) {
                    if (text[i] != '\t') continue;
                    stableX += (float)fm.charsWidth(text, start, i - start + 1);
                    stableX = e.nextTabStop(stableX, 0);
                    start = i + 1;
                }
                int temp = fm.charsWidth(text, start, i - start);
                rect.x = (int)stableX + temp;
                rect.width = text[i] == '\t' ? fm.charWidth(' ') : fm.charsWidth(text, start, i - start + 1) - temp;
                return rect;
            }
            for (i = start; i < end; ++i) {
                if (text[i] != '\t') continue;
                stableX += (float)fm.charsWidth(text, start, i - start + 1);
                stableX = e.nextTabStop(stableX, 0);
                start = i + 1;
            }
            stableX += (float)fm.charsWidth(text, start, i - start);
        }
        rect.x = (int)stableX;
        rect.width = 1;
        return rect;
    }

    public float paint(Graphics2D g, float x, float y, RSyntaxTextArea host, TabExpander e, float clipStart) {
        int origX = (int)x;
        int end = this.textOffset + this.textCount;
        float nextX = x;
        int flushLen = 0;
        int flushIndex = this.textOffset;
        Color fg = host.getForegroundForToken(this);
        Color bg = host.getBackgroundForTokenType(this.type);
        g.setFont(host.getFontForTokenType(this.type));
        FontMetrics fm = host.getFontMetricsForTokenType(this.type);
        block3: for (int i = this.textOffset; i < end; ++i) {
            switch (this.text[i]) {
                case '\t': {
                    nextX = e.nextTabStop(x + (float)fm.charsWidth(this.text, flushIndex, flushLen), 0);
                    if (bg != null) {
                        this.paintBackground(x, y, nextX - x, fm.getHeight(), g, fm.getAscent(), host, bg);
                    }
                    if (flushLen > 0) {
                        g.setColor(fg);
                        g.drawString(new String(this.text, flushIndex, flushLen), x, y);
                        flushLen = 0;
                    }
                    flushIndex = i + 1;
                    x = nextX;
                    continue block3;
                }
                default: {
                    ++flushLen;
                }
            }
        }
        nextX = x + (float)fm.charsWidth(this.text, flushIndex, flushLen);
        if (flushLen > 0 && nextX >= clipStart) {
            if (bg != null) {
                this.paintBackground(x, y, nextX - x, fm.getHeight(), g, fm.getAscent(), host, bg);
            }
            g.setColor(fg);
            g.drawString(new String(this.text, flushIndex, flushLen), x, y);
        }
        if (host.getUnderlineForToken(this)) {
            g.setColor(fg);
            int y2 = (int)(y + 1.0f);
            g.drawLine(origX, y2, (int)nextX, y2);
        }
        return nextX;
    }
}

