/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class XmlFoldParser
implements FoldParser {
    private static final char[] MARKUP_CLOSING_TAG_START = new char[]{'<', '/'};
    private static final char[] MARKUP_SHORT_TAG_END = new char[]{'/', '>'};
    private static final char[] MLC_END = new char[]{'-', '-', '>'};

    public List getFolds(RSyntaxTextArea textArea) {
        ArrayList<Fold> folds = new ArrayList<Fold>();
        Fold currentFold = null;
        int lineCount = textArea.getLineCount();
        boolean inMLC = false;
        int mlcStart = 0;
        try {
            for (int line = 0; line < lineCount; ++line) {
                for (Token t = textArea.getTokenListForLine(line); t != null && t.isPaintable(); t = t.getNextToken()) {
                    if (t.isComment()) {
                        if (inMLC) {
                            if (!t.endsWith(MLC_END)) continue;
                            int mlcEnd = t.offset + t.textCount - 1;
                            if (currentFold == null) {
                                currentFold = new Fold(1, textArea, mlcStart);
                                currentFold.setEndOffset(mlcEnd);
                                folds.add(currentFold);
                                currentFold = null;
                            } else {
                                currentFold = currentFold.createChild(1, mlcStart);
                                currentFold.setEndOffset(mlcEnd);
                                currentFold = currentFold.getParent();
                            }
                            inMLC = false;
                            mlcStart = 0;
                            continue;
                        }
                        if (t.type != 2) continue;
                        inMLC = true;
                        mlcStart = t.offset;
                        continue;
                    }
                    if (t.type == 25 && t.isSingleChar('<')) {
                        if (currentFold == null) {
                            currentFold = new Fold(0, textArea, t.offset);
                            folds.add(currentFold);
                            continue;
                        }
                        currentFold = currentFold.createChild(0, t.offset);
                        continue;
                    }
                    if (t.is(25, MARKUP_SHORT_TAG_END)) {
                        if (currentFold == null) continue;
                        Fold parentFold = currentFold.getParent();
                        currentFold.removeFromParent();
                        currentFold = parentFold;
                        continue;
                    }
                    if (!t.is(25, MARKUP_CLOSING_TAG_START) || currentFold == null) continue;
                    currentFold.setEndOffset(t.offset);
                    Fold parentFold = currentFold.getParent();
                    if (currentFold.isOnSingleLine()) {
                        currentFold.removeFromParent();
                    }
                    currentFold = parentFold;
                }
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return folds;
    }
}

