/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fife.io.DocumentReader;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends AbstractParser {
    private SAXParserFactory spf;
    private RSyntaxTextArea textArea;
    private DefaultParseResult result;

    public XMLParser(RSyntaxTextArea textArea) {
        this.textArea = textArea;
        this.result = new DefaultParseResult(this);
        try {
            this.spf = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError fce) {
            fce.printStackTrace();
        }
    }

    public ParseResult parse(RSyntaxDocument doc, String style) {
        this.result.clearNotices();
        Element root = doc.getDefaultRootElement();
        this.result.setParsedLines(0, root.getElementCount() - 1);
        if (this.spf == null) {
            return this.result;
        }
        try {
            SAXParser sp = this.spf.newSAXParser();
            Handler handler = new Handler();
            DocumentReader r = new DocumentReader(doc);
            InputSource input = new InputSource(r);
            sp.parse(input, (DefaultHandler)handler);
            r.close();
        }
        catch (SAXParseException spe) {
        }
        catch (Exception e) {
            e.printStackTrace();
            this.result.addNotice(new DefaultParserNotice(this, "Error parsing XML: " + e.getMessage(), 0, -1, -1));
        }
        return this.result;
    }

    private class Handler
    extends DefaultHandler {
        private Handler() {
        }

        private void doError(SAXParseException e) {
            int line = e.getLineNumber() - 1;
            try {
                int offs = XMLParser.this.textArea.getLineStartOffset(line);
                int len = XMLParser.this.textArea.getLineEndOffset(line) - offs + 1;
                DefaultParserNotice pn = new DefaultParserNotice(XMLParser.this, e.getMessage(), line, offs, len);
                XMLParser.this.result.addNotice(pn);
                System.err.println(">>> " + offs + "-" + len + " -> " + pn);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }

        public void error(SAXParseException e) throws SAXException {
            this.doError(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.doError(e);
        }

        public void warning(SAXParseException e) throws SAXException {
            this.doError(e);
        }
    }
}

