/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.service.impl;

import com.fhs.common.utils.ConverterUtils;
import com.fhs.core.trans.anno.Trans;
import com.fhs.core.trans.util.ReflectUtils;
import com.fhs.core.trans.vo.VO;
import com.fhs.trans.service.impl.ITransTypeService;
import com.fhs.trans.service.impl.TransService;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class EnumTransService
implements ITransTypeService,
InitializingBean {
    public static final Logger LOGGER = LoggerFactory.getLogger(EnumTransService.class);

    @Override
    public void transOne(VO obj, List<Field> toTransList) {
        Trans tempTrans = null;
        for (Field tempField : toTransList) {
            try {
                tempTrans = tempField.getAnnotation(Trans.class);
                tempField.setAccessible(true);
                Object filedValue = tempField.get(obj);
                if (filedValue == null) continue;
                if (!filedValue.getClass().isEnum()) {
                    LOGGER.error("TransType.ENUM \u5fc5\u987b\u52a0\u5230\u679a\u4e3e\u5b57\u6bb5\u4e0a(\u6682\u65f6\u4e0d\u652f\u6301\u679a\u4e3e\u6570\u7ec4)\uff0c\u5f53\u524d\u5b57\u6bb5:" + tempField.getName());
                    continue;
                }
                Field titleField = ReflectUtils.getDeclaredField(filedValue.getClass(), (String)tempTrans.key());
                titleField.setAccessible(true);
                String transResult = ConverterUtils.toString(titleField.get(filedValue));
                this.setRef(tempTrans, obj, transResult);
                if (obj.getTransMap() == null) continue;
                obj.getTransMap().put(tempField.getName() + "Name", transResult);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("IllegalAccessException", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("trans enum error", (Throwable)e);
            }
        }
    }

    @Override
    public void transMore(List<? extends VO> objList, List<Field> toTransList) {
        objList.forEach(obj -> this.transOne((VO)obj, toTransList));
    }

    public void afterPropertiesSet() throws Exception {
        TransService.registerTransType("enum", this);
    }
}

