/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.common.spring;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

public class SpringClassScanner {
    public static final String RESOURCE_PATTERN = "**/*.class";
    private Set<String> scanPackages = new HashSet<String>();
    private Set<TypeFilter> typeFilters = new HashSet<TypeFilter>();
    private boolean filterFlag = true;

    private SpringClassScanner() {
    }

    public Set<Class<?>> scan() throws ClassNotFoundException, IOException {
        HashSet classSet = new HashSet();
        if (!this.scanPackages.isEmpty()) {
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
            CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
            for (String pkg : this.scanPackages) {
                Resource[] resources;
                String packageSearchPath = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)pkg)) + "/" + RESOURCE_PATTERN;
                for (Resource resource : resources = resourcePatternResolver.getResources(packageSearchPath)) {
                    if (!resource.isReadable()) continue;
                    MetadataReader reader = readerFactory.getMetadataReader(resource);
                    String className = reader.getClassMetadata().getClassName();
                    if (!this.matched(reader, (MetadataReaderFactory)readerFactory)) continue;
                    classSet.add(Class.forName(className));
                }
            }
        }
        return classSet;
    }

    private boolean matched(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        if (this.filterFlag) {
            return this.filterAll(reader, readerFactory);
        }
        return this.filterWhether(reader, readerFactory);
    }

    private boolean filterAll(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        if (!this.typeFilters.isEmpty()) {
            for (TypeFilter filter : this.typeFilters) {
                if (filter.match(reader, readerFactory)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean filterWhether(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        if (!this.typeFilters.isEmpty()) {
            for (TypeFilter filter : this.typeFilters) {
                if (!filter.match(reader, readerFactory)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<String> getScanPackages() {
        return this.scanPackages;
    }

    public void setScanPackages(Set<String> scanPackages) {
        this.scanPackages = scanPackages;
    }

    public Set<TypeFilter> getTypeFilters() {
        return this.typeFilters;
    }

    public void setTypeFilters(Set<TypeFilter> typeFilters) {
        this.typeFilters = typeFilters;
    }

    public boolean isFilterFlag() {
        return this.filterFlag;
    }

    public void setFilterFlag(boolean filterFlag) {
        this.filterFlag = filterFlag;
    }

    public static class Builder {
        private SpringClassScanner scanner = new SpringClassScanner();

        public Builder scanPackage(String scanPackage) {
            this.scanner.getScanPackages().add(scanPackage);
            return this;
        }

        public Builder typeFilter(TypeFilter typeFilter) {
            this.scanner.getTypeFilters().add(typeFilter);
            return this;
        }

        public Builder filterFlag(boolean filterFlag) {
            this.scanner.setFilterFlag(filterFlag);
            return this;
        }

        public SpringClassScanner build() {
            return this.scanner;
        }
    }
}

