/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.javaluator;

public class Operator {
    private final String symbol;
    private final int precedence;
    private final int operandCount;
    private final Associativity associativity;

    public Operator(String symbol, int operandCount, Associativity associativity, int precedence) {
        if (symbol == null || associativity == null) {
            throw new IllegalArgumentException("Operator symbol and associativity can't be null");
        }
        if (!symbol.trim().equals(symbol)) {
            throw new IllegalArgumentException("Operator can't start or end by a blank char");
        }
        if (symbol.isEmpty()) {
            throw new IllegalArgumentException("Operator symbol can't be empty");
        }
        if (operandCount < 1 || operandCount > 2) {
            throw new IllegalArgumentException("Only unary and binary operators are supported");
        }
        if (Associativity.NONE.equals((Object)associativity)) {
            throw new IllegalArgumentException("None associativity operators are not supported");
        }
        this.symbol = symbol;
        this.operandCount = operandCount;
        this.associativity = associativity;
        this.precedence = precedence;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getOperandCount() {
        return this.operandCount;
    }

    public Associativity getAssociativity() {
        return this.associativity;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.operandCount;
        result = 31 * result + this.associativity.hashCode();
        result = 31 * result + this.symbol.hashCode();
        result = 31 * result + this.precedence;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Operator)) {
            return false;
        }
        Operator other = (Operator)obj;
        return this.associativity == other.associativity && this.operandCount == other.operandCount && this.symbol.equals(other.symbol) && this.precedence == other.precedence;
    }

    public static enum Associativity {
        LEFT,
        RIGHT,
        NONE;

    }
}

