/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.uuid.impl;

import com.fasterxml.uuid.EthernetAddress;
import com.fasterxml.uuid.NoArgGenerator;
import com.fasterxml.uuid.UUIDTimer;
import com.fasterxml.uuid.UUIDType;
import com.fasterxml.uuid.impl.UUIDUtil;
import java.util.UUID;

public class TimeBasedGenerator
extends NoArgGenerator {
    protected final EthernetAddress _ethernetAddress;
    protected final UUIDTimer _timer;
    protected final byte[] _uuidBytes = new byte[16];

    public TimeBasedGenerator(EthernetAddress ethAddr, UUIDTimer timer) {
        if (ethAddr == null) {
            ethAddr = EthernetAddress.constructMulticastAddress();
        }
        this._ethernetAddress = ethAddr;
        this._timer = timer;
    }

    @Override
    public UUIDType getType() {
        return UUIDType.TIME_BASED;
    }

    public EthernetAddress getEthernetAddress() {
        return this._ethernetAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID generate() {
        byte[] byArray = this._uuidBytes;
        synchronized (this._uuidBytes) {
            this._ethernetAddress.toByteArray(this._uuidBytes, 10);
            long timestamp = this._timer.getTimestamp(this._uuidBytes);
            // ** MonitorExit[var3_1] (shouldn't be in output)
            int clockHi = (int)(timestamp >>> 32);
            int clockLo = (int)timestamp;
            this._uuidBytes[6] = (byte)(clockHi >>> 24);
            this._uuidBytes[7] = (byte)(clockHi >>> 16);
            this._uuidBytes[4] = (byte)(clockHi >>> 8);
            this._uuidBytes[5] = (byte)clockHi;
            this._uuidBytes[0] = (byte)(clockLo >>> 24);
            this._uuidBytes[1] = (byte)(clockLo >>> 16);
            this._uuidBytes[2] = (byte)(clockLo >>> 8);
            this._uuidBytes[3] = (byte)clockLo;
            return UUIDUtil.constructUUID(UUIDType.TIME_BASED, this._uuidBytes);
        }
    }
}

