/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.scala.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.module.scala.deser.TupleDeserializer$;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public class TupleDeserializer
extends StdDeserializer<Product>
implements ContextualDeserializer {
    private final JavaType javaType;
    private final DeserializationConfig config;
    private final Seq<JsonDeserializer<Object>> valueDeserializers;
    private final Seq<TypeDeserializer> typeDeserializers;
    private final Class cls;
    private final Constructor[] ctors;
    private final Constructor ctor;

    public static Seq $lessinit$greater$default$3() {
        return TupleDeserializer$.MODULE$.$lessinit$greater$default$3();
    }

    public static Seq $lessinit$greater$default$4() {
        return TupleDeserializer$.MODULE$.$lessinit$greater$default$4();
    }

    public TupleDeserializer(JavaType javaType, DeserializationConfig config, Seq<JsonDeserializer<Object>> valueDeserializers, Seq<TypeDeserializer> typeDeserializers) {
        this.javaType = javaType;
        this.config = config;
        this.valueDeserializers = valueDeserializers;
        this.typeDeserializers = typeDeserializers;
        super(Product.class);
        this.cls = javaType.getRawClass();
        this.ctors = this.cls().getConstructors();
        if (this.ctors().length != 1) {
            throw new IllegalStateException("Tuple should have exactly one constructor");
        }
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.ctors());
        this.ctor = (Constructor)ArrayOps$.MODULE$.head$extension(object);
    }

    public Class<?> cls() {
        return this.cls;
    }

    public Constructor<?>[] ctors() {
        return this.ctors;
    }

    public Constructor<?> ctor() {
        return this.ctor;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        IndexedSeq paramTypes = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.javaType.containedTypeCount()).map((Function1 & Serializable)i -> this.$anonfun$5(BoxesRunTime.unboxToInt((Object)i)));
        IndexedSeq paramDesers = (IndexedSeq)paramTypes.map((Function1 & Serializable)_$1 -> ctxt.findContextualValueDeserializer(_$1, property));
        BeanDeserializerFactory factory = BeanDeserializerFactory.instance;
        Seq typeDesers = property != null ? (Seq)paramTypes.map((Function1 & Serializable)_$2 -> factory.findPropertyTypeDeserializer(ctxt.getConfig(), _$2, property.getMember())) : (Seq)paramTypes.map((Function1 & Serializable)_$3 -> factory.findTypeDeserializer(this.config, _$3));
        return new TupleDeserializer(this.javaType, this.config, (Seq<JsonDeserializer<Object>>)paramDesers, (Seq<TypeDeserializer>)typeDesers);
    }

    public Product deserialize(JsonParser jp, DeserializationContext ctxt) {
        Product product;
        if (jp.isExpectedStartArrayToken()) {
            JsonToken t;
            Seq params = (Seq)((IterableOps)this.valueDeserializers.zip(this.typeDeserializers)).map((Function1 & Serializable)x$1 -> {
                TypeDeserializer typeDeser;
                JsonDeserializer deser;
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    deser = (JsonDeserializer)tuple2._1();
                    typeDeser = (TypeDeserializer)tuple2._2();
                    jp.nextToken();
                } else {
                    throw new MatchError((Object)tuple2);
                }
                return typeDeser == null ? deser.deserialize(jp, ctxt) : deser.deserializeWithType(jp, ctxt, typeDeser);
            });
            JsonToken jsonToken = t = jp.nextToken();
            JsonToken jsonToken2 = JsonToken.END_ARRAY;
            if (jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2)) {
                ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "expected closing END_ARRAY after deserialized value");
                product = null;
            } else {
                product = (Product)this.ctor().newInstance((Object[])Arrays$.MODULE$.seqToArray(params, Object.class));
            }
        } else {
            product = (Product)ctxt.handleUnexpectedToken(this.javaType.getRawClass(), jp);
        }
        return product;
    }

    private final /* synthetic */ JavaType $anonfun$5(int i) {
        return this.javaType.containedType(i);
    }
}

