/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.mrbean;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.module.mrbean.BeanBuilder;
import com.fasterxml.jackson.module.mrbean.PackageVersion;
import com.fasterxml.jackson.module.mrbean.TypeBuilder;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;

public class AbstractTypeMaterializer
extends AbstractTypeResolver
implements Versioned {
    protected static final int DEFAULT_FEATURE_FLAGS = Feature.collectDefaults();
    public static final String DEFAULT_PACKAGE_FOR_GENERATED = "com.fasterxml.jackson.module.mrbean.generated.";
    protected final MyClassLoader _classLoader;
    protected int _featureFlags = DEFAULT_FEATURE_FLAGS;
    protected String _defaultPackage = "com.fasterxml.jackson.module.mrbean.generated.";

    public AbstractTypeMaterializer() {
        this(null);
    }

    public AbstractTypeMaterializer(ClassLoader parentClassLoader) {
        if (parentClassLoader == null) {
            parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        this._classLoader = new MyClassLoader(parentClassLoader);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public final boolean isEnabled(Feature f) {
        return (this._featureFlags & f.getMask()) != 0;
    }

    public void enable(Feature f) {
        this._featureFlags |= f.getMask();
    }

    public void disable(Feature f) {
        this._featureFlags &= ~f.getMask();
    }

    public void set(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
    }

    public void setDefaultPackage(String defPkg) {
        if (!defPkg.endsWith(".")) {
            defPkg = defPkg + ".";
        }
        this._defaultPackage = defPkg;
    }

    public JavaType resolveAbstractType(DeserializationConfig config, BeanDescription beanDesc) {
        JavaType type = beanDesc.getType();
        if (!this._suitableType(type)) {
            return null;
        }
        Class<?> materializedType = type.hasGenericTypes() ? this.materializeGenericType((MapperConfig<?>)config, type) : this.materializeRawType((MapperConfig<?>)config, beanDesc.getClassInfo());
        return config.constructType(materializedType);
    }

    @Deprecated
    public JavaType resolveAbstractType(DeserializationConfig config, JavaType type) {
        if (!this._suitableType(type)) {
            return null;
        }
        Class<?> materializedType = type.hasGenericTypes() ? this.materializeGenericType((MapperConfig<?>)config, type) : this.materializeRawType((MapperConfig<?>)config, AnnotatedClassResolver.resolve((MapperConfig)config, (JavaType)type, (ClassIntrospector.MixInResolver)config));
        return config.constructType(materializedType);
    }

    public Class<?> materializeGenericType(MapperConfig<?> config, JavaType type) {
        Class cls = type.getRawClass();
        String abstractName = this._defaultPackage + "abstract." + cls.getName() + "_TYPE_RESOLVE";
        TypeBuilder tb = new TypeBuilder(type);
        byte[] code = tb.buildAbstractBase(abstractName);
        Class<?> raw = this._loadAndResolve(abstractName, code, cls);
        AnnotatedClass ac = AnnotatedClassResolver.resolve(config, (JavaType)config.getTypeFactory().constructType(raw), config);
        String implClassName = this._defaultPackage + cls.getName();
        return this._materializeRawType(config, ac, implClassName);
    }

    public Class<?> materializeRawType(MapperConfig<?> config, AnnotatedClass typeDef) {
        Class rawType = typeDef.getRawType();
        String implClassName = this._defaultPackage + rawType.getName();
        return this._materializeRawType(config, typeDef, implClassName);
    }

    protected Class<?> _materializeRawType(MapperConfig<?> config, AnnotatedClass typeDef, String nameToUse) {
        JavaType type = typeDef.getType();
        Class rawType = type.getRawClass();
        BeanBuilder builder = BeanBuilder.construct(config, type, typeDef);
        byte[] bytecode = builder.implement(this.isEnabled(Feature.FAIL_ON_UNMATERIALIZED_METHOD)).build(nameToUse);
        return this._loadAndResolve(nameToUse, bytecode, rawType);
    }

    protected Class<?> _loadAndResolve(String className, byte[] bytecode, Class<?> rawType) {
        return this._classLoader.loadAndResolve(className, bytecode, rawType);
    }

    protected boolean _suitableType(JavaType type) {
        if (type.isContainerType() || type.isReferenceType() || type.isEnumType() || type.isPrimitive()) {
            return false;
        }
        Class cls = type.getRawClass();
        if (cls == Number.class || cls == Date.class || cls == Calendar.class || cls == CharSequence.class || cls == Iterable.class || cls == Iterator.class || cls == Serializable.class) {
            return false;
        }
        if (!Modifier.isPublic(cls.getModifiers())) {
            if (this.isEnabled(Feature.FAIL_ON_NON_PUBLIC_TYPES)) {
                throw new IllegalArgumentException("Can not materialize implementation of " + cls + " since it is not public ");
            }
            return false;
        }
        return true;
    }

    static class MyClassLoader
    extends ClassLoader {
        public MyClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> loadAndResolve(String className, byte[] byteCode, Class<?> targetClass) throws IllegalArgumentException {
            Class<?> impl;
            Class<?> old = this.findLoadedClass(className);
            if (old != null && targetClass.isAssignableFrom(old)) {
                return old;
            }
            try {
                impl = this.defineClass(className, byteCode, 0, byteCode.length);
            }
            catch (LinkageError e) {
                throw new IllegalArgumentException("Failed to load class '" + className + "': " + e.getMessage(), e);
            }
            this.resolveClass(impl);
            return impl;
        }
    }

    public static enum Feature {
        FAIL_ON_UNMATERIALIZED_METHOD(false),
        FAIL_ON_NON_PUBLIC_TYPES(true);

        final boolean _defaultState;

        protected static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

