/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.factories;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.JsonSchemaProducer;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;

public class ArrayVisitor
extends JsonArrayFormatVisitor.Base
implements JsonSchemaProducer {
    protected final ArraySchema schema;
    protected SerializerProvider provider;
    private WrapperFactory wrapperFactory = new WrapperFactory();

    public ArrayVisitor(SerializerProvider serializerProvider, ArraySchema arraySchema) {
        this.provider = serializerProvider;
        this.schema = arraySchema;
    }

    @Override
    public JsonSchema getSchema() {
        return this.schema;
    }

    public SerializerProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SerializerProvider serializerProvider) {
        this.provider = serializerProvider;
    }

    public WrapperFactory getWrapperFactory() {
        return this.wrapperFactory;
    }

    public void setWrapperFactory(WrapperFactory wrapperFactory) {
        this.wrapperFactory = wrapperFactory;
    }

    public void itemsFormat(JsonFormatVisitable jsonFormatVisitable, JavaType javaType) throws JsonMappingException {
        if (javaType.getRawClass() != Object.class) {
            SchemaFactoryWrapper schemaFactoryWrapper = this.wrapperFactory.getWrapper(this.getProvider());
            jsonFormatVisitable.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)schemaFactoryWrapper, javaType);
            this.schema.setItemsSchema(schemaFactoryWrapper.finalSchema());
        }
    }

    public void itemsFormat(JsonFormatTypes jsonFormatTypes) throws JsonMappingException {
        this.schema.setItemsSchema(JsonSchema.minimalForFormat(jsonFormatTypes));
    }
}

