/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public class ObjectMethodPropertyWriter
extends OptimizedBeanPropertyWriter<ObjectMethodPropertyWriter> {
    public ObjectMethodPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, JsonSerializer<Object> ser) {
        super(src, acc, index, ser);
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new ObjectMethodPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public ObjectMethodPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new ObjectMethodPropertyWriter(this, acc, this._propertyIndex, (JsonSerializer<Object>)this._serializer);
    }

    @Override
    public final void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean, jgen, prov);
            return;
        }
        try {
            Class<?> cls;
            PropertySerializerMap map;
            Object value = this._propertyAccessor.objectGetter(bean, this._propertyIndex);
            if (value == null) {
                if (this._nullSerializer != null) {
                    jgen.writeFieldName((SerializableString)this._name);
                    this._nullSerializer.serialize(null, jgen, prov);
                } else if (!this._suppressNulls) {
                    jgen.writeFieldName((SerializableString)this._name);
                    prov.defaultSerializeNull(jgen);
                }
                return;
            }
            JsonSerializer ser = this._serializer;
            if (ser == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
                ser = this._findAndAddDynamic(map, cls, prov);
            }
            if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? ser.isEmpty(value) : this._suppressableValue.equals(value))) {
                return;
            }
            if (value == bean) {
                this._handleSelfReference(bean, jgen, prov, ser);
            }
            jgen.writeFieldName((SerializableString)this._name);
            if (this._typeSerializer == null) {
                ser.serialize(value, jgen, prov);
            } else {
                ser.serializeWithType(value, jgen, prov, this._typeSerializer);
            }
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, e);
            this.fallbackWriter.serializeAsField(bean, jgen, prov);
        }
        catch (SecurityException e) {
            this._reportProblem(bean, e);
            this.fallbackWriter.serializeAsField(bean, jgen, prov);
        }
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        if (!this.broken) {
            try {
                Class<?> cls;
                PropertySerializerMap map;
                Object value = this._propertyAccessor.objectGetter(bean, this._propertyIndex);
                if (value == null) {
                    if (this._nullSerializer != null) {
                        this._nullSerializer.serialize(null, jgen, prov);
                    } else if (this._suppressNulls) {
                        this.serializeAsPlaceholder(bean, jgen, prov);
                    } else {
                        prov.defaultSerializeNull(jgen);
                    }
                    return;
                }
                JsonSerializer ser = this._serializer;
                if (ser == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
                    ser = this._findAndAddDynamic(map, cls, prov);
                }
                if (this._suppressableValue != null) {
                    if (MARKER_FOR_EMPTY == this._suppressableValue) {
                        if (ser.isEmpty(value)) {
                            this.serializeAsPlaceholder(bean, jgen, prov);
                            return;
                        }
                    } else if (this._suppressableValue.equals(value)) {
                        this.serializeAsPlaceholder(bean, jgen, prov);
                        return;
                    }
                }
                if (value == bean) {
                    this._handleSelfReference(bean, jgen, prov, ser);
                }
                if (this._typeSerializer == null) {
                    ser.serialize(value, jgen, prov);
                } else {
                    ser.serializeWithType(value, jgen, prov, this._typeSerializer);
                }
                return;
            }
            catch (IllegalAccessError e) {
                this._reportProblem(bean, e);
            }
            catch (SecurityException e) {
                this._reportProblem(bean, e);
            }
        }
        this.fallbackWriter.serializeAsElement(bean, jgen, prov);
    }
}

