/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import java.io.IOException;
import java.lang.annotation.Annotation;

abstract class OptimizedSettableBeanProperty<T extends OptimizedSettableBeanProperty<T>>
extends SettableBeanProperty {
    private static final long serialVersionUID = -6113781823964100309L;
    protected final SettableBeanProperty _originalSettable;
    protected final BeanPropertyMutator _propertyMutator;
    protected final int _propertyIndex;

    public OptimizedSettableBeanProperty(SettableBeanProperty settableBeanProperty, BeanPropertyMutator beanPropertyMutator, int n) {
        super(settableBeanProperty);
        this._originalSettable = settableBeanProperty;
        this._propertyMutator = beanPropertyMutator;
        this._propertyIndex = n;
    }

    protected OptimizedSettableBeanProperty(OptimizedSettableBeanProperty<T> optimizedSettableBeanProperty, JsonDeserializer<?> jsonDeserializer) {
        super(optimizedSettableBeanProperty, jsonDeserializer);
        this._originalSettable = optimizedSettableBeanProperty;
        this._propertyMutator = optimizedSettableBeanProperty._propertyMutator;
        this._propertyIndex = optimizedSettableBeanProperty._propertyIndex;
    }

    protected OptimizedSettableBeanProperty(OptimizedSettableBeanProperty<T> optimizedSettableBeanProperty, String string) {
        super(optimizedSettableBeanProperty, string);
        this._originalSettable = optimizedSettableBeanProperty;
        this._propertyMutator = optimizedSettableBeanProperty._propertyMutator;
        this._propertyIndex = optimizedSettableBeanProperty._propertyIndex;
    }

    public abstract T withMutator(BeanPropertyMutator var1);

    public abstract T withValueDeserializer(JsonDeserializer<?> var1);

    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return (A)this._originalSettable.getAnnotation(clazz);
    }

    public AnnotatedMember getMember() {
        return this._originalSettable.getMember();
    }

    public abstract void deserializeAndSet(JsonParser var1, DeserializationContext var2, Object var3) throws IOException, JsonProcessingException;

    public abstract void set(Object var1, Object var2) throws IOException;

    public abstract Object deserializeSetAndReturn(JsonParser var1, DeserializationContext var2, Object var3) throws IOException, JsonProcessingException;

    public Object setAndReturn(Object object, Object object2) throws IOException {
        return this._originalSettable.setAndReturn(object, object2);
    }

    protected final int _deserializeInt(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_NUMBER_INT) {
            return jsonParser.getIntValue();
        }
        return jsonParser.getValueAsInt();
    }

    protected final long _deserializeLong(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_NUMBER_INT) {
            return jsonParser.getLongValue();
        }
        return jsonParser.getValueAsLong();
    }

    protected final String _deserializeString(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_NULL) {
            if (this._nullProvider == null) {
                return null;
            }
            return (String)this._nullProvider.nullValue(deserializationContext);
        }
        String string = jsonParser.getValueAsString();
        if (string != null) {
            return string;
        }
        return this._convertToString(jsonParser, deserializationContext);
    }

    protected final String _convertToString(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object object = jsonParser.getEmbeddedObject();
            if (object == null) {
                return null;
            }
            if (object instanceof byte[]) {
                return Base64Variants.getDefaultVariant().encode((byte[])object, false);
            }
            return object.toString();
        }
        if (jsonToken.isScalarValue()) {
            return jsonParser.getText();
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        throw deserializationContext.mappingException(String.class);
    }
}

