/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import com.fasterxml.jackson.module.afterburner.deser.CreatorOptimizer;
import com.fasterxml.jackson.module.afterburner.deser.CustomDeserializerBuilder;
import com.fasterxml.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;
import com.fasterxml.jackson.module.afterburner.deser.PropertyMutatorCollector;
import com.fasterxml.jackson.module.afterburner.util.MyClassLoader;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.deser.BeanDeserializerBuilder;
import org.codehaus.jackson.map.deser.BeanDeserializerModifier;
import org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.codehaus.jackson.map.deser.ValueInstantiator;
import org.codehaus.jackson.map.deser.std.StdValueInstantiator;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMember;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeserializerModifier
extends BeanDeserializerModifier {
    protected final MyClassLoader _classLoader;
    protected final boolean _useCustomDeserializer;

    public DeserializerModifier(ClassLoader cl, boolean useCustomDeserializer) {
        this._classLoader = cl == null ? null : new MyClassLoader(cl, false);
        this._useCustomDeserializer = useCustomDeserializer;
    }

    public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BasicBeanDescription beanDesc, BeanDeserializerBuilder builder) {
        ValueInstantiator inst;
        Class beanClass = beanDesc.getBeanClass();
        if (this._classLoader != null && Modifier.isPrivate(beanClass.getModifiers())) {
            return builder;
        }
        PropertyMutatorCollector collector = new PropertyMutatorCollector();
        List<OptimizedSettableBeanProperty<?>> newProps = this.findOptimizableProperties(collector, builder.getProperties());
        if (!newProps.isEmpty()) {
            BeanPropertyMutator mutator = collector.buildMutator(beanClass, this._classLoader);
            for (OptimizedSettableBeanProperty<?> prop : newProps) {
                builder.addOrReplaceProperty(prop.withMutator(mutator), true);
            }
        }
        if ((inst = builder.getValueInstantiator()).getClass() == StdValueInstantiator.class && inst.canCreateUsingDefault() && (inst = new CreatorOptimizer(beanClass, this._classLoader, (StdValueInstantiator)inst).createOptimized()) != null) {
            builder.setValueInstantiator(inst);
        }
        if (this._useCustomDeserializer && builder.getClass() == BeanDeserializerBuilder.class) {
            return new CustomDeserializerBuilder(builder);
        }
        return builder;
    }

    protected List<OptimizedSettableBeanProperty<?>> findOptimizableProperties(PropertyMutatorCollector collector, Iterator<SettableBeanProperty> propIterator) {
        ArrayList newProps = new ArrayList();
        while (propIterator.hasNext()) {
            Class type;
            SettableBeanProperty prop = propIterator.next();
            AnnotatedMember member = prop.getMember();
            if (Modifier.isPrivate(member.getMember().getModifiers())) continue;
            if (prop instanceof SettableBeanProperty.MethodProperty) {
                type = ((AnnotatedMethod)member).getParameterClass(0);
                if (type.isPrimitive()) {
                    if (type == Integer.TYPE) {
                        newProps.add(collector.addIntSetter(prop));
                        continue;
                    }
                    if (type != Long.TYPE) continue;
                    newProps.add(collector.addLongSetter(prop));
                    continue;
                }
                if (type == String.class) {
                    newProps.add(collector.addStringSetter(prop));
                    continue;
                }
                newProps.add(collector.addObjectSetter(prop));
                continue;
            }
            if (!(prop instanceof SettableBeanProperty.FieldProperty)) continue;
            type = ((AnnotatedField)member).getRawType();
            if (type.isPrimitive()) {
                if (type == Integer.TYPE) {
                    newProps.add(collector.addIntField(prop));
                    continue;
                }
                if (type != Long.TYPE) continue;
                newProps.add(collector.addLongField(prop));
                continue;
            }
            if (type == String.class) {
                newProps.add(collector.addStringField(prop));
                continue;
            }
            newProps.add(collector.addObjectField(prop));
        }
        return newProps;
    }
}

