/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.impl.BeanDefinition;
import com.fasterxml.jackson.jr.ob.impl.BeanProperty;
import com.fasterxml.jackson.jr.ob.impl.CollectionBuilder;
import com.fasterxml.jackson.jr.ob.impl.MapBuilder;
import com.fasterxml.jackson.jr.ob.impl.TypeDetector;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class JSONReader {
    protected final int _features;
    protected final boolean _arraysAsLists;
    protected final TreeCodec _treeCodec;
    protected final TypeDetector _typeDetector;
    protected final MapBuilder _mapBuilder;
    protected final CollectionBuilder _collectionBuilder;
    protected final JsonParser _parser;

    protected JSONReader(int n, TypeDetector typeDetector, TreeCodec treeCodec, CollectionBuilder collectionBuilder, MapBuilder mapBuilder) {
        this._features = n;
        this._typeDetector = typeDetector;
        this._treeCodec = treeCodec;
        this._collectionBuilder = collectionBuilder;
        this._mapBuilder = mapBuilder;
        this._arraysAsLists = JSON.Feature.READ_JSON_ARRAYS_AS_JAVA_ARRAYS.isDisabled(n);
        this._parser = null;
    }

    protected JSONReader(JSONReader jSONReader, JsonParser jsonParser) {
        int n;
        this._features = n = jSONReader._features;
        this._typeDetector = jSONReader._typeDetector.perOperationInstance(n);
        this._treeCodec = jSONReader._treeCodec;
        this._collectionBuilder = jSONReader._collectionBuilder.newBuilder(n);
        this._mapBuilder = jSONReader._mapBuilder.newBuilder(n);
        this._arraysAsLists = jSONReader._arraysAsLists;
        this._parser = jsonParser;
    }

    public final JSONReader withFeatures(int n) {
        if (this._features == n) {
            return this;
        }
        return this._with(n, this._typeDetector, this._treeCodec, this._collectionBuilder, this._mapBuilder);
    }

    public final JSONReader with(MapBuilder mapBuilder) {
        if (this._mapBuilder == mapBuilder) {
            return this;
        }
        return this._with(this._features, this._typeDetector, this._treeCodec, this._collectionBuilder, mapBuilder);
    }

    public final JSONReader with(CollectionBuilder collectionBuilder) {
        if (this._collectionBuilder == collectionBuilder) {
            return this;
        }
        return this._with(this._features, this._typeDetector, this._treeCodec, collectionBuilder, this._mapBuilder);
    }

    protected JSONReader _with(int n, TypeDetector typeDetector, TreeCodec treeCodec, CollectionBuilder collectionBuilder, MapBuilder mapBuilder) {
        if (this.getClass() != JSONReader.class) {
            throw new IllegalStateException("Sub-classes MUST override _with(...)");
        }
        return new JSONReader(n, typeDetector, treeCodec, collectionBuilder, mapBuilder);
    }

    public JSONReader perOperationInstance(JsonParser jsonParser) {
        if (this.getClass() != JSONReader.class) {
            throw new IllegalStateException("Sub-classes MUST override perOperationInstance(...)");
        }
        return new JSONReader(this, jsonParser);
    }

    public final Object readValue() throws IOException {
        return this._readFromAny();
    }

    public Map<Object, Object> readMap() throws IOException {
        if (this._parser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw JSONObjectException.from(this._parser, "Can not read a Map: expect to see START_OBJECT ('{'), instead got: " + this._tokenDesc());
        }
        return (Map)this._readFromObject(this._mapBuilder);
    }

    public List<Object> readList() throws IOException {
        if (this._parser.getCurrentToken() != JsonToken.START_ARRAY) {
            throw JSONObjectException.from(this._parser, "Can not read a List: expect to see START_ARRAY ('['), instead got: " + this._tokenDesc());
        }
        return (List)this._readFromArray(this._collectionBuilder, true);
    }

    public <T> List<T> readListOf(Class<T> clazz) throws IOException {
        if (this._parser.getCurrentToken() != JsonToken.START_ARRAY) {
            throw JSONObjectException.from(this._parser, "Can not read a List: expect to see START_ARRAY ('['), instead got: " + this._tokenDesc());
        }
        return (List)this._readFromArray(this._collectionBuilder, clazz, true);
    }

    public Object[] readArray() throws IOException, JsonProcessingException {
        if (this._parser.getCurrentToken() != JsonToken.START_ARRAY) {
            throw JSONObjectException.from(this._parser, "Can not read an array: expect to see START_ARRAY ('['), instead got: " + this._tokenDesc());
        }
        return (Object[])this._readFromArray(this._collectionBuilder, false);
    }

    public <T> T[] readArrayOf(Class<T> clazz) throws IOException, JsonProcessingException {
        if (this._parser.getCurrentToken() != JsonToken.START_ARRAY) {
            throw JSONObjectException.from(this._parser, "Can not read an array: expect to see START_ARRAY ('['), instead got: " + this._tokenDesc());
        }
        return (Object[])this._readFromArray(this._collectionBuilder, clazz, false);
    }

    public <T> T readBean(Class<T> clazz) throws IOException, JsonProcessingException {
        return (T)this._readBean(clazz, this._typeDetector.findFullType(clazz));
    }

    protected Object _readFromAny() throws IOException {
        JsonToken jsonToken = this._parser.getCurrentToken();
        int n = jsonToken == null ? 0 : jsonToken.id();
        switch (n) {
            case 11: {
                return this.nullForRootValue();
            }
            case 1: {
                return this._readFromObject(this._mapBuilder);
            }
            case 3: {
                return this._readFromArray(this._collectionBuilder, this._arraysAsLists);
            }
            case 6: {
                return this.fromString(this._parser.getText());
            }
            case 7: {
                return this._readFromInteger();
            }
            case 8: {
                return this._readFromFloat();
            }
            case 9: {
                return this.fromBoolean(true);
            }
            case 10: {
                return this.fromBoolean(false);
            }
            case 12: {
                return this.fromEmbedded(this._parser.getEmbeddedObject());
            }
        }
        throw JSONObjectException.from(this._parser, "Unexpected value token: " + this._tokenDesc());
    }

    protected Object _readBean(Class<?> clazz, int n) throws IOException {
        block45: {
            if (n < 0) {
                BeanDefinition beanDefinition = this._typeDetector.getBeanDefinition(n);
                JsonToken jsonToken = this._parser.getCurrentToken();
                try {
                    Object object = null;
                    switch (jsonToken) {
                        case VALUE_STRING: {
                            object = beanDefinition.create(this._parser.getText());
                            break;
                        }
                        case VALUE_NUMBER_INT: {
                            object = beanDefinition.create(this._parser.getLongValue());
                            break;
                        }
                        case START_OBJECT: {
                            object = beanDefinition.create();
                            while ((jsonToken = this._parser.nextToken()) == JsonToken.FIELD_NAME) {
                                String string = this._parser.getCurrentName();
                                BeanProperty beanProperty = beanDefinition.findProperty(string);
                                if (beanProperty == null) {
                                    if (JSON.Feature.FAIL_ON_UNKNOWN_BEAN_PROPERTY.isEnabled(this._features)) {
                                        throw JSONObjectException.from(this._parser, "Unrecognized JSON property '" + string + "' for Bean type " + clazz.getName());
                                    }
                                    this._parser.nextToken();
                                    this._parser.skipChildren();
                                    continue;
                                }
                                this._parser.nextToken();
                                Class<?> clazz2 = beanProperty.getType();
                                int n2 = beanProperty.getTypeId();
                                if (n2 == 0 && (n2 = this._typeDetector.findFullType(clazz2)) != 0) {
                                    beanProperty.overridTypeId(n2);
                                }
                                Object object2 = this._readBean(clazz2, n2);
                                beanProperty.setValueFor(object, object2);
                            }
                            break;
                        }
                    }
                    if (object != null) {
                        return object;
                    }
                    break block45;
                }
                catch (Exception exception) {
                    throw JSONObjectException.from(this._parser, "Failed to create an instance of " + clazz.getName() + " due to (" + exception.getClass().getName() + "): " + exception.getMessage(), exception);
                }
            }
            switch (n) {
                case 1: {
                    MapBuilder mapBuilder = this._mapBuilder;
                    if (clazz != Map.class) {
                        mapBuilder = mapBuilder.newBuilder(clazz);
                    }
                    return this._readFromObject(mapBuilder);
                }
                case 2: 
                case 3: {
                    CollectionBuilder collectionBuilder = this._collectionBuilder;
                    if (clazz != List.class && clazz != Collection.class) {
                        collectionBuilder = collectionBuilder.newBuilder(clazz);
                    }
                    return this._readFromArray(collectionBuilder, true);
                }
                case 4: {
                    return this._readFromArray(this._collectionBuilder, false);
                }
                case 5: {
                    return this._readIntArray();
                }
                case 8: {
                    return this._treeCodec().readTree(this._parser);
                }
                case 9: 
                case 10: {
                    return this._parser.getValueAsString();
                }
                case 11: {
                    return this._parser.getValueAsString().toCharArray();
                }
                case 12: {
                    return this._readBinary();
                }
                case 17: {
                    return Float.valueOf((float)this._parser.getValueAsDouble());
                }
                case 18: {
                    return this._parser.getValueAsDouble();
                }
                case 13: {
                    return (byte)this._parser.getValueAsInt();
                }
                case 14: {
                    return (short)this._parser.getValueAsInt();
                }
                case 15: {
                    return this._parser.getValueAsInt();
                }
                case 16: {
                    return this._parser.getValueAsLong();
                }
                case 20: {
                    return this._parser.getDecimalValue();
                }
                case 19: {
                    return this._parser.getBigIntegerValue();
                }
                case 21: {
                    return this._parser.getValueAsBoolean();
                }
                case 22: {
                    String string = this._parser.getValueAsString();
                    return Character.valueOf(string == null || string.isEmpty() ? (char)' ' : string.charAt(0));
                }
                case 25: {
                    long l = this._fetchLong(clazz, n);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(l);
                    return calendar;
                }
                case 24: {
                    return new Date(this._fetchLong(clazz, n));
                }
                case 23: {
                    return this._readEnum(clazz);
                }
                case 26: {
                    String string = this._parser.getValueAsString();
                    try {
                        return Class.forName(string);
                    }
                    catch (Exception exception) {
                        throw new JSONObjectException("Failed to bind java.lang.Class from value '" + string + "'");
                    }
                }
                case 27: {
                    return new File(this._parser.getValueAsString());
                }
                case 28: {
                    return UUID.fromString(this._parser.getValueAsString());
                }
                case 29: {
                    return new URL(this._parser.getValueAsString());
                }
                case 30: {
                    return URI.create(this._parser.getValueAsString());
                }
            }
        }
        throw JSONObjectException.from(this._parser, "Can not create a " + clazz.getName() + " instance out of " + this._tokenDesc());
    }

    protected Object _readFromObject(MapBuilder mapBuilder) throws IOException {
        JsonParser jsonParser = this._parser;
        if (jsonParser.nextValue() == JsonToken.END_OBJECT) {
            return mapBuilder.emptyMap();
        }
        Object object = this.fromKey(jsonParser.getCurrentName());
        Object object2 = this._readFromAny();
        if (jsonParser.nextValue() == JsonToken.END_OBJECT) {
            return mapBuilder.singletonMap(object, object2);
        }
        mapBuilder = mapBuilder.start().put(object, object2);
        do {
            mapBuilder = mapBuilder.put(this.fromKey(jsonParser.getCurrentName()), this._readFromAny());
        } while (jsonParser.nextValue() != JsonToken.END_OBJECT);
        return mapBuilder.build();
    }

    protected Object _readFromArray(CollectionBuilder collectionBuilder, boolean bl) throws IOException {
        JsonParser jsonParser = this._parser;
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return bl ? collectionBuilder.emptyCollection() : collectionBuilder.emptyArray();
        }
        Object object = this._readFromAny();
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return bl ? collectionBuilder.singletonCollection(object) : collectionBuilder.singletonArray(object);
        }
        collectionBuilder = collectionBuilder.start().add(object);
        do {
            collectionBuilder = collectionBuilder.add(this._readFromAny());
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return bl ? collectionBuilder.buildCollection() : collectionBuilder.buildArray();
    }

    protected <T> Object _readFromArray(CollectionBuilder collectionBuilder, Class<T> clazz, boolean bl) throws IOException {
        JsonParser jsonParser = this._parser;
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return bl ? collectionBuilder.emptyCollection() : collectionBuilder.emptyArray(clazz);
        }
        int n = this._typeDetector.findFullType(clazz);
        Object object = this._readBean(clazz, n);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return bl ? collectionBuilder.singletonCollection(object) : collectionBuilder.singletonArray(clazz, object);
        }
        collectionBuilder = collectionBuilder.start().add(object);
        do {
            collectionBuilder = collectionBuilder.add(this._readBean(clazz, n));
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return bl ? collectionBuilder.buildCollection() : collectionBuilder.buildArray(clazz);
    }

    protected Object _readFromInteger() throws IOException {
        JsonParser.NumberType numberType = this._parser.getNumberType();
        if (numberType == JsonParser.NumberType.INT) {
            return this._parser.getIntValue();
        }
        if (numberType == JsonParser.NumberType.LONG) {
            return this._parser.getLongValue();
        }
        return this._parser.getBigIntegerValue();
    }

    protected Object _readFromFloat() throws IOException {
        if (!JSON.Feature.USE_BIG_DECIMAL_FOR_FLOATS.isEnabled(this._features)) {
            JsonParser.NumberType numberType = this._parser.getNumberType();
            if (numberType == JsonParser.NumberType.FLOAT) {
                return Float.valueOf(this._parser.getFloatValue());
            }
            if (numberType == JsonParser.NumberType.DOUBLE) {
                return this._parser.getDoubleValue();
            }
        }
        return this._parser.getDecimalValue();
    }

    protected byte[] _readBinary() throws IOException {
        return this._parser.getBinaryValue();
    }

    protected int[] _readIntArray() throws IOException {
        throw new JSONObjectException("Reading of int[] not yet implemented");
    }

    protected Object _readEnum(Class<?> clazz) throws IOException {
        ?[] objArray = clazz.getEnumConstants();
        JsonToken jsonToken = this._parser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            int n = this._parser.getIntValue();
            if (n < 0 || n >= objArray.length) {
                throw new JSONObjectException("Failed to bind Enum " + clazz.getName() + " with index " + n + " (has " + objArray.length + " values)");
            }
            return objArray[n];
        }
        throw new JSONObjectException("Reading of Enums from Strings not yet implemented");
    }

    protected Object fromNull() throws IOException {
        return null;
    }

    protected Object fromBoolean(boolean bl) throws IOException {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object fromKey(String string) throws IOException {
        return string;
    }

    protected Object fromString(String string) throws IOException {
        return string;
    }

    protected Object fromEmbedded(Object object) throws IOException {
        return object;
    }

    public Object nullForRootValue() {
        return null;
    }

    public List<?> nullForRootList() {
        return null;
    }

    public Map<Object, Object> nullForRootMap() {
        return null;
    }

    public Object[] nullForRootArray() {
        return null;
    }

    protected String _tokenDesc() throws IOException {
        return this._tokenDesc(this._parser.getCurrentToken());
    }

    protected String _tokenDesc(JsonToken jsonToken) throws IOException {
        if (jsonToken == null) {
            return "NULL";
        }
        switch (jsonToken) {
            case FIELD_NAME: {
                return "JSON Field name '" + this._parser.getCurrentName() + "'";
            }
            case START_ARRAY: {
                return "JSON Array";
            }
            case START_OBJECT: {
                return "JSON Object";
            }
            case VALUE_FALSE: {
                return "'false'";
            }
            case VALUE_NULL: {
                return "'null'";
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return "JSON Number";
            }
            case VALUE_STRING: {
                return "JSON String";
            }
            case VALUE_TRUE: {
                return "'true'";
            }
        }
        return jsonToken.toString();
    }

    protected TreeCodec _treeCodec() throws JSONObjectException {
        if (this._treeCodec == null) {
            throw new JSONObjectException("No TreeCodec specified: can not bind JSON into TreeNode types");
        }
        return this._treeCodec;
    }

    protected long _fetchLong(Class<?> clazz, int n) throws IOException {
        JsonToken jsonToken = this._parser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return this._parser.getLongValue();
        }
        throw JSONObjectException.from(this._parser, "Can not get long numeric value from JSON (to construct " + clazz.getName() + ") from " + this._tokenDesc(jsonToken));
    }
}

