/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv.impl;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonReadContext;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.dataformat.csv.impl.NumberInput;
import com.fasterxml.jackson.dataformat.csv.impl.TextBuffer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CsvReader {
    private static final int INT_SPACE = 32;
    private static final int INT_CR = 13;
    private static final int INT_LF = 10;
    protected final CsvParser _owner;
    protected final IOContext _ioContext;
    protected Reader _inputSource;
    protected boolean _bufferRecyclable;
    protected boolean _autoCloseInput;
    protected boolean _trimSpaces;
    protected int _maxSpecialChar;
    protected int _separatorChar;
    protected int _quoteChar;
    protected int _escapeChar;
    protected final TextBuffer _textBuffer;
    protected char[] _inputBuffer;
    protected int _inputPtr = 0;
    protected int _inputEnd = 0;
    protected int _pendingLF = 0;
    protected boolean _closed;
    protected long _currInputProcessed = 0L;
    protected int _currInputRow = 1;
    protected int _currInputRowStart = 0;
    protected long _tokenInputTotal = 0L;
    protected int _tokenInputRow = 1;
    protected int _tokenInputCol = 0;
    protected static final int NR_UNKNOWN = 0;
    protected static final int NR_INT = 1;
    protected static final int NR_LONG = 2;
    protected static final int NR_BIGINT = 4;
    protected static final int NR_DOUBLE = 8;
    protected static final int NR_BIGDECIMAL = 16;
    static final BigDecimal BD_MIN_LONG = new BigDecimal(Long.MIN_VALUE);
    static final BigDecimal BD_MAX_LONG = new BigDecimal(Long.MAX_VALUE);
    static final BigDecimal BD_MIN_INT = new BigDecimal(Long.MIN_VALUE);
    static final BigDecimal BD_MAX_INT = new BigDecimal(Long.MAX_VALUE);
    static final long MIN_INT_L = Integer.MIN_VALUE;
    static final long MAX_INT_L = Integer.MAX_VALUE;
    static final double MIN_LONG_D = -9.223372036854776E18;
    static final double MAX_LONG_D = 9.223372036854776E18;
    static final double MIN_INT_D = -2.147483648E9;
    static final double MAX_INT_D = 2.147483647E9;
    protected static final int INT_0 = 48;
    protected static final int INT_1 = 49;
    protected static final int INT_2 = 50;
    protected static final int INT_3 = 51;
    protected static final int INT_4 = 52;
    protected static final int INT_5 = 53;
    protected static final int INT_6 = 54;
    protected static final int INT_7 = 55;
    protected static final int INT_8 = 56;
    protected static final int INT_9 = 57;
    protected static final int INT_MINUS = 45;
    protected static final int INT_PLUS = 43;
    protected static final int INT_DECIMAL_POINT = 46;
    protected static final int INT_e = 101;
    protected static final int INT_E = 69;
    protected static final char CHAR_NULL = '\u0000';
    protected int _numTypesValid = 0;
    protected int _numberInt;
    protected long _numberLong;
    protected double _numberDouble;
    protected BigInteger _numberBigInt;
    protected BigDecimal _numberBigDecimal;
    protected boolean _numberNegative;
    protected int _intLength;
    protected int _fractLength;
    protected int _expLength;
    protected JsonToken _currToken = null;

    public CsvReader(CsvParser csvParser, IOContext iOContext, Reader reader, CsvSchema csvSchema, TextBuffer textBuffer, boolean bl, boolean bl2) {
        this._owner = csvParser;
        this._ioContext = iOContext;
        this._inputSource = reader;
        this._textBuffer = textBuffer;
        this._autoCloseInput = bl;
        this._trimSpaces = bl2;
        this._inputBuffer = iOContext.allocTokenBuffer();
        this._bufferRecyclable = true;
        this._inputSource = reader;
        this._tokenInputRow = -1;
        this._tokenInputCol = -1;
        this.setSchema(csvSchema);
    }

    public void setSchema(CsvSchema csvSchema) {
        this._separatorChar = csvSchema.getColumnSeparator();
        this._quoteChar = csvSchema.getQuoteChar();
        this._escapeChar = csvSchema.getEscapeChar();
        int n = Math.max(this._separatorChar, this._quoteChar);
        n = Math.max(n, this._escapeChar);
        n = Math.max(n, 13);
        this._maxSpecialChar = n = Math.max(n, 10);
    }

    public Object getInputSource() {
        return this._inputSource;
    }

    public boolean isClosed() {
        return this._closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this._pendingLF = 1;
        if (!this._closed) {
            this._closed = true;
            try {
                this._closeInput();
            }
            finally {
                this.releaseBuffers();
            }
        }
    }

    public int releaseBuffered(Writer writer) throws IOException {
        int n = this._inputEnd - this._inputPtr;
        if (n < 1) {
            return 0;
        }
        int n2 = this._inputPtr;
        writer.write(this._inputBuffer, n2, n);
        return n;
    }

    public JsonReadContext childArrayContext(JsonReadContext jsonReadContext) {
        int n = this._inputPtr - this._currInputRowStart + 1;
        return jsonReadContext.createChildArrayContext(this._currInputRow, n);
    }

    public JsonReadContext childObjectContext(JsonReadContext jsonReadContext) {
        int n = this._inputPtr - this._currInputRowStart + 1;
        return jsonReadContext.createChildObjectContext(this._currInputRow, n);
    }

    public JsonLocation getTokenLocation() {
        return new JsonLocation((Object)this._inputSource, this.getTokenCharacterOffset(), this.getTokenLineNr(), this.getTokenColumnNr());
    }

    public JsonLocation getCurrentLocation() {
        int n = this._inputPtr;
        if (this._pendingLF > 1) {
            --n;
        }
        int n2 = n - this._currInputRowStart + 1;
        return new JsonLocation((Object)this._inputSource, this._currInputProcessed + (long)n - 1L, this._currInputRow, n2);
    }

    protected final long getTokenCharacterOffset() {
        return this._tokenInputTotal;
    }

    protected final int getTokenLineNr() {
        return this._tokenInputRow;
    }

    protected final int getTokenColumnNr() {
        int n = this._tokenInputCol;
        return n < 0 ? n : n + 1;
    }

    protected void releaseBuffers() throws IOException {
        this._textBuffer.releaseBuffers();
        char[] cArray = this._inputBuffer;
        if (cArray != null) {
            this._inputBuffer = null;
            this._ioContext.releaseTokenBuffer(cArray);
        }
    }

    protected void _closeInput() throws IOException {
        this._pendingLF = 1;
        if (this._inputSource != null) {
            if (this._autoCloseInput || this._ioContext.isResourceManaged()) {
                this._inputSource.close();
            }
            this._inputSource = null;
        }
    }

    protected final boolean loadMore() throws IOException {
        this._currInputProcessed += (long)this._inputEnd;
        this._currInputRowStart -= this._inputEnd;
        if (this._inputSource != null) {
            int n;
            this._inputEnd = n = this._inputSource.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (n > 0) {
                this._inputPtr = 0;
                return true;
            }
            this._closeInput();
            if (n == 0) {
                throw new IOException("InputStream.read() returned 0 characters when trying to read " + this._inputBuffer.length + " bytes");
            }
        }
        return false;
    }

    public String getText() {
        return this._textBuffer.contentsAsString();
    }

    public boolean hasMoreInput() throws IOException, JsonParseException {
        if (this._inputPtr < this._inputEnd) {
            return true;
        }
        return this.loadMore();
    }

    public boolean startNewLine() throws IOException, JsonParseException {
        if (this._pendingLF != 0) {
            if (this._inputSource == null) {
                return false;
            }
            this._handleLF();
        }
        return this._inputPtr < this._inputEnd || this.loadMore();
    }

    public boolean skipLine() throws IOException, JsonParseException {
        if (this._pendingLF != 0) {
            if (this._inputSource == null) {
                return false;
            }
            this._handleLF();
        }
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int n;
            if ((n = this._inputBuffer[this._inputPtr++]) != 13 && n != 10) continue;
            this._pendingLF = n;
            this._handleLF();
            return true;
        }
        return false;
    }

    public String nextString() throws IOException, JsonParseException {
        this._numTypesValid = 0;
        if (this._pendingLF > 0) {
            if (this._inputSource != null) {
                this._handleLF();
            }
            return null;
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr - 1L;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = this._inputPtr - this._currInputRowStart - 1;
        int n = this._trimSpaces ? this._skipLeadingSpace() : this._nextChar();
        if (n < 0) {
            return "";
        }
        if (n == 13 || n == 10) {
            this._pendingLF = n;
            return "";
        }
        if (n == this._quoteChar) {
            return this._nextQuotedString();
        }
        if (n == this._separatorChar) {
            this._textBuffer.resetWithString("");
            return "";
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        cArray[0] = (char)n;
        int n2 = 1;
        int n3 = this._inputPtr;
        if (n3 >= this._inputEnd) {
            if (!this.loadMore()) {
                return this._textBuffer.finishAndReturn(n2, this._trimSpaces);
            }
            n3 = this._inputPtr;
        }
        int n4 = Math.min(this._inputEnd - n3, cArray.length - n2);
        int n5 = n3 + n4;
        char[] cArray2 = this._inputBuffer;
        while (n3 < n5) {
            int n6;
            if ((n6 = cArray2[n3++]) <= this._maxSpecialChar) {
                if (n6 == this._separatorChar) {
                    this._inputPtr = n3;
                    return this._textBuffer.finishAndReturn(n2, this._trimSpaces);
                }
                if (n6 == 13 || n6 == 10) {
                    this._pendingLF = n6;
                    this._inputPtr = n3;
                    return this._textBuffer.finishAndReturn(n2, this._trimSpaces);
                }
                if (n6 == this._escapeChar) {
                    --n3;
                    break;
                }
            }
            cArray[n2++] = n6;
        }
        this._inputPtr = n3;
        return this._nextUnquotedString(cArray, n2);
    }

    public JsonToken nextStringOrLiteral() throws IOException, JsonParseException {
        this._numTypesValid = 0;
        String string = this.nextString();
        if (string == null) {
            return null;
        }
        return JsonToken.VALUE_STRING;
    }

    public JsonToken nextNumber() throws IOException, JsonParseException {
        this._numTypesValid = 0;
        String string = this.nextString();
        if (string == null) {
            return null;
        }
        return JsonToken.VALUE_STRING;
    }

    public JsonToken nextNumberOrString() throws IOException, JsonParseException {
        this._numTypesValid = 0;
        String string = this.nextString();
        if (string == null) {
            return null;
        }
        return JsonToken.VALUE_STRING;
    }

    protected String _nextUnquotedString(char[] cArray, int n) throws IOException, JsonParseException {
        char[] cArray2 = this._inputBuffer;
        block0: while (true) {
            int n2;
            if ((n2 = this._inputPtr) >= this._inputEnd) {
                if (!this.loadMore()) {
                    this._inputPtr = n2;
                    break;
                }
                n2 = this._inputPtr;
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            int n3 = Math.min(this._inputEnd, n2 + (cArray.length - n));
            while (n2 < n3) {
                int n4;
                if ((n4 = cArray2[n2++]) <= this._maxSpecialChar) {
                    if (n4 == this._separatorChar) {
                        this._inputPtr = n2;
                        break block0;
                    }
                    if (n4 == 13 || n4 == 10) {
                        this._inputPtr = n2;
                        this._pendingLF = n4;
                        break block0;
                    }
                    if (n4 == this._escapeChar) {
                        this._inputPtr = n2;
                        cArray[n++] = this._unescape();
                        continue block0;
                    }
                }
                cArray[n++] = (char)n4;
            }
            this._inputPtr = n2;
        }
        return this._textBuffer.finishAndReturn(n, this._trimSpaces);
    }

    protected String _nextQuotedString() throws IOException, JsonParseException {
        int n;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n2 = 0;
        char[] cArray2 = this._inputBuffer;
        boolean bl = false;
        block0: while (true) {
            int n3;
            block12: {
                if ((n3 = this._inputPtr) >= this._inputEnd) {
                    if (!this.loadMore()) {
                        this._owner._reportCsvError("Missing closing quote for value");
                    }
                    n3 = this._inputPtr;
                    if (bl && cArray2[n3] == '\n') {
                        --this._currInputRow;
                    }
                }
                if (bl) {
                    // empty if block
                }
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                n = Math.min(this._inputEnd, n3 + (cArray.length - n2));
                do {
                    char c;
                    block13: {
                        block14: {
                            block15: {
                                if ((c = cArray2[n3++]) > this._maxSpecialChar) break block13;
                                if (c == this._quoteChar) break block12;
                                if (c != '\r') break block14;
                                if (n3 < n) break block15;
                                bl = true;
                                ++this._currInputRow;
                                this._currInputRowStart = n3;
                                break block13;
                            }
                            if (cArray2[n3] == '\n') break block13;
                            ++this._currInputRow;
                            this._currInputRowStart = n3;
                            break block13;
                        }
                        if (c == '\n') {
                            ++this._currInputRow;
                            this._currInputRowStart = n3;
                        } else if (c == this._escapeChar) {
                            this._inputPtr = n3;
                            c = this._unescape();
                            cArray[n2++] = c;
                            continue block0;
                        }
                    }
                    cArray[n2++] = c;
                } while (n3 < n);
                this._inputPtr = n3;
                continue;
            }
            this._inputPtr = n3;
            if (this._inputPtr >= this._inputEnd && !this.loadMore() || this._inputBuffer[this._inputPtr] != this._quoteChar) break;
            cArray[n2++] = (char)this._quoteChar;
            ++this._inputPtr;
        }
        String string = this._textBuffer.finishAndReturn(n2, false);
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && (n = this._inputBuffer[this._inputPtr++]) != this._separatorChar) {
            if (n <= 32) {
                if (n != 13 && n != 10) continue;
                this._pendingLF = n;
                break;
            }
            this._owner._reportUnexpectedCsvChar(n, "Expected separator (" + CsvReader._getCharDesc(this._quoteChar) + ") or end-of-line");
        }
        return string;
    }

    protected final void _handleLF() throws IOException, JsonParseException {
        if (this._pendingLF == 13 && (this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == '\n') {
            ++this._inputPtr;
        }
        this._pendingLF = 0;
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    protected char _unescape() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportError("Unexpected EOF in escaped character");
        }
        char c = this._inputBuffer[this._inputPtr++];
        switch (c) {
            case '0': {
                return '\u0000';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
        }
        return c;
    }

    protected int _nextChar() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return -1;
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected int _skipLeadingSpace() throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c;
            if ((c = this._inputBuffer[this._inputPtr++]) > ' ') {
                return c;
            }
            switch (c) {
                case '\n': 
                case '\r': {
                    return c;
                }
            }
        }
        return -1;
    }

    public Number getNumberValue() throws IOException, JsonParseException {
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._numberBigInt;
            }
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 8) == 0) {
            this._throwInternal();
        }
        return this._numberDouble;
    }

    public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return JsonParser.NumberType.INT;
            }
            if ((this._numTypesValid & 2) != 0) {
                return JsonParser.NumberType.LONG;
            }
            return JsonParser.NumberType.BIG_INTEGER;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return JsonParser.NumberType.BIG_DECIMAL;
        }
        return JsonParser.NumberType.DOUBLE;
    }

    public int getIntValue() throws IOException, JsonParseException {
        if ((this._numTypesValid & 1) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(1);
            }
            if ((this._numTypesValid & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    public long getLongValue() throws IOException, JsonParseException {
        if ((this._numTypesValid & 2) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(2);
            }
            if ((this._numTypesValid & 2) == 0) {
                this.convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    public BigInteger getBigIntegerValue() throws IOException, JsonParseException {
        if ((this._numTypesValid & 4) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(4);
            }
            if ((this._numTypesValid & 4) == 0) {
                this.convertNumberToBigInteger();
            }
        }
        return this._numberBigInt;
    }

    public float getFloatValue() throws IOException, JsonParseException {
        double d = this.getDoubleValue();
        return (float)d;
    }

    public double getDoubleValue() throws IOException, JsonParseException {
        if ((this._numTypesValid & 8) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(8);
            }
            if ((this._numTypesValid & 8) == 0) {
                this.convertNumberToDouble();
            }
        }
        return this._numberDouble;
    }

    public BigDecimal getDecimalValue() throws IOException, JsonParseException {
        if ((this._numTypesValid & 0x10) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(16);
            }
            if ((this._numTypesValid & 0x10) == 0) {
                this.convertNumberToBigDecimal();
            }
        }
        return this._numberBigDecimal;
    }

    protected void _parseNumericValue(int n) throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            char[] cArray = this._textBuffer.getTextBuffer();
            int n2 = this._textBuffer.getTextOffset();
            int n3 = this._intLength;
            if (this._numberNegative) {
                ++n2;
            }
            if (n3 <= 9) {
                int n4 = NumberInput.parseInt(cArray, n2, n3);
                this._numberInt = this._numberNegative ? -n4 : n4;
                this._numTypesValid = 1;
                return;
            }
            if (n3 <= 18) {
                long l = NumberInput.parseLong(cArray, n2, n3);
                if (this._numberNegative) {
                    l = -l;
                }
                if (n3 == 10) {
                    if (this._numberNegative) {
                        if (l >= Integer.MIN_VALUE) {
                            this._numberInt = (int)l;
                            this._numTypesValid = 1;
                            return;
                        }
                    } else if (l <= Integer.MAX_VALUE) {
                        this._numberInt = (int)l;
                        this._numTypesValid = 1;
                        return;
                    }
                }
                this._numberLong = l;
                this._numTypesValid = 2;
                return;
            }
            this._parseSlowIntValue(n, cArray, n2, n3);
            return;
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            this._parseSlowFloatValue(n);
            return;
        }
        this._reportError("Current token (" + this._currToken + ") not numeric, can not use numeric value accessors");
    }

    private final void _parseSlowFloatValue(int n) throws IOException, JsonParseException {
        try {
            if (n == 16) {
                this._numberBigDecimal = this._textBuffer.contentsAsDecimal();
                this._numTypesValid = 16;
            } else {
                this._numberDouble = this._textBuffer.contentsAsDouble();
                this._numTypesValid = 8;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw this.constructError("Malformed numeric value '" + this._textBuffer.contentsAsString() + "'", numberFormatException);
        }
    }

    private final void _parseSlowIntValue(int n, char[] cArray, int n2, int n3) throws IOException, JsonParseException {
        String string = this._textBuffer.contentsAsString();
        try {
            if (NumberInput.inLongRange(cArray, n2, n3, this._numberNegative)) {
                this._numberLong = Long.parseLong(string);
                this._numTypesValid = 2;
            } else {
                this._numberBigInt = new BigInteger(string);
                this._numTypesValid = 4;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw this.constructError("Malformed numeric value '" + string + "'", numberFormatException);
        }
    }

    protected void convertNumberToInt() throws IOException, JsonParseException {
        if ((this._numTypesValid & 2) != 0) {
            int n = (int)this._numberLong;
            if ((long)n != this._numberLong) {
                this._reportError("Numeric value (" + this.getText() + ") out of range of int");
            }
            this._numberInt = n;
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberInt = this._numberBigInt.intValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -2.147483648E9 || this._numberDouble > 2.147483647E9) {
                this.reportOverflowInt();
            }
            this._numberInt = (int)this._numberDouble;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_INT.compareTo(this._numberBigDecimal) > 0 || BD_MAX_INT.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigDecimal.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    protected void convertNumberToLong() throws IOException, JsonParseException {
        if ((this._numTypesValid & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberLong = this._numberBigInt.longValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -9.223372036854776E18 || this._numberDouble > 9.223372036854776E18) {
                this.reportOverflowLong();
            }
            this._numberLong = (long)this._numberDouble;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_LONG.compareTo(this._numberBigDecimal) > 0 || BD_MAX_LONG.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigDecimal.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    protected void convertNumberToBigInteger() throws IOException, JsonParseException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberBigInt = this._numberBigDecimal.toBigInteger();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberDouble).toBigInteger();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    protected void convertNumberToDouble() throws IOException, JsonParseException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberDouble = this._numberBigDecimal.doubleValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberDouble = this._numberBigInt.doubleValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberDouble = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberDouble = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 8;
    }

    protected void convertNumberToBigDecimal() throws IOException, JsonParseException {
        if ((this._numTypesValid & 8) != 0) {
            this._numberBigDecimal = new BigDecimal(this.getText());
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberBigDecimal = new BigDecimal(this._numberBigInt);
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x10;
    }

    protected void reportUnexpectedNumberChar(int n, String string) throws JsonParseException {
        String string2 = "Unexpected character (" + CsvReader._getCharDesc(n) + ") in numeric value";
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        this._reportError(string2);
    }

    protected void reportInvalidNumber(String string) throws JsonParseException {
        this._reportError("Invalid numeric value: " + string);
    }

    protected void reportOverflowInt() throws IOException, JsonParseException {
        this._reportError("Numeric value (" + this.getText() + ") out of range of int (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")");
    }

    protected void reportOverflowLong() throws IOException, JsonParseException {
        this._reportError("Numeric value (" + this.getText() + ") out of range of long (" + Long.MIN_VALUE + " - " + Long.MAX_VALUE + ")");
    }

    protected final JsonParseException constructError(String string, Throwable throwable) {
        return new JsonParseException(string, this.getCurrentLocation(), throwable);
    }

    protected static final String _getCharDesc(int n) {
        char c = (char)n;
        if (Character.isISOControl(c)) {
            return "(CTRL-CHAR, code " + n + ")";
        }
        if (n > 255) {
            return "'" + c + "' (code " + n + " / 0x" + Integer.toHexString(n) + ")";
        }
        return "'" + c + "' (code " + n + ")";
    }

    private void _throwInternal() {
        throw new IllegalStateException("Internal error: code path should never get executed");
    }

    protected final void _reportError(String string) throws JsonParseException {
        throw new JsonParseException(string, this.getCurrentLocation());
    }
}

