/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonReadContext;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.dataformat.csv.PackageVersion;
import com.fasterxml.jackson.dataformat.csv.impl.CsvReader;
import com.fasterxml.jackson.dataformat.csv.impl.TextBuffer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CsvParser
extends ParserMinimalBase {
    private static final CsvSchema EMPTY_SCHEMA = CsvSchema.emptySchema();
    protected static final int STATE_DOC_START = 0;
    protected static final int STATE_RECORD_START = 1;
    protected static final int STATE_NEXT_ENTRY = 2;
    protected static final int STATE_NAMED_VALUE = 3;
    protected static final int STATE_UNNAMED_VALUE = 4;
    protected static final int STATE_DOC_END = 5;
    protected ObjectCodec _objectCodec;
    protected int _csvFeatures;
    protected CsvSchema _schema = EMPTY_SCHEMA;
    protected int _columnCount = 0;
    protected JsonReadContext _parsingContext;
    protected String _currentName;
    protected String _currentValue;
    protected int _columnIndex;
    protected int _state = 0;
    protected byte[] _binaryValue;
    protected final CsvReader _reader;
    protected final TextBuffer _textBuffer;
    protected ByteArrayBuilder _byteArrayBuilder;

    public CsvParser(IOContext iOContext, BufferRecycler bufferRecycler, int n, int n2, ObjectCodec objectCodec, Reader reader) {
        super(n);
        this._objectCodec = objectCodec;
        this._textBuffer = new TextBuffer(bufferRecycler);
        this._csvFeatures = n2;
        this._parsingContext = JsonReadContext.createRootContext();
        this._reader = new CsvReader(this, iOContext, reader, this._schema, this._textBuffer, this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE), this.isEnabled(Feature.TRIM_SPACES));
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        return formatSchema instanceof CsvSchema;
    }

    public void setSchema(FormatSchema formatSchema) {
        if (formatSchema instanceof CsvSchema) {
            this._schema = (CsvSchema)formatSchema;
        } else if (formatSchema == null) {
            formatSchema = EMPTY_SCHEMA;
        } else {
            super.setSchema(formatSchema);
        }
        this._columnCount = this._schema.size();
        this._reader.setSchema(this._schema);
    }

    public int releaseBuffered(Writer writer) throws IOException {
        return this._reader.releaseBuffered(writer);
    }

    public boolean isClosed() {
        return this._reader.isClosed();
    }

    public void close() throws IOException {
        this._reader.close();
    }

    public JsonParser enable(Feature feature) {
        this._csvFeatures |= feature.getMask();
        return this;
    }

    public JsonParser disable(Feature feature) {
        this._csvFeatures &= ~feature.getMask();
        return this;
    }

    public JsonParser configure(Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public boolean isEnabled(Feature feature) {
        return (this._csvFeatures & feature.getMask()) != 0;
    }

    public CsvSchema getSchema() {
        return this._schema;
    }

    public JsonStreamContext getParsingContext() {
        return this._parsingContext;
    }

    public JsonLocation getTokenLocation() {
        return this._reader.getTokenLocation();
    }

    public JsonLocation getCurrentLocation() {
        return this._reader.getCurrentLocation();
    }

    public Object getInputSource() {
        return this._reader.getInputSource();
    }

    public String getCurrentName() throws IOException, JsonParseException {
        return this._currentName;
    }

    public void overrideCurrentName(String string) {
        this._currentName = string;
    }

    public JsonToken nextToken() throws IOException, JsonParseException {
        this._binaryValue = null;
        switch (this._state) {
            case 0: {
                this._currToken = this._handleStartDoc();
                return this._currToken;
            }
            case 1: {
                this._currToken = this._handleRecordStart();
                return this._currToken;
            }
            case 2: {
                this._currToken = this._handleNextEntry();
                return this._currToken;
            }
            case 3: {
                this._currToken = this._handleNamedValue();
                return this._currToken;
            }
            case 4: {
                this._currToken = this._handleUnnamedValue();
                return this._currToken;
            }
            case 5: {
                this._reader.close();
                if (this._parsingContext.inRoot()) {
                    return null;
                }
                boolean bl = this._parsingContext.inArray();
                this._parsingContext = this._parsingContext.getParent();
                return bl ? JsonToken.END_ARRAY : JsonToken.END_OBJECT;
            }
        }
        throw new IllegalStateException();
    }

    protected JsonToken _handleStartDoc() throws IOException, JsonParseException {
        if (this._schema.useHeader()) {
            this._readHeaderLine();
        }
        if (this._schema.skipFirstDataRow()) {
            this._reader.skipLine();
        }
        if (!this._reader.hasMoreInput()) {
            this._state = 5;
            if (this.isEnabled(Feature.WRAP_AS_ARRAY)) {
                this._parsingContext = this._reader.childArrayContext(this._parsingContext);
                return JsonToken.START_ARRAY;
            }
            return null;
        }
        if (this.isEnabled(Feature.WRAP_AS_ARRAY)) {
            this._parsingContext = this._reader.childArrayContext(this._parsingContext);
            this._state = 1;
            return JsonToken.START_ARRAY;
        }
        return this._handleRecordStart();
    }

    protected JsonToken _handleRecordStart() throws IOException, JsonParseException {
        this._columnIndex = 0;
        if (this._columnCount == 0) {
            this._state = 4;
            this._parsingContext = this._reader.childArrayContext(this._parsingContext);
            return JsonToken.START_ARRAY;
        }
        this._parsingContext = this._reader.childObjectContext(this._parsingContext);
        this._state = 2;
        return JsonToken.START_OBJECT;
    }

    protected JsonToken _handleNextEntry() throws IOException, JsonParseException {
        String string = this._reader.nextString();
        if (string == null) {
            this._parsingContext = this._parsingContext.getParent();
            this._state = !this._reader.startNewLine() ? 5 : 1;
            return JsonToken.END_OBJECT;
        }
        this._state = 3;
        this._currentValue = string;
        if (this._columnIndex >= this._columnCount) {
            this._currentName = null;
            if (this._columnIndex == this._columnCount && (string = string.trim()).length() == 0) {
                return this._handleNextEntry();
            }
            this._reportError("Too many entries: expected at most " + this._columnCount + " (value #" + this._columnCount + " (" + string.length() + " chars) \"" + string + "\")");
        }
        this._currentName = this._schema.column(this._columnIndex).getName();
        return JsonToken.FIELD_NAME;
    }

    protected JsonToken _handleNamedValue() throws IOException, JsonParseException {
        this._state = 2;
        ++this._columnIndex;
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleUnnamedValue() throws IOException, JsonParseException {
        String string = this._reader.nextString();
        if (string == null) {
            this._parsingContext = this._parsingContext.getParent();
            this._state = !this._reader.startNewLine() ? 5 : 1;
            return JsonToken.END_ARRAY;
        }
        this._currentValue = string;
        ++this._columnIndex;
        return JsonToken.VALUE_STRING;
    }

    protected void _readHeaderLine() throws IOException, JsonParseException {
        Object object;
        String string;
        if (this._schema.size() > 0) {
            while (this._reader.nextString() != null) {
            }
            return;
        }
        CsvSchema.Builder builder = this._schema.rebuild().clearColumns();
        while ((string = this._reader.nextString()) != null) {
            object = this._schema.column(string = string.trim());
            if (object != null) {
                builder.addColumn(string, ((CsvSchema.Column)object).getType());
                continue;
            }
            builder.addColumn(string);
        }
        object = builder.build();
        int n = ((CsvSchema)object).size();
        if (n < 2) {
            String string2;
            String string3 = string2 = n == 0 ? "" : ((CsvSchema)object).column(0).getName().trim();
            if (string2.length() == 0) {
                this._reportError("Empty header line: can not bind data");
            }
        }
        this.setSchema(builder.build());
    }

    public boolean hasTextCharacters() {
        return this._textBuffer.hasTextAsCharacters();
    }

    public String getText() throws IOException, JsonParseException {
        return this._currentValue;
    }

    public char[] getTextCharacters() throws IOException, JsonParseException {
        return this._textBuffer.contentsAsArray();
    }

    public int getTextLength() throws IOException, JsonParseException {
        return this._textBuffer.size();
    }

    public int getTextOffset() throws IOException, JsonParseException {
        return 0;
    }

    public Object getEmbeddedObject() throws IOException, JsonParseException {
        return null;
    }

    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
        if (this._binaryValue == null) {
            if (this._currToken != JsonToken.VALUE_STRING) {
                this._reportError("Current token (" + this._currToken + ") not VALUE_STRING, can not access as binary");
            }
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            this._decodeBase64(this._currentValue, byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
        return this._reader.getNumberType();
    }

    public Number getNumberValue() throws IOException, JsonParseException {
        return this._reader.getNumberValue();
    }

    public int getIntValue() throws IOException, JsonParseException {
        return this._reader.getIntValue();
    }

    public long getLongValue() throws IOException, JsonParseException {
        return this._reader.getLongValue();
    }

    public BigInteger getBigIntegerValue() throws IOException, JsonParseException {
        return this._reader.getBigIntegerValue();
    }

    public float getFloatValue() throws IOException, JsonParseException {
        return this._reader.getFloatValue();
    }

    public double getDoubleValue() throws IOException, JsonParseException {
        return this._reader.getDoubleValue();
    }

    public BigDecimal getDecimalValue() throws IOException, JsonParseException {
        return this._reader.getDecimalValue();
    }

    protected void _handleEOF() throws JsonParseException {
        this._reportInvalidEOF(": expected closing quote character");
    }

    public void _reportCsvError(String string) throws JsonParseException {
        super._reportError(string);
    }

    public void _reportUnexpectedCsvChar(int n, String string) throws JsonParseException {
        super._reportUnexpectedChar(n, string);
    }

    public ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    public static enum Feature {
        TRIM_SPACES(false),
        WRAP_AS_ARRAY(false);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.getMask();
            }
            return n;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

