/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.schema;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonAnyFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonBooleanFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNullFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.dataformat.avro.schema.ArrayVisitor;
import com.fasterxml.jackson.dataformat.avro.schema.DefinedSchemas;
import com.fasterxml.jackson.dataformat.avro.schema.DoubleVisitor;
import com.fasterxml.jackson.dataformat.avro.schema.IntegerVisitor;
import com.fasterxml.jackson.dataformat.avro.schema.MapVisitor;
import com.fasterxml.jackson.dataformat.avro.schema.RecordVisitor;
import com.fasterxml.jackson.dataformat.avro.schema.SchemaBuilder;
import com.fasterxml.jackson.dataformat.avro.schema.StringVisitor;
import org.apache.avro.Schema;

public class VisitorFormatWrapperImpl
implements JsonFormatVisitorWrapper {
    protected SerializerProvider _provider;
    protected final DefinedSchemas _schemas;
    protected SchemaBuilder _builder;
    protected Schema _valueSchema;

    @Deprecated
    public VisitorFormatWrapperImpl(DefinedSchemas schemas) {
        this(schemas, null);
    }

    public VisitorFormatWrapperImpl(DefinedSchemas schemas, SerializerProvider p) {
        this._schemas = schemas;
        this._provider = p;
    }

    public SerializerProvider getProvider() {
        return this._provider;
    }

    public void setProvider(SerializerProvider provider) {
        this._schemas.setProvider(provider);
        this._provider = provider;
    }

    public Schema getAvroSchema() {
        if (this._valueSchema != null) {
            return this._valueSchema;
        }
        if (this._builder == null) {
            throw new IllegalStateException("No visit methods called on " + this.getClass().getName() + ": no schema generated");
        }
        return this._builder.builtAvroSchema();
    }

    public JsonObjectFormatVisitor expectObjectFormat(JavaType type) {
        Schema s = this._schemas.findSchema(type);
        if (s != null) {
            this._valueSchema = s;
            return null;
        }
        RecordVisitor v = new RecordVisitor(this._provider, type, this._schemas);
        this._builder = v;
        return v;
    }

    public JsonMapFormatVisitor expectMapFormat(JavaType mapType) {
        MapVisitor v = new MapVisitor(this._provider, mapType, this._schemas);
        this._builder = v;
        return v;
    }

    public JsonArrayFormatVisitor expectArrayFormat(JavaType convertedType) {
        ArrayVisitor v = new ArrayVisitor(this._provider, convertedType, this._schemas);
        this._builder = v;
        return v;
    }

    public JsonStringFormatVisitor expectStringFormat(JavaType type) {
        Schema s = this._schemas.findSchema(type);
        if (s != null) {
            this._valueSchema = s;
            return null;
        }
        StringVisitor v = new StringVisitor(this._schemas, type);
        this._builder = v;
        return v;
    }

    public JsonNumberFormatVisitor expectNumberFormat(JavaType convertedType) {
        DoubleVisitor v = new DoubleVisitor();
        this._builder = v;
        return v;
    }

    public JsonIntegerFormatVisitor expectIntegerFormat(JavaType type) {
        Schema s = this._schemas.findSchema(type);
        if (s != null) {
            this._valueSchema = s;
            return null;
        }
        IntegerVisitor v = new IntegerVisitor();
        this._builder = v;
        return v;
    }

    public JsonBooleanFormatVisitor expectBooleanFormat(JavaType convertedType) {
        this._valueSchema = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
        return null;
    }

    public JsonNullFormatVisitor expectNullFormat(JavaType convertedType) {
        this._valueSchema = Schema.create((Schema.Type)Schema.Type.NULL);
        return null;
    }

    public JsonAnyFormatVisitor expectAnyFormat(JavaType convertedType) {
        return (JsonAnyFormatVisitor)this._throwUnsupported("'Any' type not supported yet");
    }

    protected <T> T _throwUnsupported() {
        return this._throwUnsupported("Format variation not supported");
    }

    protected <T> T _throwUnsupported(String msg) {
        throw new UnsupportedOperationException(msg);
    }
}

