/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.schema;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import java.util.ArrayList;
import org.apache.avro.Schema;

public abstract class AvroSchemaHelper {
    protected static String getNamespace(JavaType type) {
        Class cls = type.getRawClass();
        Package pkg = cls.getPackage();
        return pkg == null ? "" : pkg.getName();
    }

    protected static String getName(JavaType type) {
        String name = type.getRawClass().getSimpleName();
        while (name.indexOf("[]") >= 0) {
            name = name.replace("[]", "Array");
        }
        return name;
    }

    protected static Schema unionWithNull(Schema otherSchema) {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        schemas.add(Schema.create((Schema.Type)Schema.Type.NULL));
        schemas.add(otherSchema);
        return Schema.createUnion(schemas);
    }

    public static Schema simpleSchema(JsonFormatTypes type) {
        switch (type) {
            case BOOLEAN: {
                return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            }
            case INTEGER: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case NULL: {
                return Schema.create((Schema.Type)Schema.Type.NULL);
            }
            case NUMBER: {
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case STRING: {
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
            case ARRAY: 
            case OBJECT: {
                throw new UnsupportedOperationException("Should not try to create simple Schema for: " + type);
            }
        }
        throw new UnsupportedOperationException("Can not create Schema for: " + type + "; not (yet) supported");
    }

    public static Schema numericAvroSchema(JsonParser.NumberType type) {
        switch (type) {
            case INT: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case BIG_INTEGER: 
            case LONG: {
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            case FLOAT: {
                return Schema.create((Schema.Type)Schema.Type.FLOAT);
            }
            case BIG_DECIMAL: 
            case DOUBLE: {
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
        }
        throw new IllegalStateException("Unrecognized number type: " + type);
    }

    protected static <T> T throwUnsupported() {
        throw new UnsupportedOperationException("Format variation not supported");
    }
}

