/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.schema;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.dataformat.avro.schema.AvroSchemaHelper;
import com.fasterxml.jackson.dataformat.avro.schema.DefinedSchemas;
import com.fasterxml.jackson.dataformat.avro.schema.SchemaBuilder;
import com.fasterxml.jackson.dataformat.avro.schema.VisitorFormatWrapperImpl;
import org.apache.avro.Schema;

public class ArrayVisitor
extends JsonArrayFormatVisitor.Base
implements SchemaBuilder {
    protected final JavaType _type;
    protected final DefinedSchemas _schemas;
    protected Schema _elementSchema;

    public ArrayVisitor(SerializerProvider p, JavaType type, DefinedSchemas schemas) {
        super(p);
        this._type = type;
        this._schemas = schemas;
    }

    @Override
    public Schema builtAvroSchema() {
        if (this._elementSchema == null) {
            throw new IllegalStateException("No element schema created for: " + this._type);
        }
        return Schema.createArray((Schema)this._elementSchema);
    }

    public void itemsFormat(JsonFormatVisitable visitable, JavaType type) throws JsonMappingException {
        VisitorFormatWrapperImpl wrapper = new VisitorFormatWrapperImpl(this._schemas, this.getProvider());
        visitable.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)wrapper, type);
        this._elementSchema = wrapper.getAvroSchema();
    }

    public void itemsFormat(JsonFormatTypes type) throws JsonMappingException {
        this._elementSchema = AvroSchemaHelper.simpleSchema(type);
    }
}

