/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import com.fasterxml.jackson.dataformat.avro.deser.AvroStructureReader;
import java.io.IOException;
import org.apache.avro.io.BinaryDecoder;

final class UnionReader
extends AvroStructureReader {
    private final AvroStructureReader[] _memberReaders;
    private final BinaryDecoder _decoder;
    private final AvroParserImpl _parser;
    private AvroStructureReader _currentReader;

    public UnionReader(AvroStructureReader[] memberReaders) {
        this(null, memberReaders, null, null);
    }

    private UnionReader(AvroReadContext parent, AvroStructureReader[] memberReaders, BinaryDecoder decoder, AvroParserImpl parser) {
        super(parent, 0);
        this._memberReaders = memberReaders;
        this._decoder = decoder;
        this._parser = parser;
    }

    @Override
    public UnionReader newReader(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) {
        return new UnionReader(parent, this._memberReaders, decoder, parser);
    }

    @Override
    public JsonToken nextToken() throws IOException {
        if (this._currentReader == null) {
            int index = this._decoder.readIndex();
            if (index < 0 || index >= this._memberReaders.length) {
                throw new JsonParseException("Invalid index (" + index + "); union only has " + this._memberReaders.length + " types", this._parser.getCurrentLocation());
            }
            this._currentReader = this._memberReaders[index].newReader(this._parent, this._parser, this._decoder);
        }
        return this._currentReader.nextToken();
    }

    @Override
    protected void appendDesc(StringBuilder sb) {
        sb.append('?');
    }
}

