/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;

public abstract class AvroScalarReader {
    protected abstract JsonToken readValue(AvroParserImpl var1, BinaryDecoder var2) throws IOException;

    protected static final class FixedDecoder
    extends AvroScalarReader {
        protected final int _size;

        public FixedDecoder(Schema schema) {
            this._size = schema.getFixedSize();
        }

        @Override
        public JsonToken readValue(AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
            byte[] data = new byte[this._size];
            decoder.readFixed(data);
            return parser.setBytes(data);
        }
    }

    protected static final class EnumDecoder
    extends AvroScalarReader {
        protected final String[] _values;

        public EnumDecoder(Schema schema) {
            List v = schema.getEnumSymbols();
            this._values = v.toArray(new String[v.size()]);
        }

        @Override
        public JsonToken readValue(AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
            int index = decoder.readEnum();
            if (index < 0 || index >= this._values.length) {
                throw new IOException("Illegal Enum index (" + index + "): only " + this._values.length + " entries");
            }
            return parser.setString(this._values[index]);
        }
    }

    protected static final class StringReader
    extends AvroScalarReader {
        protected StringReader() {
        }

        @Override
        public JsonToken readValue(AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
            return parser.setString(decoder.readString());
        }
    }

    protected static final class NullReader
    extends AvroScalarReader {
        protected NullReader() {
        }

        @Override
        public JsonToken readValue(AvroParserImpl parser, BinaryDecoder decoder) {
            return JsonToken.VALUE_NULL;
        }
    }

    protected static final class LongReader
    extends AvroScalarReader {
        protected LongReader() {
        }

        @Override
        public JsonToken readValue(AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
            return parser.setNumber(decoder.readLong());
        }
    }

    protected static final class IntReader
    extends AvroScalarReader {
        protected IntReader() {
        }

        @Override
        public JsonToken readValue(AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
            return parser.setNumber(decoder.readInt());
        }
    }

    protected static final class FloatReader
    extends AvroScalarReader {
        protected FloatReader() {
        }

        @Override
        public JsonToken readValue(AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
            return parser.setNumber(decoder.readFloat());
        }
    }

    protected static final class DoubleReader
    extends AvroScalarReader {
        protected DoubleReader() {
        }

        @Override
        public JsonToken readValue(AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
            return parser.setNumber(decoder.readDouble());
        }
    }

    protected static final class BytesReader
    extends AvroScalarReader {
        protected BytesReader() {
        }

        @Override
        public JsonToken readValue(AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
            ByteBuffer bb = parser.borrowByteBuffer();
            bb = decoder.readBytes(bb);
            return parser.setBytes(bb);
        }
    }

    protected static final class BooleanReader
    extends AvroScalarReader {
        protected BooleanReader() {
        }

        @Override
        protected JsonToken readValue(AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
            return decoder.readBoolean() ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
        }
    }

    protected static final class ScalarUnionReader
    extends AvroScalarReader {
        public final AvroScalarReader[] _readers;

        public ScalarUnionReader(AvroScalarReader[] readers) {
            this._readers = readers;
        }

        @Override
        protected JsonToken readValue(AvroParserImpl parser, BinaryDecoder decoder) throws IOException {
            int index = decoder.readIndex();
            if (index < 0 || index >= this._readers.length) {
                throw new JsonParseException("Invalid index (" + index + "); union only has " + this._readers.length + " types", parser.getCurrentLocation());
            }
            return this._readers[index].readValue(parser, decoder);
        }
    }
}

