/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import com.fasterxml.jackson.dataformat.avro.deser.AvroScalarReader;
import com.fasterxml.jackson.dataformat.avro.deser.AvroStructureReader;
import java.io.IOException;
import org.apache.avro.io.BinaryDecoder;

abstract class ArrayReader
extends AvroStructureReader {
    protected static final int STATE_START = 0;
    protected static final int STATE_ELEMENTS = 1;
    protected static final int STATE_END = 2;
    protected static final int STATE_DONE = 3;
    protected final BinaryDecoder _decoder;
    protected final AvroParserImpl _parser;
    protected int _state;
    protected long _count;
    protected String _currentName;

    protected ArrayReader(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) {
        super(parent, 1);
        this._parser = parser;
        this._decoder = decoder;
    }

    public static ArrayReader scalar(AvroScalarReader reader) {
        return new Scalar(reader);
    }

    public static ArrayReader nonScalar(AvroStructureReader reader) {
        return new NonScalar(reader);
    }

    @Override
    public String getCurrentName() {
        if (this._currentName == null) {
            this._currentName = this._parent.getCurrentName();
        }
        return this._currentName;
    }

    @Override
    protected void appendDesc(StringBuilder sb) {
        sb.append('[');
        sb.append(this.getCurrentIndex());
        sb.append(']');
    }

    private static final class NonScalar
    extends ArrayReader {
        private final AvroStructureReader _elementReader;

        public NonScalar(AvroStructureReader reader) {
            this(null, reader, null, null);
        }

        private NonScalar(AvroReadContext parent, AvroStructureReader reader, AvroParserImpl parser, BinaryDecoder decoder) {
            super(parent, parser, decoder);
            this._elementReader = reader;
        }

        @Override
        public NonScalar newReader(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) {
            return new NonScalar(parent, this._elementReader, parser, decoder);
        }

        @Override
        public JsonToken nextToken() throws IOException {
            switch (this._state) {
                case 0: {
                    this._parser.setAvroContext(this);
                    this._count = this._decoder.readArrayStart();
                    this._state = this._count > 0L ? 1 : 2;
                    return JsonToken.START_ARRAY;
                }
                case 1: {
                    if ((long)this._index < this._count) break;
                    this._count = this._decoder.arrayNext();
                    if (this._count >= 0L) {
                        this._index = 0;
                    }
                }
                case 2: {
                    this._state = 3;
                    this._parser.setAvroContext(this.getParent());
                    return JsonToken.END_ARRAY;
                }
                default: {
                    this.throwIllegalState(this._state);
                }
            }
            ++this._index;
            AvroStructureReader r = this._elementReader.newReader(this, this._parser, this._decoder);
            this._parser.setAvroContext(r);
            return r.nextToken();
        }
    }

    private static final class Scalar
    extends ArrayReader {
        private final AvroScalarReader _elementReader;

        public Scalar(AvroScalarReader reader) {
            this(null, reader, null, null);
        }

        private Scalar(AvroReadContext parent, AvroScalarReader reader, AvroParserImpl parser, BinaryDecoder decoder) {
            super(parent, parser, decoder);
            this._elementReader = reader;
        }

        @Override
        public Scalar newReader(AvroReadContext parent, AvroParserImpl parser, BinaryDecoder decoder) {
            return new Scalar(parent, this._elementReader, parser, decoder);
        }

        @Override
        public JsonToken nextToken() throws IOException {
            switch (this._state) {
                case 0: {
                    this._parser.setAvroContext(this);
                    this._count = this._decoder.readArrayStart();
                    this._state = this._count > 0L ? 1 : 2;
                    return JsonToken.START_ARRAY;
                }
                case 1: {
                    if ((long)this._index < this._count) break;
                    this._count = this._decoder.arrayNext();
                    if (this._count >= 0L) {
                        this._index = 0;
                    }
                }
                case 2: {
                    this._state = 3;
                    this._parser.setAvroContext(this.getParent());
                    return JsonToken.END_ARRAY;
                }
                default: {
                    this.throwIllegalState(this._state);
                    return null;
                }
            }
            ++this._index;
            return this._elementReader.readValue(this._parser, this._decoder);
        }
    }
}

