/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.metadata.Extractor;
import com.facebook.swift.codec.metadata.FieldKind;
import com.facebook.swift.codec.metadata.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

class FieldExtractor
extends Extractor {
    private final Type thriftStructType;
    private final Field field;

    FieldExtractor(Type thriftStructType, Field field, ThriftField annotation, FieldKind fieldKind) {
        super(annotation, fieldKind);
        this.thriftStructType = thriftStructType;
        this.field = field;
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public String extractName() {
        return this.field.getName();
    }

    @Override
    public Type getJavaType() {
        return ReflectionHelper.resolveFieldType(this.thriftStructType, this.field.getGenericType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FieldExtractor");
        sb.append("{field=").append(this.field);
        sb.append('}');
        return sb.toString();
    }
}

