/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal.compiler;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.codec.internal.ForCompiler;
import com.facebook.swift.codec.internal.ThriftCodecFactory;
import com.facebook.swift.codec.internal.compiler.DynamicClassLoader;
import com.facebook.swift.codec.internal.compiler.ThriftCodecByteCodeGenerator;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.google.inject.Inject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CompilerThriftCodecFactory
implements ThriftCodecFactory {
    private final boolean debug;
    private final DynamicClassLoader classLoader;

    @Inject
    public CompilerThriftCodecFactory(@ForCompiler ClassLoader parent) {
        this(false, parent);
    }

    public CompilerThriftCodecFactory(boolean debug) {
        this(debug, CompilerThriftCodecFactory.getPriviledgedClassLoader(CompilerThriftCodecFactory.class.getClassLoader()));
    }

    public CompilerThriftCodecFactory(boolean debug, ClassLoader parent) {
        this.debug = debug;
        this.classLoader = CompilerThriftCodecFactory.getPriviledgedClassLoader(parent);
    }

    @Override
    public ThriftCodec<?> generateThriftTypeCodec(ThriftCodecManager codecManager, ThriftStructMetadata metadata) {
        ThriftCodecByteCodeGenerator generator = new ThriftCodecByteCodeGenerator(codecManager, metadata, this.classLoader, this.debug);
        return generator.getThriftCodec();
    }

    private static DynamicClassLoader getPriviledgedClassLoader(final ClassLoader parent) {
        return AccessController.doPrivileged(new PrivilegedAction<DynamicClassLoader>(){

            @Override
            public DynamicClassLoader run() {
                return new DynamicClassLoader(parent);
            }
        });
    }
}

