/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.internal.UnknownEnumValueException;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TSet;

@NotThreadSafe
public class TProtocolReader {
    private final TProtocol protocol;
    private TField currentField;

    public TProtocolReader(TProtocol protocol) {
        this.protocol = protocol;
    }

    public TProtocol getProtocol() {
        return this.protocol;
    }

    public void readStructBegin() throws TException {
        this.protocol.readStructBegin();
        this.currentField = null;
    }

    public void readStructEnd() throws TException {
        if (this.currentField == null || this.currentField.id != 0) {
            throw new IllegalStateException("Some fields have not been consumed");
        }
        this.currentField = null;
        this.protocol.readStructEnd();
    }

    public boolean nextField() throws TException {
        if (this.currentField != null && this.currentField.id == 0) {
            throw new NoSuchElementException();
        }
        Preconditions.checkState((this.currentField == null ? 1 : 0) != 0, (Object)"Current field was not read");
        this.currentField = this.protocol.readFieldBegin();
        return this.currentField.type != 0;
    }

    public short getFieldId() {
        Preconditions.checkState((this.currentField != null ? 1 : 0) != 0, (Object)"No current field");
        return this.currentField.id;
    }

    public byte getFieldType() {
        Preconditions.checkState((this.currentField != null ? 1 : 0) != 0, (Object)"No current field");
        return this.currentField.type;
    }

    public void skipFieldData() throws TException {
        TProtocolUtil.skip((TProtocol)this.protocol, (byte)this.currentField.type);
        this.protocol.readFieldEnd();
        this.currentField = null;
    }

    public Object readField(ThriftCodec<?> codec) throws Exception {
        if (!this.checkReadState(codec.getType().getProtocolType().getType())) {
            return null;
        }
        this.currentField = null;
        Object fieldValue = codec.read(this.protocol);
        this.protocol.readFieldEnd();
        return fieldValue;
    }

    public ByteBuffer readBinaryField() throws TException {
        if (!this.checkReadState((byte)11)) {
            return null;
        }
        this.currentField = null;
        ByteBuffer fieldValue = this.protocol.readBinary();
        this.protocol.readFieldEnd();
        return fieldValue;
    }

    public boolean readBoolField() throws TException {
        if (!this.checkReadState((byte)2)) {
            return false;
        }
        this.currentField = null;
        boolean fieldValue = this.protocol.readBool();
        this.protocol.readFieldEnd();
        return fieldValue;
    }

    public byte readByteField() throws TException {
        if (!this.checkReadState((byte)3)) {
            return 0;
        }
        this.currentField = null;
        byte fieldValue = this.protocol.readByte();
        this.protocol.readFieldEnd();
        return fieldValue;
    }

    public double readDoubleField() throws TException {
        if (!this.checkReadState((byte)4)) {
            return 0.0;
        }
        this.currentField = null;
        double fieldValue = this.protocol.readDouble();
        this.protocol.readFieldEnd();
        return fieldValue;
    }

    public short readI16Field() throws TException {
        if (!this.checkReadState((byte)6)) {
            return 0;
        }
        this.currentField = null;
        short fieldValue = this.protocol.readI16();
        this.protocol.readFieldEnd();
        return fieldValue;
    }

    public int readI32Field() throws TException {
        if (!this.checkReadState((byte)8)) {
            return 0;
        }
        this.currentField = null;
        int fieldValue = this.protocol.readI32();
        this.protocol.readFieldEnd();
        return fieldValue;
    }

    public long readI64Field() throws TException {
        if (!this.checkReadState((byte)10)) {
            return 0L;
        }
        this.currentField = null;
        long fieldValue = this.protocol.readI64();
        this.protocol.readFieldEnd();
        return fieldValue;
    }

    public String readStringField() throws TException {
        if (!this.checkReadState((byte)11)) {
            return null;
        }
        this.currentField = null;
        String fieldValue = this.protocol.readString();
        this.protocol.readFieldEnd();
        return fieldValue;
    }

    public <T> T readStructField(ThriftCodec<T> codec) throws Exception {
        if (!this.checkReadState((byte)12)) {
            return null;
        }
        this.currentField = null;
        T fieldValue = codec.read(this.protocol);
        this.protocol.readFieldEnd();
        return fieldValue;
    }

    public boolean[] readBoolArrayField() throws TException {
        if (!this.checkReadState((byte)15)) {
            return null;
        }
        this.currentField = null;
        boolean[] fieldValue = this.readBoolArray();
        this.protocol.readFieldEnd();
        return fieldValue;
    }

    public short[] readI16ArrayField() throws TException {
        if (!this.checkReadState((byte)15)) {
            return null;
        }
        this.currentField = null;
        short[] fieldValue = this.readI16Array();
        this.protocol.readFieldEnd();
        return fieldValue;
    }

    public int[] readI32ArrayField() throws TException {
        if (!this.checkReadState((byte)15)) {
            return null;
        }
        this.currentField = null;
        int[] fieldValue = this.readI32Array();
        this.protocol.readFieldEnd();
        return fieldValue;
    }

    public long[] readI64ArrayField() throws TException {
        if (!this.checkReadState((byte)15)) {
            return null;
        }
        this.currentField = null;
        long[] fieldValue = this.readI64Array();
        this.protocol.readFieldEnd();
        return fieldValue;
    }

    public double[] readDoubleArrayField() throws TException {
        if (!this.checkReadState((byte)15)) {
            return null;
        }
        this.currentField = null;
        double[] fieldValue = this.readDoubleArray();
        this.protocol.readFieldEnd();
        return fieldValue;
    }

    public <E> Set<E> readSetField(ThriftCodec<Set<E>> setCodec) throws Exception {
        if (!this.checkReadState((byte)14)) {
            return null;
        }
        this.currentField = null;
        Set<E> fieldValue = setCodec.read(this.protocol);
        this.protocol.readFieldEnd();
        return fieldValue;
    }

    public <E> List<E> readListField(ThriftCodec<List<E>> listCodec) throws Exception {
        if (!this.checkReadState((byte)15)) {
            return null;
        }
        this.currentField = null;
        List<E> read = listCodec.read(this.protocol);
        this.protocol.readFieldEnd();
        return read;
    }

    public <K, V> Map<K, V> readMapField(ThriftCodec<Map<K, V>> mapCodec) throws Exception {
        if (!this.checkReadState((byte)13)) {
            return null;
        }
        this.currentField = null;
        Map<K, V> fieldValue = mapCodec.read(this.protocol);
        this.protocol.readFieldEnd();
        return fieldValue;
    }

    public <T extends Enum<T>> T readEnumField(ThriftCodec<T> enumCodec) throws Exception {
        if (!this.checkReadState((byte)8)) {
            return null;
        }
        this.currentField = null;
        Enum fieldValue = null;
        try {
            fieldValue = (Enum)enumCodec.read(this.protocol);
        }
        catch (UnknownEnumValueException unknownEnumValueException) {
            // empty catch block
        }
        this.protocol.readFieldEnd();
        return (T)fieldValue;
    }

    public ByteBuffer readBinary() throws TException {
        return this.protocol.readBinary();
    }

    public boolean readBool() throws TException {
        return this.protocol.readBool();
    }

    public byte readByte() throws TException {
        return this.protocol.readByte();
    }

    public short readI16() throws TException {
        return this.protocol.readI16();
    }

    public int readI32() throws TException {
        return this.protocol.readI32();
    }

    public long readI64() throws TException {
        return this.protocol.readI64();
    }

    public double readDouble() throws TException {
        return this.protocol.readDouble();
    }

    public String readString() throws TException {
        return this.protocol.readString();
    }

    public boolean[] readBoolArray() throws TException {
        TList list = this.protocol.readListBegin();
        boolean[] array = new boolean[list.size];
        for (int i = 0; i < list.size; ++i) {
            array[i] = this.readBool();
        }
        this.protocol.readListEnd();
        return array;
    }

    public short[] readI16Array() throws TException {
        TList list = this.protocol.readListBegin();
        short[] array = new short[list.size];
        for (int i = 0; i < list.size; ++i) {
            array[i] = this.readI16();
        }
        this.protocol.readListEnd();
        return array;
    }

    public int[] readI32Array() throws TException {
        TList list = this.protocol.readListBegin();
        int[] array = new int[list.size];
        for (int i = 0; i < list.size; ++i) {
            array[i] = this.readI32();
        }
        this.protocol.readListEnd();
        return array;
    }

    public long[] readI64Array() throws TException {
        TList list = this.protocol.readListBegin();
        long[] array = new long[list.size];
        for (int i = 0; i < list.size; ++i) {
            array[i] = this.readI64();
        }
        this.protocol.readListEnd();
        return array;
    }

    public double[] readDoubleArray() throws TException {
        TList list = this.protocol.readListBegin();
        double[] array = new double[list.size];
        for (int i = 0; i < list.size; ++i) {
            array[i] = this.readDouble();
        }
        this.protocol.readListEnd();
        return array;
    }

    public <E> Set<E> readSet(ThriftCodec<E> elementCodec) throws Exception {
        TSet tSet = this.protocol.readSetBegin();
        HashSet<E> set = new HashSet<E>();
        for (int i = 0; i < tSet.size; ++i) {
            try {
                E element = elementCodec.read(this.protocol);
                set.add(element);
                continue;
            }
            catch (UnknownEnumValueException unknownEnumValueException) {
                // empty catch block
            }
        }
        this.protocol.readSetEnd();
        return set;
    }

    public <E> List<E> readList(ThriftCodec<E> elementCodec) throws Exception {
        TList tList = this.protocol.readListBegin();
        ArrayList<E> list = new ArrayList<E>();
        for (int i = 0; i < tList.size; ++i) {
            try {
                E element = elementCodec.read(this.protocol);
                list.add(element);
                continue;
            }
            catch (UnknownEnumValueException unknownEnumValueException) {
                // empty catch block
            }
        }
        this.protocol.readListEnd();
        return list;
    }

    public <K, V> Map<K, V> readMap(ThriftCodec<K> keyCodec, ThriftCodec<V> valueCodec) throws Exception {
        TMap tMap = this.protocol.readMapBegin();
        HashMap<K, V> map = new HashMap<K, V>();
        for (int i = 0; i < tMap.size; ++i) {
            try {
                K key = keyCodec.read(this.protocol);
                V value = valueCodec.read(this.protocol);
                map.put(key, value);
                continue;
            }
            catch (UnknownEnumValueException unknownEnumValueException) {
                // empty catch block
            }
        }
        this.protocol.readMapEnd();
        return map;
    }

    private boolean checkReadState(byte expectedType) throws TException {
        Preconditions.checkState((this.currentField != null ? 1 : 0) != 0, (Object)"No current field");
        if (this.currentField.type != expectedType) {
            TProtocolUtil.skip((TProtocol)this.protocol, (byte)this.currentField.type);
            this.protocol.readFieldEnd();
            this.currentField = null;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TProtocolReader");
        sb.append("{currentField=").append(this.currentField);
        sb.append('}');
        return sb.toString();
    }
}

