/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ViewProps;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaFlexDirection;
import com.facebook.yoga.YogaJustify;
import com.facebook.yoga.YogaOverflow;
import com.facebook.yoga.YogaPositionType;
import com.facebook.yoga.YogaWrap;
import java.util.Locale;
import javax.annotation.Nullable;

public class LayoutShadowNode
extends ReactShadowNode {
    private static boolean dynamicIsPercent(Dynamic dynamic) {
        return dynamic.getType() == ReadableType.String && dynamic.asString().endsWith("%");
    }

    private static float getDynamicAsPercent(Dynamic dynamic) {
        String value = dynamic.asString();
        return Float.parseFloat(value.substring(0, value.length() - 1));
    }

    private static float getDynamicAsFloat(Dynamic dynamic) {
        return PixelUtil.toPixelFromDIP(dynamic.asDouble());
    }

    private static boolean isNull(Dynamic d) {
        return d == null || d.isNull();
    }

    @ReactProp(name="width")
    public void setWidth(Dynamic width) {
        if (this.isVirtual()) {
            return;
        }
        if (!LayoutShadowNode.isNull(width) && LayoutShadowNode.dynamicIsPercent(width)) {
            this.setStyleWidthPercent(LayoutShadowNode.getDynamicAsPercent(width));
        } else {
            this.setStyleWidth(LayoutShadowNode.isNull(width) ? Float.NaN : LayoutShadowNode.getDynamicAsFloat(width));
        }
        width.recycle();
    }

    @ReactProp(name="minWidth")
    public void setMinWidth(Dynamic minWidth) {
        if (this.isVirtual()) {
            return;
        }
        if (!LayoutShadowNode.isNull(minWidth) && LayoutShadowNode.dynamicIsPercent(minWidth)) {
            this.setStyleMinWidthPercent(LayoutShadowNode.getDynamicAsPercent(minWidth));
        } else {
            this.setStyleMinWidth(LayoutShadowNode.isNull(minWidth) ? Float.NaN : LayoutShadowNode.getDynamicAsFloat(minWidth));
        }
        minWidth.recycle();
    }

    @ReactProp(name="maxWidth")
    public void setMaxWidth(Dynamic maxWidth) {
        if (this.isVirtual()) {
            return;
        }
        if (!LayoutShadowNode.isNull(maxWidth) && LayoutShadowNode.dynamicIsPercent(maxWidth)) {
            this.setStyleMaxWidthPercent(LayoutShadowNode.getDynamicAsPercent(maxWidth));
        } else {
            this.setStyleMaxWidth(LayoutShadowNode.isNull(maxWidth) ? Float.NaN : LayoutShadowNode.getDynamicAsFloat(maxWidth));
        }
        maxWidth.recycle();
    }

    @ReactProp(name="height")
    public void setHeight(Dynamic height) {
        if (this.isVirtual()) {
            return;
        }
        if (!LayoutShadowNode.isNull(height) && LayoutShadowNode.dynamicIsPercent(height)) {
            this.setStyleHeightPercent(LayoutShadowNode.getDynamicAsPercent(height));
        } else {
            this.setStyleHeight(LayoutShadowNode.isNull(height) ? Float.NaN : LayoutShadowNode.getDynamicAsFloat(height));
        }
        height.recycle();
    }

    @ReactProp(name="minHeight")
    public void setMinHeight(Dynamic minHeight) {
        if (this.isVirtual()) {
            return;
        }
        if (!LayoutShadowNode.isNull(minHeight) && LayoutShadowNode.dynamicIsPercent(minHeight)) {
            this.setStyleMinHeightPercent(LayoutShadowNode.getDynamicAsPercent(minHeight));
        } else {
            this.setStyleMinHeight(LayoutShadowNode.isNull(minHeight) ? Float.NaN : LayoutShadowNode.getDynamicAsFloat(minHeight));
        }
        minHeight.recycle();
    }

    @ReactProp(name="maxHeight")
    public void setMaxHeight(Dynamic maxHeight) {
        if (this.isVirtual()) {
            return;
        }
        if (!LayoutShadowNode.isNull(maxHeight) && LayoutShadowNode.dynamicIsPercent(maxHeight)) {
            this.setStyleMaxHeightPercent(LayoutShadowNode.getDynamicAsPercent(maxHeight));
        } else {
            this.setStyleMaxHeight(LayoutShadowNode.isNull(maxHeight) ? Float.NaN : LayoutShadowNode.getDynamicAsFloat(maxHeight));
        }
        maxHeight.recycle();
    }

    @Override
    @ReactProp(name="flex", defaultFloat=0.0f)
    public void setFlex(float flex) {
        if (this.isVirtual()) {
            return;
        }
        super.setFlex(flex);
    }

    @Override
    @ReactProp(name="flexGrow", defaultFloat=0.0f)
    public void setFlexGrow(float flexGrow) {
        if (this.isVirtual()) {
            return;
        }
        super.setFlexGrow(flexGrow);
    }

    @Override
    @ReactProp(name="flexShrink", defaultFloat=0.0f)
    public void setFlexShrink(float flexShrink) {
        if (this.isVirtual()) {
            return;
        }
        super.setFlexShrink(flexShrink);
    }

    @ReactProp(name="flexBasis")
    public void setFlexBasis(Dynamic flexBasis) {
        if (this.isVirtual()) {
            return;
        }
        if (!LayoutShadowNode.isNull(flexBasis) && LayoutShadowNode.dynamicIsPercent(flexBasis)) {
            this.setFlexBasisPercent(LayoutShadowNode.getDynamicAsPercent(flexBasis));
        } else {
            this.setFlexBasis(LayoutShadowNode.isNull(flexBasis) ? 0.0f : LayoutShadowNode.getDynamicAsFloat(flexBasis));
        }
        flexBasis.recycle();
    }

    @ReactProp(name="aspectRatio", defaultFloat=NaNf)
    public void setAspectRatio(float aspectRatio) {
        this.setStyleAspectRatio(aspectRatio);
    }

    @ReactProp(name="flexDirection")
    public void setFlexDirection(@Nullable String flexDirection) {
        if (this.isVirtual()) {
            return;
        }
        this.setFlexDirection(flexDirection == null ? YogaFlexDirection.COLUMN : YogaFlexDirection.valueOf(flexDirection.toUpperCase(Locale.US).replace("-", "_")));
    }

    @ReactProp(name="flexWrap")
    public void setFlexWrap(@Nullable String flexWrap) {
        if (this.isVirtual()) {
            return;
        }
        if (flexWrap == null || flexWrap.equals("nowrap")) {
            this.setFlexWrap(YogaWrap.NO_WRAP);
        } else if (flexWrap.equals("wrap")) {
            this.setFlexWrap(YogaWrap.WRAP);
        } else {
            throw new IllegalArgumentException("Unknown flexWrap value: " + flexWrap);
        }
    }

    @ReactProp(name="alignSelf")
    public void setAlignSelf(@Nullable String alignSelf) {
        if (this.isVirtual()) {
            return;
        }
        this.setAlignSelf(alignSelf == null ? YogaAlign.AUTO : YogaAlign.valueOf(alignSelf.toUpperCase(Locale.US).replace("-", "_")));
    }

    @ReactProp(name="alignItems")
    public void setAlignItems(@Nullable String alignItems) {
        if (this.isVirtual()) {
            return;
        }
        this.setAlignItems(alignItems == null ? YogaAlign.STRETCH : YogaAlign.valueOf(alignItems.toUpperCase(Locale.US).replace("-", "_")));
    }

    @ReactProp(name="justifyContent")
    public void setJustifyContent(@Nullable String justifyContent) {
        if (this.isVirtual()) {
            return;
        }
        this.setJustifyContent(justifyContent == null ? YogaJustify.FLEX_START : YogaJustify.valueOf(justifyContent.toUpperCase(Locale.US).replace("-", "_")));
    }

    @ReactProp(name="overflow")
    public void setOverflow(@Nullable String overflow) {
        if (this.isVirtual()) {
            return;
        }
        this.setOverflow(overflow == null ? YogaOverflow.VISIBLE : YogaOverflow.valueOf(overflow.toUpperCase(Locale.US).replace("-", "_")));
    }

    @ReactPropGroup(names={"margin", "marginVertical", "marginHorizontal", "marginLeft", "marginRight", "marginTop", "marginBottom"})
    public void setMargins(int index, Dynamic margin) {
        if (this.isVirtual()) {
            return;
        }
        if (!LayoutShadowNode.isNull(margin) && LayoutShadowNode.dynamicIsPercent(margin)) {
            this.setMarginPercent(ViewProps.PADDING_MARGIN_SPACING_TYPES[index], LayoutShadowNode.getDynamicAsPercent(margin));
        } else {
            this.setMargin(ViewProps.PADDING_MARGIN_SPACING_TYPES[index], LayoutShadowNode.isNull(margin) ? Float.NaN : LayoutShadowNode.getDynamicAsFloat(margin));
        }
        margin.recycle();
    }

    @ReactPropGroup(names={"padding", "paddingVertical", "paddingHorizontal", "paddingLeft", "paddingRight", "paddingTop", "paddingBottom"})
    public void setPaddings(int index, Dynamic padding) {
        if (this.isVirtual()) {
            return;
        }
        if (!LayoutShadowNode.isNull(padding) && LayoutShadowNode.dynamicIsPercent(padding)) {
            this.setPaddingPercent(ViewProps.PADDING_MARGIN_SPACING_TYPES[index], LayoutShadowNode.getDynamicAsPercent(padding));
        } else {
            this.setPadding(ViewProps.PADDING_MARGIN_SPACING_TYPES[index], LayoutShadowNode.isNull(padding) ? Float.NaN : LayoutShadowNode.getDynamicAsFloat(padding));
        }
        padding.recycle();
    }

    @ReactPropGroup(names={"borderWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth"}, defaultFloat=NaNf)
    public void setBorderWidths(int index, float borderWidth) {
        if (this.isVirtual()) {
            return;
        }
        this.setBorder(ViewProps.BORDER_SPACING_TYPES[index], PixelUtil.toPixelFromDIP(borderWidth));
    }

    @ReactPropGroup(names={"left", "right", "top", "bottom"})
    public void setPositionValues(int index, Dynamic position) {
        if (this.isVirtual()) {
            return;
        }
        if (!LayoutShadowNode.isNull(position) && LayoutShadowNode.dynamicIsPercent(position)) {
            this.setPositionPercent(ViewProps.POSITION_SPACING_TYPES[index], LayoutShadowNode.getDynamicAsPercent(position));
        } else {
            this.setPosition(ViewProps.POSITION_SPACING_TYPES[index], LayoutShadowNode.isNull(position) ? Float.NaN : LayoutShadowNode.getDynamicAsFloat(position));
        }
        position.recycle();
    }

    @ReactProp(name="position")
    public void setPosition(@Nullable String position) {
        if (this.isVirtual()) {
            return;
        }
        YogaPositionType positionType = position == null ? YogaPositionType.RELATIVE : YogaPositionType.valueOf(position.toUpperCase(Locale.US));
        this.setPositionType(positionType);
    }

    @Override
    @ReactProp(name="onLayout")
    public void setShouldNotifyOnLayout(boolean shouldNotifyOnLayout) {
        super.setShouldNotifyOnLayout(shouldNotifyOnLayout);
    }
}

