/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import android.net.Uri;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.SupportsWebWorkers;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import javax.annotation.Nullable;

@ReactModule(name="DeviceEventManager")
public class DeviceEventManagerModule
extends ReactContextBaseJavaModule {
    private final Runnable mInvokeDefaultBackPressRunnable;

    public DeviceEventManagerModule(ReactApplicationContext reactContext, final DefaultHardwareBackBtnHandler backBtnHandler) {
        super(reactContext);
        this.mInvokeDefaultBackPressRunnable = new Runnable(){

            @Override
            public void run() {
                UiThreadUtil.assertOnUiThread();
                backBtnHandler.invokeDefaultOnBackPressed();
            }
        };
    }

    public void emitHardwareBackPressed() {
        this.getReactApplicationContext().getJSModule(RCTDeviceEventEmitter.class).emit("hardwareBackPress", null);
    }

    public void emitNewIntentReceived(Uri uri) {
        WritableMap map = Arguments.createMap();
        map.putString("url", uri.toString());
        this.getReactApplicationContext().getJSModule(RCTDeviceEventEmitter.class).emit("url", map);
    }

    @ReactMethod
    public void invokeDefaultBackPressHandler() {
        this.getReactApplicationContext().runOnUiQueueThread(this.mInvokeDefaultBackPressRunnable);
    }

    @Override
    public String getName() {
        return "DeviceEventManager";
    }

    @SupportsWebWorkers
    public static interface RCTDeviceEventEmitter
    extends JavaScriptModule {
        public void emit(String var1, @Nullable Object var2);
    }
}

