/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.annotation.TargetApi;
import android.content.Context;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.view.ViewGroup;
import android.widget.EditText;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.flat.AndroidView;
import com.facebook.react.flat.RCTVirtualText;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.view.MeasureUtil;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNodeAPI;
import javax.annotation.Nullable;

public class RCTTextInput
extends RCTVirtualText
implements AndroidView,
YogaMeasureFunction {
    @Nullable
    private String mText;
    private int mJsEventCount = -1;
    private boolean mPaddingChanged = false;
    private int mNumberOfLines = -1;
    @Nullable
    private EditText mEditText;

    public RCTTextInput() {
        this.forceMountToView();
        this.setMeasureFunction(this);
    }

    @Override
    protected void notifyChanged(boolean shouldRemeasure) {
        super.notifyChanged(shouldRemeasure);
        this.markUpdated();
    }

    @Override
    @TargetApi(value=17)
    public void setThemedContext(ThemedReactContext themedContext) {
        super.setThemedContext(themedContext);
        this.mEditText = new EditText((Context)themedContext);
        this.mEditText.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.setDefaultPadding(4, this.mEditText.getPaddingStart());
        this.setDefaultPadding(1, this.mEditText.getPaddingTop());
        this.setDefaultPadding(5, this.mEditText.getPaddingEnd());
        this.setDefaultPadding(3, this.mEditText.getPaddingBottom());
        this.mEditText.setPadding(0, 0, 0, 0);
    }

    @Override
    public long measure(YogaNodeAPI node, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
        EditText editText = (EditText)Assertions.assertNotNull((Object)this.mEditText);
        int fontSize = this.getFontSize();
        editText.setTextSize(0, fontSize == -1 ? (float)((int)Math.ceil(PixelUtil.toPixelFromSP(14.0f))) : (float)fontSize);
        if (this.mNumberOfLines != -1) {
            editText.setLines(this.mNumberOfLines);
        }
        editText.measure(MeasureUtil.getMeasureSpec(width, widthMode), MeasureUtil.getMeasureSpec(height, heightMode));
        return YogaMeasureOutput.make(editText.getMeasuredWidth(), editText.getMeasuredHeight());
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isVirtualAnchor() {
        return true;
    }

    @Override
    public void setBackgroundColor(int backgroundColor) {
    }

    @Override
    public void onCollectExtraUpdates(UIViewOperationQueue uiViewOperationQueue) {
        super.onCollectExtraUpdates(uiViewOperationQueue);
        if (this.mJsEventCount != -1) {
            ReactTextUpdate reactTextUpdate = new ReactTextUpdate((Spannable)this.getText(), this.mJsEventCount, false, this.getPadding(4), this.getPadding(1), this.getPadding(5), this.getPadding(3), -1);
            uiViewOperationQueue.enqueueUpdateExtraData(this.getReactTag(), reactTextUpdate);
        }
    }

    @ReactProp(name="mostRecentEventCount")
    public void setMostRecentEventCount(int mostRecentEventCount) {
        this.mJsEventCount = mostRecentEventCount;
    }

    @ReactProp(name="numberOfLines", defaultInt=0x7FFFFFFF)
    public void setNumberOfLines(int numberOfLines) {
        this.mNumberOfLines = numberOfLines;
        this.notifyChanged(true);
    }

    @ReactProp(name="text")
    public void setText(@Nullable String text) {
        this.mText = text;
        this.notifyChanged(true);
    }

    @Override
    public void setPadding(int spacingType, float padding) {
        super.setPadding(spacingType, padding);
        this.mPaddingChanged = true;
        this.dirty();
    }

    @Override
    public boolean isPaddingChanged() {
        return this.mPaddingChanged;
    }

    @Override
    public void resetPaddingChanged() {
        this.mPaddingChanged = false;
    }

    @Override
    boolean shouldAllowEmptySpans() {
        return true;
    }

    @Override
    boolean isEditable() {
        return true;
    }

    @Override
    protected void performCollectText(SpannableStringBuilder builder) {
        if (this.mText != null) {
            builder.append((CharSequence)this.mText);
        }
        super.performCollectText(builder);
    }

    @Override
    public boolean needsCustomLayoutForChildren() {
        return false;
    }
}

