/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.View;
import android.view.animation.Animation;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.flat.DrawCommand;
import com.facebook.react.flat.DrawCommandManager;
import com.facebook.react.flat.DrawView;
import com.facebook.react.flat.FlatViewGroup;
import com.facebook.react.flat.NodeRegion;
import com.facebook.react.flat.StateBuilder;
import com.facebook.react.flat.ViewResolver;
import com.facebook.react.uimanager.ReactClippingViewGroup;
import com.facebook.react.uimanager.ReactClippingViewGroupHelper;
import java.util.ArrayList;
import javax.annotation.Nullable;

abstract class ClippingDrawCommandManager
extends DrawCommandManager {
    private final FlatViewGroup mFlatViewGroup;
    private DrawCommand[] mDrawCommands = DrawCommand.EMPTY_ARRAY;
    protected float[] mCommandMaxBottom = StateBuilder.EMPTY_FLOAT_ARRAY;
    protected float[] mCommandMinTop = StateBuilder.EMPTY_FLOAT_ARRAY;
    private NodeRegion[] mNodeRegions = NodeRegion.EMPTY_ARRAY;
    protected float[] mRegionMaxBottom = StateBuilder.EMPTY_FLOAT_ARRAY;
    protected float[] mRegionMinTop = StateBuilder.EMPTY_FLOAT_ARRAY;
    private int mStart;
    private int mStop;
    private SparseIntArray mDrawViewIndexMap = StateBuilder.EMPTY_SPARSE_INT;
    private final SparseArray<View> mClippedSubviews = new SparseArray();
    protected final Rect mClippingRect = new Rect();
    private final SparseArray<View> mViewsToRemove = new SparseArray();
    private final ArrayList<View> mViewsToKeep = new ArrayList();
    private final ArrayList<ReactClippingViewGroup> mClippingViewGroups = new ArrayList();

    ClippingDrawCommandManager(FlatViewGroup flatViewGroup, DrawCommand[] drawCommands) {
        this.mFlatViewGroup = flatViewGroup;
        this.initialSetup(drawCommands);
    }

    private void initialSetup(DrawCommand[] drawCommands) {
        this.mountDrawCommands(drawCommands, this.mDrawViewIndexMap, this.mCommandMaxBottom, this.mCommandMinTop, true);
        this.updateClippingRect();
    }

    abstract int commandStartIndex();

    abstract int commandStopIndex(int var1);

    abstract int regionStopIndex(float var1, float var2);

    abstract boolean regionAboveTouch(int var1, float var2, float var3);

    @Override
    public void mountDrawCommands(DrawCommand[] drawCommands, SparseIntArray drawViewIndexMap, float[] maxBottom, float[] minTop, boolean willMountViews) {
        this.mDrawCommands = drawCommands;
        this.mCommandMaxBottom = maxBottom;
        this.mCommandMinTop = minTop;
        this.mDrawViewIndexMap = drawViewIndexMap;
        if (this.mClippingRect.bottom != this.mClippingRect.top) {
            this.mStart = this.commandStartIndex();
            this.mStop = this.commandStopIndex(this.mStart);
            if (!willMountViews) {
                this.updateClippingToCurrentRect();
            }
        }
    }

    @Override
    public void mountNodeRegions(NodeRegion[] nodeRegions, float[] maxBottom, float[] minTop) {
        this.mNodeRegions = nodeRegions;
        this.mRegionMaxBottom = maxBottom;
        this.mRegionMinTop = minTop;
    }

    @Override
    @Nullable
    public NodeRegion virtualNodeRegionWithinBounds(float touchX, float touchY) {
        int i = this.regionStopIndex(touchX, touchY);
        while (i-- > 0) {
            NodeRegion nodeRegion = this.mNodeRegions[i];
            if (!nodeRegion.mIsVirtual) continue;
            if (this.regionAboveTouch(i, touchX, touchY)) break;
            if (!nodeRegion.withinBounds(touchX, touchY)) continue;
            return nodeRegion;
        }
        return null;
    }

    @Override
    @Nullable
    public NodeRegion anyNodeRegionWithinBounds(float touchX, float touchY) {
        int i = this.regionStopIndex(touchX, touchY);
        while (i-- > 0) {
            NodeRegion nodeRegion = this.mNodeRegions[i];
            if (this.regionAboveTouch(i, touchX, touchY)) break;
            if (!nodeRegion.withinBounds(touchX, touchY)) continue;
            return nodeRegion;
        }
        return null;
    }

    private void clip(int id2, View view) {
        this.mClippedSubviews.put(id2, (Object)view);
    }

    private void unclip(int id2) {
        this.mClippedSubviews.remove(id2);
    }

    private boolean isClipped(int id2) {
        return this.mClippedSubviews.get(id2) != null;
    }

    private boolean isNotClipped(int id2) {
        return this.mClippedSubviews.get(id2) == null;
    }

    @Override
    void onClippedViewDropped(View view) {
        this.unclip(view.getId());
        this.mFlatViewGroup.removeDetachedView(view);
    }

    @Override
    public void mountViews(ViewResolver viewResolver, int[] viewsToAdd, int[] viewsToDetach) {
        this.mClippingViewGroups.clear();
        for (int viewToAdd : viewsToAdd) {
            boolean newView;
            boolean bl = newView = viewToAdd > 0;
            if (!newView) {
                viewToAdd = -viewToAdd;
            }
            int commandArrayIndex = this.mDrawViewIndexMap.get(viewToAdd);
            DrawView drawView = (DrawView)this.mDrawCommands[commandArrayIndex];
            View view = viewResolver.getView(drawView.reactTag);
            ClippingDrawCommandManager.ensureViewHasNoParent(view);
            if (view instanceof ReactClippingViewGroup && ((ReactClippingViewGroup)view).getRemoveClippedSubviews()) {
                this.mClippingViewGroups.add((ReactClippingViewGroup)view);
            }
            if (newView) {
                drawView.mWasMounted = true;
                if (ClippingDrawCommandManager.animating(view) || this.withinBounds(commandArrayIndex)) {
                    this.mFlatViewGroup.addViewInLayout(view);
                    continue;
                }
                this.clip(drawView.reactTag, view);
                continue;
            }
            if (drawView.mWasMounted) {
                if (!this.isNotClipped(drawView.reactTag)) continue;
                this.mFlatViewGroup.attachViewToParent(view);
                continue;
            }
            drawView.mWasMounted = true;
            if (ClippingDrawCommandManager.animating(view) || this.withinBounds(commandArrayIndex)) {
                if (this.isClipped(drawView.reactTag)) {
                    this.mFlatViewGroup.addViewInLayout(view);
                    this.unclip(drawView.reactTag);
                    continue;
                }
                this.mFlatViewGroup.attachViewToParent(view);
                continue;
            }
            if (!this.isNotClipped(drawView.reactTag)) continue;
            this.mFlatViewGroup.removeDetachedView(view);
            this.clip(drawView.reactTag, view);
        }
        for (int viewToDetach : viewsToDetach) {
            View view = viewResolver.getView(viewToDetach);
            if (view.getParent() != null) {
                throw new RuntimeException("Trying to remove view not owned by FlatViewGroup");
            }
            this.mFlatViewGroup.removeDetachedView(view);
            this.unclip(viewToDetach);
        }
    }

    private static boolean animating(View view) {
        Animation animation = view.getAnimation();
        return animation != null && !animation.hasEnded();
    }

    private boolean withinBounds(int i) {
        return this.mStart <= i && i < this.mStop;
    }

    @Override
    public boolean updateClippingRect() {
        ReactClippingViewGroupHelper.calculateClippingRect((View)this.mFlatViewGroup, this.mClippingRect);
        if (this.mFlatViewGroup.getParent() == null || this.mClippingRect.top == this.mClippingRect.bottom) {
            return false;
        }
        int start = this.commandStartIndex();
        int stop = this.commandStopIndex(start);
        if (this.mStart <= start && stop <= this.mStop) {
            this.updateClippingRecursively();
            return false;
        }
        this.mStart = start;
        this.mStop = stop;
        this.updateClippingToCurrentRect();
        this.updateClippingRecursively();
        return true;
    }

    private void updateClippingRecursively() {
        int children = this.mClippingViewGroups.size();
        for (int i = 0; i < children; ++i) {
            ReactClippingViewGroup view = this.mClippingViewGroups.get(i);
            if (!this.isNotClipped(((View)view).getId())) continue;
            view.updateClippingRect();
        }
    }

    private void updateClippingToCurrentRect() {
        boolean removeAll;
        int size = this.mFlatViewGroup.getChildCount();
        for (int i = 0; i < size; ++i) {
            View view = this.mFlatViewGroup.getChildAt(i);
            int index = this.mDrawViewIndexMap.get(view.getId());
            if (this.withinBounds(index) || ClippingDrawCommandManager.animating(view)) {
                this.mViewsToKeep.add(view);
                continue;
            }
            this.mViewsToRemove.append(i, (Object)view);
            this.clip(view.getId(), view);
        }
        int removeSize = this.mViewsToRemove.size();
        boolean bl = removeAll = removeSize > 2;
        if (removeAll) {
            this.mFlatViewGroup.detachAllViewsFromParent();
            for (int i = 0; i < removeSize; ++i) {
                this.mFlatViewGroup.removeDetachedView((View)this.mViewsToRemove.valueAt(i));
            }
        } else {
            while (removeSize-- > 0) {
                this.mFlatViewGroup.removeViewsInLayout(this.mViewsToRemove.keyAt(removeSize), 1);
            }
        }
        this.mViewsToRemove.clear();
        int current = this.mStart;
        int childIndex = 0;
        int size2 = this.mViewsToKeep.size();
        for (int i = 0; i < size2; ++i) {
            View view = this.mViewsToKeep.get(i);
            int commandIndex = this.mDrawViewIndexMap.get(view.getId());
            if (current <= commandIndex) {
                while (current != commandIndex) {
                    if (this.mDrawCommands[current] instanceof DrawView) {
                        DrawView drawView = (DrawView)this.mDrawCommands[current];
                        this.mFlatViewGroup.addViewInLayout((View)Assertions.assumeNotNull((Object)this.mClippedSubviews.get(drawView.reactTag)), childIndex++);
                        this.unclip(drawView.reactTag);
                    }
                    ++current;
                }
                ++current;
            }
            if (removeAll) {
                this.mFlatViewGroup.attachViewToParent(view, childIndex);
            }
            ++childIndex;
        }
        this.mViewsToKeep.clear();
        while (current < this.mStop) {
            if (this.mDrawCommands[current] instanceof DrawView) {
                DrawView drawView = (DrawView)this.mDrawCommands[current];
                this.mFlatViewGroup.addViewInLayout((View)Assertions.assumeNotNull((Object)this.mClippedSubviews.get(drawView.reactTag)), childIndex++);
                this.unclip(drawView.reactTag);
            }
            ++current;
        }
    }

    @Override
    public void getClippingRect(Rect outClippingRect) {
        outClippingRect.set(this.mClippingRect);
    }

    @Override
    public SparseArray<View> getDetachedViews() {
        return this.mClippedSubviews;
    }

    @Override
    public void draw(Canvas canvas) {
        int commandIndex = this.mStart;
        int size = this.mFlatViewGroup.getChildCount();
        for (int i = 0; i < size; ++i) {
            int viewIndex = this.mDrawViewIndexMap.get(this.mFlatViewGroup.getChildAt(i).getId());
            if (this.mStop < viewIndex) {
                while (commandIndex < this.mStop) {
                    this.mDrawCommands[commandIndex++].draw(this.mFlatViewGroup, canvas);
                }
            } else if (commandIndex <= viewIndex) {
                while (commandIndex < viewIndex) {
                    this.mDrawCommands[commandIndex++].draw(this.mFlatViewGroup, canvas);
                }
                ++commandIndex;
            }
            this.mDrawCommands[viewIndex].draw(this.mFlatViewGroup, canvas);
        }
        while (commandIndex < this.mStop) {
            this.mDrawCommands[commandIndex++].draw(this.mFlatViewGroup, canvas);
        }
    }

    @Override
    void debugDraw(Canvas canvas) {
        for (DrawCommand drawCommand : this.mDrawCommands) {
            if (drawCommand instanceof DrawView) {
                if (!this.isNotClipped(((DrawView)drawCommand).reactTag)) continue;
                drawCommand.debugDraw(this.mFlatViewGroup, canvas);
                continue;
            }
            drawCommand.debugDraw(this.mFlatViewGroup, canvas);
        }
    }
}

