/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.ExecutorToken;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.JavaScriptModuleRegistration;
import com.facebook.react.bridge.WritableNativeArray;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import javax.annotation.Nullable;

public class JavaScriptModuleRegistry {
    private final WeakHashMap<ExecutorToken, HashMap<Class<? extends JavaScriptModule>, JavaScriptModule>> mModuleInstances = new WeakHashMap();
    private final HashMap<Class<? extends JavaScriptModule>, JavaScriptModuleRegistration> mModuleRegistrations = new HashMap();

    public JavaScriptModuleRegistry(List<JavaScriptModuleRegistration> config) {
        for (JavaScriptModuleRegistration registration : config) {
            this.mModuleRegistrations.put(registration.getModuleInterface(), registration);
        }
    }

    public synchronized <T extends JavaScriptModule> T getJavaScriptModule(CatalystInstance instance, ExecutorToken executorToken, Class<T> moduleInterface) {
        JavaScriptModule module;
        HashMap<Class<JavaScriptModule>, JavaScriptModule> instancesForContext = this.mModuleInstances.get(executorToken);
        if (instancesForContext == null) {
            instancesForContext = new HashMap();
            this.mModuleInstances.put(executorToken, instancesForContext);
        }
        if ((module = instancesForContext.get(moduleInterface)) != null) {
            return (T)module;
        }
        JavaScriptModuleRegistration registration = (JavaScriptModuleRegistration)Assertions.assertNotNull((Object)this.mModuleRegistrations.get(moduleInterface), (String)("JS module " + moduleInterface.getSimpleName() + " hasn't been registered!"));
        JavaScriptModule interfaceProxy = (JavaScriptModule)Proxy.newProxyInstance(moduleInterface.getClassLoader(), new Class[]{moduleInterface}, (InvocationHandler)new JavaScriptModuleInvocationHandler(executorToken, instance, registration));
        instancesForContext.put(moduleInterface, interfaceProxy);
        return (T)interfaceProxy;
    }

    private static class JavaScriptModuleInvocationHandler
    implements InvocationHandler {
        private final WeakReference<ExecutorToken> mExecutorToken;
        private final CatalystInstance mCatalystInstance;
        private final JavaScriptModuleRegistration mModuleRegistration;

        public JavaScriptModuleInvocationHandler(ExecutorToken executorToken, CatalystInstance catalystInstance, JavaScriptModuleRegistration moduleRegistration) {
            this.mExecutorToken = new WeakReference<ExecutorToken>(executorToken);
            this.mCatalystInstance = catalystInstance;
            this.mModuleRegistration = moduleRegistration;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, @Nullable Object[] args) throws Throwable {
            ExecutorToken executorToken = (ExecutorToken)this.mExecutorToken.get();
            if (executorToken == null) {
                FLog.w((String)"React", (String)"Dropping JS call, ExecutorToken went away...");
                return null;
            }
            WritableNativeArray jsArgs = args != null ? Arguments.fromJavaArgs(args) : new WritableNativeArray();
            this.mCatalystInstance.callFunction(executorToken, this.mModuleRegistration.getName(), method.getName(), jsArgs);
            return null;
        }
    }

    public static class Builder {
        private List<JavaScriptModuleRegistration> mModules = new ArrayList<JavaScriptModuleRegistration>();

        public Builder add(Class<? extends JavaScriptModule> moduleInterfaceClass) {
            this.mModules.add(new JavaScriptModuleRegistration(moduleInterfaceClass));
            return this;
        }

        public JavaScriptModuleRegistry build() {
            return new JavaScriptModuleRegistry(this.mModules);
        }
    }
}

