/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.style;

import android.content.Context;
import android.graphics.Shader;
import com.facebook.react.bridge.ColorPropConverter;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.style.ColorStop;
import com.facebook.react.uimanager.style.ColorStopUtils;
import com.facebook.react.uimanager.style.Gradient;
import com.facebook.react.uimanager.style.ProcessedColorStop;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0013H\u0002J,\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/facebook/react/uimanager/style/LinearGradient;", "Lcom/facebook/react/uimanager/style/Gradient;", "direction", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction;", "colorStops", "", "Lcom/facebook/react/uimanager/style/ColorStop;", "<init>", "(Lcom/facebook/react/uimanager/style/LinearGradient$Direction;Ljava/util/List;)V", "getDirection", "()Lcom/facebook/react/uimanager/style/LinearGradient$Direction;", "getColorStops", "()Ljava/util/List;", "getShader", "Landroid/graphics/Shader;", "width", "", "height", "getAngleForKeyword", "", "keyword", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction$KeywordType;", "endPointsFromAngle", "Lkotlin/Pair;", "", "angle", "Companion", "Direction", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nLinearGradient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinearGradient.kt\ncom/facebook/react/uimanager/style/LinearGradient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1878#2,3:191\n*S KotlinDebug\n*F\n+ 1 LinearGradient.kt\ncom/facebook/react/uimanager/style/LinearGradient\n*L\n111#1:191,3\n*E\n"})
public final class LinearGradient
implements Gradient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Direction direction;
    @NotNull
    private final List<ColorStop> colorStops;

    public LinearGradient(@NotNull Direction direction, @NotNull List<ColorStop> colorStops) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter(colorStops, (String)"colorStops");
        this.direction = direction;
        this.colorStops = colorStops;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    @NotNull
    public final List<ColorStop> getColorStops() {
        return this.colorStops;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Shader getShader(float width, float height) {
        double d;
        Pair<float[], float[]> pair = this.direction;
        if (pair instanceof Direction.Angle) {
            d = ((Direction.Angle)this.direction).getAngle();
        } else if (pair instanceof Direction.Keyword) {
            d = this.getAngleForKeyword(((Direction.Keyword)this.direction).getKeyword(), width, height);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        double angle = d;
        pair = this.endPointsFromAngle(angle, height, width);
        float[] startPoint = (float[])pair.component1();
        float[] endPoint = (float[])pair.component2();
        float dx = endPoint[0] - startPoint[0];
        float dy = endPoint[1] - startPoint[1];
        float gradientLineLength = (float)Math.sqrt(dx * dx + dy * dy);
        List<ProcessedColorStop> finalStops = ColorStopUtils.INSTANCE.getFixedColorStops(this.colorStops, gradientLineLength);
        int[] colors = new int[finalStops.size()];
        float[] positions = new float[finalStops.size()];
        Iterable $this$forEachIndexed$iv = finalStops;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void colorStop;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ProcessedColorStop processedColorStop = (ProcessedColorStop)item$iv;
            int i = n;
            boolean bl = false;
            Integer color = colorStop.getColor();
            if (color == null || colorStop.getPosition() == null) continue;
            colors[i] = color;
            positions[i] = colorStop.getPosition().floatValue();
        }
        return (Shader)new android.graphics.LinearGradient(startPoint[0], startPoint[1], endPoint[0], endPoint[1], colors, positions, Shader.TileMode.CLAMP);
    }

    private final double getAngleForKeyword(Direction.KeywordType keyword, double width, double height) {
        return switch (WhenMappings.$EnumSwitchMapping$0[keyword.ordinal()]) {
            case 1 -> {
                double angleDeg = Math.toDegrees(Math.atan(width / height));
                yield (double)90 - angleDeg;
            }
            case 2 -> Math.toDegrees(Math.atan(width / height)) + (double)90;
            case 3 -> Math.toDegrees(Math.atan(width / height)) + (double)270;
            case 4 -> Math.toDegrees(Math.atan(height / width)) + (double)180;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final Pair<float[], float[]> endPointsFromAngle(double angle, float height, float width) {
        float[] fArray;
        double d;
        double adjustedAngle = angle % (double)360;
        if (adjustedAngle < 0.0) {
            adjustedAngle += (double)360;
        }
        if ((d = adjustedAngle) == 0.0) {
            float[] fArray2 = new float[]{0.0f, height};
            float[] fArray3 = fArray2;
            fArray2 = new float[]{0.0f, 0.0f};
            return new Pair((Object)fArray3, (Object)fArray2);
        }
        if (d == 90.0) {
            float[] fArray4 = new float[]{0.0f, 0.0f};
            float[] fArray5 = fArray4;
            fArray4 = new float[]{width, 0.0f};
            return new Pair((Object)fArray5, (Object)fArray4);
        }
        if (d == 180.0) {
            float[] fArray6 = new float[]{0.0f, 0.0f};
            float[] fArray7 = fArray6;
            fArray6 = new float[]{0.0f, height};
            return new Pair((Object)fArray7, (Object)fArray6);
        }
        if (d == 270.0) {
            float[] fArray8 = new float[]{width, 0.0f};
            float[] fArray9 = fArray8;
            fArray8 = new float[]{0.0f, 0.0f};
            return new Pair((Object)fArray9, (Object)fArray8);
        }
        float slope = (float)Math.tan(Math.toRadians((double)90 - adjustedAngle));
        float perpendicularSlope = (float)-1 / slope;
        float halfHeight = height / (float)2;
        float halfWidth = width / (float)2;
        if (adjustedAngle < 90.0) {
            var12_14 = new float[]{halfWidth, halfHeight};
            fArray = var12_14;
        } else if (adjustedAngle < 180.0) {
            var12_14 = new float[]{halfWidth, -halfHeight};
            fArray = var12_14;
        } else if (adjustedAngle < 270.0) {
            var12_14 = new float[]{-halfWidth, -halfHeight};
            fArray = var12_14;
        } else {
            var12_14 = new float[]{-halfWidth, halfHeight};
            fArray = var12_14;
        }
        float[] endCorner = fArray;
        float c = endCorner[1] - perpendicularSlope * endCorner[0];
        float endX = c / (slope - perpendicularSlope);
        float endY = perpendicularSlope * endX + c;
        float[] fArray10 = new float[]{halfWidth + endX, halfHeight - endY};
        float[] secondPoint = fArray10;
        float[] fArray11 = new float[]{halfWidth - endX, halfHeight + endY};
        float[] firstPoint = fArray11;
        return new Pair((Object)firstPoint, (Object)secondPoint);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/facebook/react/uimanager/style/LinearGradient$Companion;", "", "<init>", "()V", "parse", "Lcom/facebook/react/uimanager/style/Gradient;", "gradientMap", "Lcom/facebook/react/bridge/ReadableMap;", "context", "Landroid/content/Context;", "ReactAndroid_release"})
    @SourceDebugExtension(value={"SMAP\nLinearGradient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinearGradient.kt\ncom/facebook/react/uimanager/style/LinearGradient$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Gradient parse(@NotNull ReadableMap gradientMap, @NotNull Context context) {
            ArrayList<ColorStop> colorStops;
            ReadableMap readableMap;
            Direction direction;
            ReadableMap readableMap2;
            ReadableMap readableMap3;
            Intrinsics.checkNotNullParameter((Object)gradientMap, (String)"gradientMap");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ReadableMap it = readableMap3 = gradientMap;
            boolean bl = false;
            ReadableMap readableMap4 = readableMap2 = it.hasKey("direction") ? readableMap3 : null;
            if (readableMap2 != null) {
                ReadableMap map = readableMap2;
                boolean bl2 = false;
                ReadableMap readableMap5 = map.getMap("direction");
                if (readableMap5 == null) {
                    return null;
                }
                ReadableMap directionMap = readableMap5;
                String string2 = directionMap.getString("type");
                if (Intrinsics.areEqual((Object)string2, (Object)"angle")) {
                    double angle = directionMap.getDouble("value");
                    direction = new Direction.Angle(angle);
                } else if (Intrinsics.areEqual((Object)string2, (Object)"keyword")) {
                    Direction.Keyword keyword;
                    Direction.KeywordType keywordType = Direction.KeywordType.Companion.fromString(directionMap.getString("value"));
                    if (keywordType != null) {
                        Direction.KeywordType keywordType2 = keywordType;
                        boolean bl3 = false;
                        keyword = new Direction.Keyword(keywordType2);
                    } else {
                        keyword = null;
                    }
                    direction = keyword;
                } else {
                    direction = null;
                }
            } else {
                direction = null;
            }
            Direction direction2 = direction;
            ReadableMap it2 = readableMap = gradientMap;
            boolean bl4 = false;
            ReadableMap readableMap6 = readableMap3 = it2.hasKey("colorStops") ? readableMap : null;
            if (readableMap3 != null) {
                ReadableMap map = readableMap3;
                boolean bl5 = false;
                ReadableArray readableArray = map.getArray("colorStops");
                if (readableArray == null) {
                    return null;
                }
                ReadableArray colorStopsArray = readableArray;
                ArrayList<ColorStop> stops = new ArrayList<ColorStop>(colorStopsArray.size());
                int n = colorStopsArray.size();
                for (int i = 0; i < n; ++i) {
                    ReadableMap colorStop;
                    if (colorStopsArray.getMap(i) == null) continue;
                    Integer color = !colorStop.hasKey("color") || colorStop.isNull("color") ? null : (colorStop.getType("color") == ReadableType.Map ? ColorPropConverter.getColor(colorStop.getMap("color"), context) : Integer.valueOf(colorStop.getInt("color")));
                    LengthPercentage colorStopPosition = LengthPercentage.Companion.setFromDynamic(colorStop.getDynamic("position"));
                    stops.add(new ColorStop(color, colorStopPosition));
                }
                v7 = stops;
            } else {
                v7 = colorStops = null;
            }
            if (direction2 != null && colorStops != null) {
                return new LinearGradient(direction2, (List<ColorStop>)colorStops);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0007\b\u00a8\u0006\t"}, d2={"Lcom/facebook/react/uimanager/style/LinearGradient$Direction;", "", "<init>", "()V", "Angle", "Keyword", "KeywordType", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Angle;", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Keyword;", "ReactAndroid_release"})
    public static abstract class Direction {
        private Direction() {
        }

        public /* synthetic */ Direction(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Angle;", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction;", "angle", "", "<init>", "(D)V", "getAngle", "()D", "ReactAndroid_release"})
        public static final class Angle
        extends Direction {
            private final double angle;

            public Angle(double angle) {
                super(null);
                this.angle = angle;
            }

            public final double getAngle() {
                return this.angle;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/react/uimanager/style/LinearGradient$Direction$Keyword;", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction;", "keyword", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction$KeywordType;", "<init>", "(Lcom/facebook/react/uimanager/style/LinearGradient$Direction$KeywordType;)V", "getKeyword", "()Lcom/facebook/react/uimanager/style/LinearGradient$Direction$KeywordType;", "ReactAndroid_release"})
        public static final class Keyword
        extends Direction {
            @NotNull
            private final KeywordType keyword;

            public Keyword(@NotNull KeywordType keyword) {
                Intrinsics.checkNotNullParameter((Object)((Object)keyword), (String)"keyword");
                super(null);
                this.keyword = keyword;
            }

            @NotNull
            public final KeywordType getKeyword() {
                return this.keyword;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lcom/facebook/react/uimanager/style/LinearGradient$Direction$KeywordType;", "", "value", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "TO_TOP_RIGHT", "TO_BOTTOM_RIGHT", "TO_TOP_LEFT", "TO_BOTTOM_LEFT", "Companion", "ReactAndroid_release"})
        public static final class KeywordType
        extends Enum<KeywordType> {
            @NotNull
            public static final Companion Companion;
            @NotNull
            private final String value;
            public static final /* enum */ KeywordType TO_TOP_RIGHT;
            public static final /* enum */ KeywordType TO_BOTTOM_RIGHT;
            public static final /* enum */ KeywordType TO_TOP_LEFT;
            public static final /* enum */ KeywordType TO_BOTTOM_LEFT;
            private static final /* synthetic */ KeywordType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private KeywordType(String value) {
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            public static KeywordType[] values() {
                return (KeywordType[])$VALUES.clone();
            }

            public static KeywordType valueOf(String value) {
                return Enum.valueOf(KeywordType.class, value);
            }

            @NotNull
            public static EnumEntries<KeywordType> getEntries() {
                return $ENTRIES;
            }

            static {
                TO_TOP_RIGHT = new KeywordType("to top right");
                TO_BOTTOM_RIGHT = new KeywordType("to bottom right");
                TO_TOP_LEFT = new KeywordType("to top left");
                TO_BOTTOM_LEFT = new KeywordType("to bottom left");
                $VALUES = keywordTypeArray = new KeywordType[]{KeywordType.TO_TOP_RIGHT, KeywordType.TO_BOTTOM_RIGHT, KeywordType.TO_TOP_LEFT, KeywordType.TO_BOTTOM_LEFT};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/react/uimanager/style/LinearGradient$Direction$KeywordType$Companion;", "", "<init>", "()V", "fromString", "Lcom/facebook/react/uimanager/style/LinearGradient$Direction$KeywordType;", "value", "", "ReactAndroid_release"})
            @SourceDebugExtension(value={"SMAP\nLinearGradient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinearGradient.kt\ncom/facebook/react/uimanager/style/LinearGradient$Direction$KeywordType$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
            public static final class Companion {
                private Companion() {
                }

                @Nullable
                public final KeywordType fromString(@Nullable String value) {
                    KeywordType keywordType;
                    block1: {
                        KeywordType[] keywordTypeArray = KeywordType.values();
                        int n = keywordTypeArray.length;
                        for (int i = 0; i < n; ++i) {
                            KeywordType keywordType2;
                            KeywordType it = keywordType2 = keywordTypeArray[i];
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getValue(), (Object)value)) continue;
                            keywordType = keywordType2;
                            break block1;
                        }
                        keywordType = null;
                    }
                    return keywordType;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.KeywordType.values().length];
            try {
                nArray[Direction.KeywordType.TO_TOP_RIGHT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.KeywordType.TO_BOTTOM_RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.KeywordType.TO_TOP_LEFT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.KeywordType.TO_BOTTOM_LEFT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

