/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.layoutanimation;

import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import com.facebook.react.uimanager.layoutanimation.LayoutHandlingAnimation;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J(\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J(\u0010!\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002R\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00040\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/facebook/react/uimanager/layoutanimation/PositionAndSizeAnimation;", "Landroid/view/animation/Animation;", "Lcom/facebook/react/uimanager/layoutanimation/LayoutHandlingAnimation;", "view", "Landroid/view/View;", "x", "", "y", "width", "height", "<init>", "(Landroid/view/View;IIII)V", "viewRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "startX", "", "startY", "deltaX", "deltaY", "startWidth", "startHeight", "deltaWidth", "deltaHeight", "applyTransformation", "", "interpolatedTime", "t", "Landroid/view/animation/Transformation;", "onLayoutUpdate", "isValid", "", "willChangeBounds", "calculateAnimation", "Companion", "ReactAndroid_release"})
public final class PositionAndSizeAnimation
extends Animation
implements LayoutHandlingAnimation {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final WeakReference<View> viewRef;
    private float startX;
    private float startY;
    private float deltaX;
    private float deltaY;
    private int startWidth;
    private int startHeight;
    private int deltaWidth;
    private int deltaHeight;

    public PositionAndSizeAnimation(@NotNull View view, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.viewRef = new WeakReference<View>(view);
        this.calculateAnimation(x, y, width, height);
    }

    protected void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            View view = (View)this.viewRef.get();
            if (view == null) break block0;
            View view2 = view;
            boolean bl = false;
            float newX = this.startX + this.deltaX * interpolatedTime;
            float newY = this.startY + this.deltaY * interpolatedTime;
            float newWidth = (float)this.startWidth + (float)this.deltaWidth * interpolatedTime;
            float newHeight = (float)this.startHeight + (float)this.deltaHeight * interpolatedTime;
            view2.layout(Math.round(newX), Math.round(newY), Math.round(newX + newWidth), Math.round(newY + newHeight));
        }
    }

    @Override
    public void onLayoutUpdate(int x, int y, int width, int height) {
        this.calculateAnimation(x, y, width, height);
    }

    @Override
    public boolean isValid() {
        return this.viewRef.get() != null;
    }

    public boolean willChangeBounds() {
        return true;
    }

    private final void calculateAnimation(int x, int y, int width, int height) {
        block0: {
            View view = (View)this.viewRef.get();
            if (view == null) break block0;
            View view2 = view;
            boolean bl = false;
            this.startX = view2.getX() - view2.getTranslationX();
            this.startY = view2.getY() - view2.getTranslationY();
            this.startWidth = view2.getWidth();
            this.startHeight = view2.getHeight();
            this.deltaX = (float)x - this.startX;
            this.deltaY = (float)y - this.startY;
            this.deltaWidth = width - this.startWidth;
            this.deltaHeight = height - this.startHeight;
        }
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("PositionAndSizeAnimation", LegacyArchitectureLogLevel.ERROR);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/facebook/react/uimanager/layoutanimation/PositionAndSizeAnimation$Companion;", "", "<init>", "()V", "ReactAndroid_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

