/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.provider.Settings;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.devsupport.BundleDownloader;
import com.facebook.react.devsupport.CxxInspectorPackagerConnection;
import com.facebook.react.devsupport.IInspectorPackagerConnection;
import com.facebook.react.devsupport.InspectorFlags;
import com.facebook.react.devsupport.PackagerStatusCheck;
import com.facebook.react.devsupport.interfaces.DevBundleDownloadListener;
import com.facebook.react.devsupport.interfaces.PackagerStatusCallback;
import com.facebook.react.modules.debug.interfaces.DeveloperSettings;
import com.facebook.react.modules.systeminfo.AndroidInfoHelpers;
import com.facebook.react.packagerconnection.FileIoHandler;
import com.facebook.react.packagerconnection.JSPackagerClient;
import com.facebook.react.packagerconnection.NotificationOnlyHandler;
import com.facebook.react.packagerconnection.PackagerConnectionSettings;
import com.facebook.react.packagerconnection.ReconnectingWebSocket;
import com.facebook.react.packagerconnection.RequestHandler;
import com.facebook.react.util.RNLog;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.-DeprecatedOkio;
import okio.-DeprecatedUpgrade;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 N2\u00020\u0001:\u0003LMNB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u000b2\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020$J\u0006\u0010)\u001a\u00020$J\u0006\u0010*\u001a\u00020$J\u0006\u0010+\u001a\u00020$J6\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u000b2\b\u00102\u001a\u0004\u0018\u0001032\b\b\u0002\u00104\u001a\u000205H\u0007J\u0018\u00106\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\u000bH\u0002J6\u00109\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020;2\b\b\u0002\u00108\u001a\u00020\u000b2\b\b\u0002\u0010<\u001a\u00020\u001e2\b\b\u0002\u0010=\u001a\u00020\u001eH\u0002J\u0010\u0010>\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020\u000bH\u0016J\u0010\u0010@\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020\u000bH\u0016J\u0010\u0010A\u001a\u00020$2\u0006\u0010-\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020\u000bH\u0016J\u0010\u0010E\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020\u000bH\u0016J\u0018\u0010F\u001a\u0004\u0018\u0001002\u0006\u0010G\u001a\u00020\u000b2\u0006\u0010/\u001a\u000200J\u001a\u0010H\u001a\u00020$2\b\u0010I\u001a\u0004\u0018\u00010J2\b\u0010K\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\rR\u0014\u0010\u001b\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\rR\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 \u00a8\u0006O"}, d2={"Lcom/facebook/react/devsupport/DevServerHelper;", "", "settings", "Lcom/facebook/react/modules/debug/interfaces/DeveloperSettings;", "applicationContext", "Landroid/content/Context;", "packagerConnectionSettings", "Lcom/facebook/react/packagerconnection/PackagerConnectionSettings;", "<init>", "(Lcom/facebook/react/modules/debug/interfaces/DeveloperSettings;Landroid/content/Context;Lcom/facebook/react/packagerconnection/PackagerConnectionSettings;)V", "websocketProxyURL", "", "getWebsocketProxyURL", "()Ljava/lang/String;", "client", "Lokhttp3/OkHttpClient;", "bundleDownloader", "Lcom/facebook/react/devsupport/BundleDownloader;", "packagerStatusCheck", "Lcom/facebook/react/devsupport/PackagerStatusCheck;", "packageName", "packagerClient", "Lcom/facebook/react/packagerconnection/JSPackagerClient;", "inspectorPackagerConnection", "Lcom/facebook/react/devsupport/IInspectorPackagerConnection;", "inspectorDeviceId", "getInspectorDeviceId", "inspectorDeviceUrl", "getInspectorDeviceUrl", "devMode", "", "getDevMode", "()Z", "jSMinifyMode", "getJSMinifyMode", "openPackagerConnection", "", "clientId", "commandListener", "Lcom/facebook/react/devsupport/DevServerHelper$PackagerCommandListener;", "closePackagerConnection", "openInspectorConnection", "disableDebugger", "closeInspectorConnection", "downloadBundleFromURL", "callback", "Lcom/facebook/react/devsupport/interfaces/DevBundleDownloadListener;", "outputFile", "Ljava/io/File;", "bundleURL", "bundleInfo", "Lcom/facebook/react/devsupport/BundleDownloader$BundleInfo;", "requestBuilder", "Lokhttp3/Request$Builder;", "createSplitBundleURL", "mainModuleID", "host", "createBundleURL", "type", "Lcom/facebook/react/devsupport/DevServerHelper$BundleType;", "modulesOnly", "runModule", "getDevServerBundleURL", "jsModulePath", "getDevServerSplitBundleURL", "isPackagerRunning", "Lcom/facebook/react/devsupport/interfaces/PackagerStatusCallback;", "getSourceMapUrl", "mainModuleName", "getSourceUrl", "downloadBundleResourceFromUrlSync", "resourcePath", "openDebugger", "context", "Lcom/facebook/react/bridge/ReactContext;", "errorMessage", "PackagerCommandListener", "BundleType", "Companion", "ReactAndroid_release"})
@SuppressLint(value={"StaticFieldLeak"})
public class DevServerHelper {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final DeveloperSettings settings;
    @NotNull
    private final Context applicationContext;
    @NotNull
    private final PackagerConnectionSettings packagerConnectionSettings;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final BundleDownloader bundleDownloader;
    @NotNull
    private final PackagerStatusCheck packagerStatusCheck;
    @NotNull
    private final String packageName;
    @Nullable
    private JSPackagerClient packagerClient;
    @Nullable
    private IInspectorPackagerConnection inspectorPackagerConnection;
    private static final int HTTP_CONNECT_TIMEOUT_MS = 5000;
    @NotNull
    private static final String DEBUGGER_MSG_DISABLE = "{ \"id\":1,\"method\":\"Debugger.disable\" }";

    public DevServerHelper(@NotNull DeveloperSettings settings, @NotNull Context applicationContext, @NotNull PackagerConnectionSettings packagerConnectionSettings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)packagerConnectionSettings, (String)"packagerConnectionSettings");
        this.settings = settings;
        this.applicationContext = applicationContext;
        this.packagerConnectionSettings = packagerConnectionSettings;
        this.client = new OkHttpClient.Builder().connectTimeout(5000L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS).build();
        this.bundleDownloader = new BundleDownloader(this.client);
        this.packagerStatusCheck = new PackagerStatusCheck(this.client);
        String string2 = this.applicationContext.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPackageName(...)");
        this.packageName = string2;
    }

    @NotNull
    public final String getWebsocketProxyURL() {
        return "ws://" + this.packagerConnectionSettings.getDebugServerHost() + "/debugger-proxy?role=client";
    }

    private final String getInspectorDeviceId() {
        String packageName = this.packageName;
        String androidId = Settings.Secure.getString((ContentResolver)this.applicationContext.getContentResolver(), (String)"android_id");
        Locale locale = Locale.US;
        String string2 = "android-%s-%s-%s";
        Object[] objectArray = new Object[]{packageName, androidId, InspectorFlags.getFuseboxEnabled() ? "fusebox" : "legacy"};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String rawDeviceId = string3;
        return DevServerHelper.Companion.getSHA256(rawDeviceId);
    }

    private final String getInspectorDeviceUrl() {
        Locale locale = Locale.US;
        String string2 = "http://%s/inspector/device?name=%s&app=%s&device=%s&profiling=%b";
        Object[] objectArray = new Object[]{this.packagerConnectionSettings.getDebugServerHost(), Uri.encode((String)AndroidInfoHelpers.getFriendlyDeviceName()), Uri.encode((String)this.packageName), Uri.encode((String)this.getInspectorDeviceId()), InspectorFlags.getIsProfilingBuild()};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    private final boolean getDevMode() {
        return this.settings.isJSDevModeEnabled();
    }

    private final boolean getJSMinifyMode() {
        return this.settings.isJSMinifyEnabled();
    }

    public final void openPackagerConnection(@Nullable String clientId, @NotNull PackagerCommandListener commandListener) {
        Intrinsics.checkNotNullParameter((Object)commandListener, (String)"commandListener");
        if (this.packagerClient != null) {
            FLog.w((String)"ReactNative", (String)"Packager connection already open, nooping.");
            return;
        }
        new AsyncTask<Void, Void, Void>(commandListener, clientId, this){
            final /* synthetic */ PackagerCommandListener $commandListener;
            final /* synthetic */ String $clientId;
            final /* synthetic */ DevServerHelper this$0;
            {
                this.$commandListener = $commandListener;
                this.$clientId = $clientId;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            @Deprecated(message="This needs to be rewritten to not use AsyncTasks")
            protected Void doInBackground(Void ... backgroundParams) {
                void $this$doInBackground_u24lambda_u241;
                Object it;
                Intrinsics.checkNotNullParameter((Object)backgroundParams, (String)"backgroundParams");
                Map handlers = new LinkedHashMap<K, V>();
                handlers.put("reload", new NotificationOnlyHandler(this.$commandListener){
                    final /* synthetic */ PackagerCommandListener $commandListener;
                    {
                        this.$commandListener = $commandListener;
                    }

                    public void onNotification(Object params) {
                        this.$commandListener.onPackagerReloadCommand();
                    }
                });
                handlers.put("devMenu", new NotificationOnlyHandler(this.$commandListener){
                    final /* synthetic */ PackagerCommandListener $commandListener;
                    {
                        this.$commandListener = $commandListener;
                    }

                    public void onNotification(Object params) {
                        this.$commandListener.onPackagerDevMenuCommand();
                    }
                });
                Map<String, RequestHandler> map = this.$commandListener.customCommandHandlers();
                if (map != null) {
                    it = map;
                    boolean bl = false;
                    handlers.putAll(it);
                }
                handlers.putAll(new FileIoHandler().handlers());
                ReconnectingWebSocket.ConnectionCallback onPackagerConnectedCallback2 = new ReconnectingWebSocket.ConnectionCallback(this.$commandListener){
                    final /* synthetic */ PackagerCommandListener $commandListener;
                    {
                        this.$commandListener = $commandListener;
                    }

                    public void onConnected() {
                        this.$commandListener.onPackagerConnected();
                    }

                    public void onDisconnected() {
                        this.$commandListener.onPackagerDisconnected();
                    }
                };
                if (this.$clientId == null) {
                    it = "Required value was null.";
                    throw new IllegalStateException(it.toString());
                }
                JSPackagerClient jSPackagerClient = new JSPackagerClient(this.$clientId, DevServerHelper.access$getPackagerConnectionSettings$p(this.this$0), handlers, onPackagerConnectedCallback2);
                it = jSPackagerClient;
                DevServerHelper devServerHelper = this.this$0;
                boolean bl = false;
                $this$doInBackground_u24lambda_u241.init();
                DevServerHelper.access$setPackagerClient$p(devServerHelper, jSPackagerClient);
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public final void closePackagerConnection() {
        new AsyncTask<Void, Void, Void>(this){
            final /* synthetic */ DevServerHelper this$0;
            {
                this.this$0 = $receiver;
            }

            @Deprecated(message="This class needs to be rewritten to don't use AsyncTasks")
            protected Void doInBackground(Void ... params) {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                JSPackagerClient jSPackagerClient = DevServerHelper.access$getPackagerClient$p(this.this$0);
                if (jSPackagerClient != null) {
                    jSPackagerClient.close();
                }
                DevServerHelper.access$setPackagerClient$p(this.this$0, null);
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public final void openInspectorConnection() {
        if (this.inspectorPackagerConnection != null) {
            FLog.w((String)"ReactNative", (String)"Inspector connection already open, nooping.");
            return;
        }
        new AsyncTask<Void, Void, Void>(this){
            final /* synthetic */ DevServerHelper this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            @Deprecated(message="This class needs to be rewritten to don't use AsyncTasks")
            protected Void doInBackground(Void ... params) {
                void $this$doInBackground_u24lambda_u240;
                CxxInspectorPackagerConnection cxxInspectorPackagerConnection;
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                Map<String, String> metadata = AndroidInfoHelpers.getInspectorHostMetadata(DevServerHelper.access$getApplicationContext$p(this.this$0));
                String deviceName = metadata.get("deviceName");
                if (deviceName == null) {
                    FLog.w((String)"ReactNative", (String)"Could not get device name from Inspector Host Metadata.");
                    return null;
                }
                CxxInspectorPackagerConnection cxxInspectorPackagerConnection2 = cxxInspectorPackagerConnection = new CxxInspectorPackagerConnection(DevServerHelper.access$getInspectorDeviceUrl(this.this$0), deviceName, DevServerHelper.access$getPackageName$p(this.this$0));
                DevServerHelper devServerHelper = this.this$0;
                boolean bl = false;
                $this$doInBackground_u24lambda_u240.connect();
                DevServerHelper.access$setInspectorPackagerConnection$p(devServerHelper, cxxInspectorPackagerConnection);
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public final void disableDebugger() {
        block0: {
            IInspectorPackagerConnection iInspectorPackagerConnection = this.inspectorPackagerConnection;
            if (iInspectorPackagerConnection == null) break block0;
            iInspectorPackagerConnection.sendEventToAllConnections(DEBUGGER_MSG_DISABLE);
        }
    }

    public final void closeInspectorConnection() {
        new AsyncTask<Void, Void, Void>(this){
            final /* synthetic */ DevServerHelper this$0;
            {
                this.this$0 = $receiver;
            }

            @Deprecated(message="This class needs to be rewritten to don't use AsyncTasks")
            protected Void doInBackground(Void ... params) {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                IInspectorPackagerConnection iInspectorPackagerConnection = DevServerHelper.access$getInspectorPackagerConnection$p(this.this$0);
                if (iInspectorPackagerConnection != null) {
                    iInspectorPackagerConnection.closeQuietly();
                }
                DevServerHelper.access$setInspectorPackagerConnection$p(this.this$0, null);
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    @JvmOverloads
    public final void downloadBundleFromURL(@NotNull DevBundleDownloadListener callback, @NotNull File outputFile, @Nullable String bundleURL, @Nullable BundleDownloader.BundleInfo bundleInfo, @NotNull Request.Builder requestBuilder) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)requestBuilder, (String)"requestBuilder");
        this.bundleDownloader.downloadBundleFromURL(callback, outputFile, bundleURL, bundleInfo, requestBuilder);
    }

    public static /* synthetic */ void downloadBundleFromURL$default(DevServerHelper devServerHelper, DevBundleDownloadListener devBundleDownloadListener, File file, String string2, BundleDownloader.BundleInfo bundleInfo, Request.Builder builder, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: downloadBundleFromURL");
        }
        if ((n & 0x10) != 0) {
            builder = new Request.Builder();
        }
        devServerHelper.downloadBundleFromURL(devBundleDownloadListener, file, string2, bundleInfo, builder);
    }

    private final String createSplitBundleURL(String mainModuleID, String host) {
        return this.createBundleURL(mainModuleID, BundleType.BUNDLE, host, true, false);
    }

    private final String createBundleURL(String mainModuleID, BundleType type, String host, boolean modulesOnly, boolean runModule) {
        boolean dev = this.getDevMode();
        StringBuilder additionalOptionsBuilder = new StringBuilder();
        for (Map.Entry<String, String> object2 : this.packagerConnectionSettings.getAdditionalOptionsForPackager().entrySet()) {
            String key = object2.getKey();
            String value = object2.getValue();
            if (((CharSequence)value).length() == 0) continue;
            additionalOptionsBuilder.append("&" + key + "=" + Uri.encode((String)value));
        }
        Locale locale = Locale.US;
        String string2 = "http://%s/%s.%s?platform=android&dev=%s&lazy=%s&minify=%s&app=%s&modulesOnly=%s&runModule=%s";
        Object[] objectArray = new Object[]{host, mainModuleID, type.getTypeID(), dev, dev, this.getJSMinifyMode(), this.packageName, modulesOnly ? "true" : "false", runModule ? "true" : "false"};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3 + (InspectorFlags.getFuseboxEnabled() ? "&excludeSource=true&sourcePaths=url-server" : "") + additionalOptionsBuilder;
    }

    static /* synthetic */ String createBundleURL$default(DevServerHelper devServerHelper, String string2, BundleType bundleType, String string3, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createBundleURL");
        }
        if ((n & 4) != 0) {
            string3 = devServerHelper.packagerConnectionSettings.getDebugServerHost();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        return devServerHelper.createBundleURL(string2, bundleType, string3, bl, bl2);
    }

    @NotNull
    public String getDevServerBundleURL(@NotNull String jsModulePath) {
        Intrinsics.checkNotNullParameter((Object)jsModulePath, (String)"jsModulePath");
        return DevServerHelper.createBundleURL$default(this, jsModulePath, BundleType.BUNDLE, this.packagerConnectionSettings.getDebugServerHost(), false, false, 24, null);
    }

    @NotNull
    public String getDevServerSplitBundleURL(@NotNull String jsModulePath) {
        Intrinsics.checkNotNullParameter((Object)jsModulePath, (String)"jsModulePath");
        return this.createSplitBundleURL(jsModulePath, this.packagerConnectionSettings.getDebugServerHost());
    }

    public void isPackagerRunning(@NotNull PackagerStatusCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.packagerStatusCheck.run(this.packagerConnectionSettings.getDebugServerHost(), callback);
    }

    @NotNull
    public String getSourceMapUrl(@NotNull String mainModuleName) {
        Intrinsics.checkNotNullParameter((Object)mainModuleName, (String)"mainModuleName");
        return DevServerHelper.createBundleURL$default(this, mainModuleName, BundleType.MAP, null, false, false, 28, null);
    }

    @NotNull
    public String getSourceUrl(@NotNull String mainModuleName) {
        Intrinsics.checkNotNullParameter((Object)mainModuleName, (String)"mainModuleName");
        return DevServerHelper.createBundleURL$default(this, mainModuleName, BundleType.BUNDLE, null, false, false, 28, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final File downloadBundleResourceFromUrlSync(@NotNull String resourcePath, @NotNull File outputFile) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        String resourceURL = DevServerHelper.Companion.createResourceURL(this.packagerConnectionSettings.getDebugServerHost(), resourcePath);
        Request request = new Request.Builder().url(resourceURL).build();
        try {
            Closeable closeable = (Closeable)this.client.newCall(request).execute();
            Throwable throwable = null;
            try {
                Response response = (Response)closeable;
                boolean bl = false;
                if (!response.isSuccessful() || response.-deprecated_body() == null) {
                    File file = null;
                    return file;
                }
                Closeable closeable2 = (Closeable)-DeprecatedUpgrade.getOkio().sink(outputFile);
                Throwable throwable2 = null;
                try {
                    Sink output = (Sink)closeable2;
                    boolean bl2 = false;
                    -DeprecatedOkio -DeprecatedOkio2 = -DeprecatedUpgrade.getOkio();
                    ResponseBody responseBody2 = response.-deprecated_body();
                    Object object = responseBody2 != null ? responseBody2.source() : null;
                    Intrinsics.checkNotNull((Object)object);
                    long l = -DeprecatedOkio2.buffer((Source)object).readAll(output);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                File file = outputFile;
                return file;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{resourcePath, outputFile.getAbsolutePath(), e};
            FLog.e((String)"ReactNative", (String)"Failed to fetch resource synchronously - resourcePath: \"%s\", outputFile: \"%s\"", (Object[])objectArray);
            return null;
        }
    }

    public final void openDebugger(@Nullable ReactContext context, @Nullable String errorMessage) {
        Locale locale = Locale.US;
        String string2 = "http://%s/open-debugger?device=%s";
        Object[] objectArray = new Object[]{this.packagerConnectionSettings.getDebugServerHost(), Uri.encode((String)this.getInspectorDeviceId())};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String requestUrl = string3;
        Request request = new Request.Builder().url(requestUrl).method("POST", RequestBody.Companion.create(null, "")).build();
        this.client.newCall(request).enqueue(new Callback(context, errorMessage){
            final /* synthetic */ ReactContext $context;
            final /* synthetic */ String $errorMessage;
            {
                this.$context = $context;
                this.$errorMessage = $errorMessage;
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string2 = this.$errorMessage;
                if (string2 == null) {
                    string2 = "openDebugger error";
                }
                RNLog.w(this.$context, string2);
            }

            public void onResponse(Call call, Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            }
        });
    }

    @JvmOverloads
    public final void downloadBundleFromURL(@NotNull DevBundleDownloadListener callback, @NotNull File outputFile, @Nullable String bundleURL, @Nullable BundleDownloader.BundleInfo bundleInfo) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        DevServerHelper.downloadBundleFromURL$default(this, callback, outputFile, bundleURL, bundleInfo, null, 16, null);
    }

    public static final /* synthetic */ void access$setPackagerClient$p(DevServerHelper $this, JSPackagerClient jSPackagerClient) {
        $this.packagerClient = jSPackagerClient;
    }

    public static final /* synthetic */ PackagerConnectionSettings access$getPackagerConnectionSettings$p(DevServerHelper $this) {
        return $this.packagerConnectionSettings;
    }

    public static final /* synthetic */ JSPackagerClient access$getPackagerClient$p(DevServerHelper $this) {
        return $this.packagerClient;
    }

    public static final /* synthetic */ Context access$getApplicationContext$p(DevServerHelper $this) {
        return $this.applicationContext;
    }

    public static final /* synthetic */ void access$setInspectorPackagerConnection$p(DevServerHelper $this, IInspectorPackagerConnection iInspectorPackagerConnection) {
        $this.inspectorPackagerConnection = iInspectorPackagerConnection;
    }

    public static final /* synthetic */ String access$getInspectorDeviceUrl(DevServerHelper $this) {
        return $this.getInspectorDeviceUrl();
    }

    public static final /* synthetic */ String access$getPackageName$p(DevServerHelper $this) {
        return $this.packageName;
    }

    public static final /* synthetic */ IInspectorPackagerConnection access$getInspectorPackagerConnection$p(DevServerHelper $this) {
        return $this.inspectorPackagerConnection;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/facebook/react/devsupport/DevServerHelper$BundleType;", "", "typeID", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getTypeID", "()Ljava/lang/String;", "BUNDLE", "MAP", "ReactAndroid_release"})
    private static final class BundleType
    extends Enum<BundleType> {
        @NotNull
        private final String typeID;
        public static final /* enum */ BundleType BUNDLE = new BundleType("bundle");
        public static final /* enum */ BundleType MAP = new BundleType("map");
        private static final /* synthetic */ BundleType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private BundleType(String typeID) {
            this.typeID = typeID;
        }

        @NotNull
        public final String getTypeID() {
            return this.typeID;
        }

        public static BundleType[] values() {
            return (BundleType[])$VALUES.clone();
        }

        public static BundleType valueOf(String value) {
            return Enum.valueOf(BundleType.class, value);
        }

        @NotNull
        public static EnumEntries<BundleType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = bundleTypeArray = new BundleType[]{BundleType.BUNDLE, BundleType.MAP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/react/devsupport/DevServerHelper$Companion;", "", "<init>", "()V", "HTTP_CONNECT_TIMEOUT_MS", "", "DEBUGGER_MSG_DISABLE", "", "getSHA256", "string", "createResourceURL", "host", "resourcePathParam", "ReactAndroid_release"})
    private static final class Companion {
        private Companion() {
        }

        private final String getSHA256(String string2) {
            byte[] byArray;
            MessageDigest messageDigest;
            try {
                messageDigest = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError("Could not get standard SHA-256 algorithm", e);
            }
            MessageDigest digest = messageDigest;
            digest.reset();
            try {
                Charset charset = Charset.forName("UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                byte[] byArray2 = string2.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                byArray = digest.digest(byArray2);
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError("This environment doesn't support UTF-8 encoding", e);
            }
            byte[] result = byArray;
            String string3 = "%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x";
            Object[] objectArray = new Object[]{result[0], result[1], result[2], result[3], result[4], result[5], result[6], result[7], result[8], result[9], result[10], result[11], result[12], result[13], result[14], result[15], result[16], result[17], result[18], result[19]};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            return string4;
        }

        private final String createResourceURL(String host, String resourcePathParam) {
            String resourcePath = resourcePathParam;
            if (StringsKt.startsWith$default((String)resourcePath, (String)"/", (boolean)false, (int)2, null)) {
                FLog.w((String)"ReactNative", (String)"Resource path should not begin with `/`, removing it.");
                String string2 = resourcePath.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                resourcePath = string2;
            }
            Locale locale = Locale.US;
            String string3 = "http://%s/%s";
            Object[] objectArray = new Object[]{host, resourcePath};
            String string4 = String.format(locale, string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            return string4;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\b\u0010\u0005\u001a\u00020\u0003H&J\b\u0010\u0006\u001a\u00020\u0003H&J\u0016\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/devsupport/DevServerHelper$PackagerCommandListener;", "", "onPackagerConnected", "", "onPackagerDisconnected", "onPackagerReloadCommand", "onPackagerDevMenuCommand", "customCommandHandlers", "", "", "Lcom/facebook/react/packagerconnection/RequestHandler;", "ReactAndroid_release"})
    public static interface PackagerCommandListener {
        public void onPackagerConnected();

        public void onPackagerDisconnected();

        public void onPackagerReloadCommand();

        public void onPackagerDevMenuCommand();

        @Nullable
        public Map<String, RequestHandler> customCommandHandlers();
    }
}

