/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.ReactActivity;
import com.facebook.react.ReactApplication;
import com.facebook.react.ReactDelegate;
import com.facebook.react.ReactHost;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactNativeHost;
import com.facebook.react.ReactRootView;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.interfaces.fabric.ReactSurface;
import com.facebook.react.internal.featureflags.ReactNativeNewArchitectureFeatureFlags;
import com.facebook.react.modules.core.PermissionListener;
import com.facebook.react.views.view.WindowUtilKt;
import com.facebook.systrace.Systrace;
import java.util.Objects;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ReactActivityDelegate {
    @Nullable
    private final Activity mActivity;
    @Nullable
    private final String mMainComponentName;
    @Nullable
    private PermissionListener mPermissionListener;
    @Nullable
    private Callback mPermissionsCallback;
    @Nullable
    private ReactDelegate mReactDelegate;

    @Deprecated
    public ReactActivityDelegate(@Nullable Activity activity, @Nullable String mainComponentName) {
        this.mActivity = activity;
        this.mMainComponentName = mainComponentName;
    }

    public ReactActivityDelegate(@Nullable ReactActivity activity, @Nullable String mainComponentName) {
        this.mActivity = activity;
        this.mMainComponentName = mainComponentName;
    }

    @Nullable
    protected Bundle getLaunchOptions() {
        return null;
    }

    @Nullable
    protected Bundle composeLaunchOptions() {
        return this.getLaunchOptions();
    }

    @Nullable
    protected ReactRootView createRootView() {
        return null;
    }

    @Deprecated
    protected ReactNativeHost getReactNativeHost() {
        return ((ReactApplication)this.getPlainActivity().getApplication()).getReactNativeHost();
    }

    @Nullable
    public ReactHost getReactHost() {
        return ((ReactApplication)this.getPlainActivity().getApplication()).getReactHost();
    }

    @Nullable
    protected ReactDelegate getReactDelegate() {
        return this.mReactDelegate;
    }

    public ReactInstanceManager getReactInstanceManager() {
        return Objects.requireNonNull(this.mReactDelegate).getReactInstanceManager();
    }

    @Nullable
    public String getMainComponentName() {
        return this.mMainComponentName;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        Systrace.traceSection(0L, "ReactActivityDelegate.onCreate::init", () -> {
            Window window;
            String mainComponentName = this.getMainComponentName();
            Bundle launchOptions = this.composeLaunchOptions();
            if (this.mActivity != null && (window = this.mActivity.getWindow()) != null) {
                if (WindowUtilKt.isEdgeToEdgeFeatureFlagOn()) {
                    WindowUtilKt.enableEdgeToEdge(window);
                }
                if (Build.VERSION.SDK_INT >= 26 && this.isWideColorGamutEnabled()) {
                    window.setColorMode(1);
                }
            }
            this.mReactDelegate = ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture() ? new ReactDelegate(this.getPlainActivity(), this.getReactHost(), mainComponentName, launchOptions) : new ReactDelegate(this.getPlainActivity(), this.getReactNativeHost(), mainComponentName, launchOptions, this.isFabricEnabled()){

                @Override
                @Nullable
                protected ReactRootView createRootView() {
                    ReactRootView rootView = ReactActivityDelegate.this.createRootView();
                    if (rootView == null) {
                        rootView = super.createRootView();
                    }
                    return rootView;
                }
            };
            if (mainComponentName != null) {
                this.loadApp(mainComponentName);
            }
        });
    }

    protected void loadApp(@Nullable String appKey) {
        Objects.requireNonNull(this.mReactDelegate).loadApp(Objects.requireNonNull(appKey));
        this.getPlainActivity().setContentView((View)this.mReactDelegate.getReactRootView());
    }

    public void setReactSurface(ReactSurface reactSurface) {
        Objects.requireNonNull(this.mReactDelegate).setReactSurface(reactSurface);
    }

    public void setReactRootView(ReactRootView reactRootView) {
        Objects.requireNonNull(this.mReactDelegate).setReactRootView(reactRootView);
    }

    public void onUserLeaveHint() {
        Objects.requireNonNull(this.mReactDelegate).onUserLeaveHint();
    }

    public void onPause() {
        Objects.requireNonNull(this.mReactDelegate).onHostPause();
    }

    public void onResume() {
        Objects.requireNonNull(this.mReactDelegate).onHostResume();
        if (this.mPermissionsCallback != null) {
            this.mPermissionsCallback.invoke(new Object[0]);
            this.mPermissionsCallback = null;
        }
    }

    public void onDestroy() {
        Objects.requireNonNull(this.mReactDelegate).onHostDestroy();
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        Objects.requireNonNull(this.mReactDelegate).onActivityResult(requestCode, resultCode, data, true);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return Objects.requireNonNull(this.mReactDelegate).onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return Objects.requireNonNull(this.mReactDelegate).shouldShowDevMenuOrReload(keyCode, event);
    }

    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        return Objects.requireNonNull(this.mReactDelegate).onKeyLongPress(keyCode);
    }

    public boolean onBackPressed() {
        return Objects.requireNonNull(this.mReactDelegate).onBackPressed();
    }

    public boolean onNewIntent(@Nullable Intent intent) {
        return Objects.requireNonNull(this.mReactDelegate).onNewIntent(Objects.requireNonNull(intent));
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        Objects.requireNonNull(this.mReactDelegate).onWindowFocusChanged(hasFocus);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        Objects.requireNonNull(this.mReactDelegate).onConfigurationChanged(newConfig);
    }

    public void requestPermissions(String[] permissions, int requestCode, @Nullable PermissionListener listener) {
        this.mPermissionListener = listener;
        this.getPlainActivity().requestPermissions(permissions, requestCode);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        this.mPermissionsCallback = args -> {
            if (this.mPermissionListener != null && this.mPermissionListener.onRequestPermissionsResult(requestCode, permissions, grantResults)) {
                this.mPermissionListener = null;
            }
        };
    }

    protected Context getContext() {
        return (Context)Assertions.assertNotNull((Object)this.mActivity);
    }

    protected Activity getPlainActivity() {
        return (Activity)this.getContext();
    }

    protected ReactActivity getReactActivity() {
        return (ReactActivity)this.getContext();
    }

    @Nullable
    public ReactContext getCurrentReactContext() {
        return Objects.requireNonNull(this.mReactDelegate).getCurrentReactContext();
    }

    protected boolean isFabricEnabled() {
        return ReactNativeNewArchitectureFeatureFlags.enableFabricRenderer();
    }

    protected boolean isWideColorGamutEnabled() {
        return false;
    }
}

