/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.view.ReactViewGroup;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\nH\u0017\u00a2\u0006\u0002\u0010\u000bJ%\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00112\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001f\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00072\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00072\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/facebook/react/views/view/ReactClippingViewManager;", "T", "Lcom/facebook/react/views/view/ReactViewGroup;", "Lcom/facebook/react/uimanager/ViewGroupManager;", "<init>", "()V", "setRemoveClippedSubviews", "", "view", "removeClippedSubviews", "", "(Lcom/facebook/react/views/view/ReactViewGroup;Z)V", "addView", "parent", "child", "Landroid/view/View;", "index", "", "(Lcom/facebook/react/views/view/ReactViewGroup;Landroid/view/View;I)V", "getChildCount", "(Lcom/facebook/react/views/view/ReactViewGroup;)I", "getChildAt", "(Lcom/facebook/react/views/view/ReactViewGroup;I)Landroid/view/View;", "removeViewAt", "(Lcom/facebook/react/views/view/ReactViewGroup;I)V", "removeAllViews", "(Lcom/facebook/react/views/view/ReactViewGroup;)V", "ReactAndroid_debug"})
public abstract class ReactClippingViewManager<T extends ReactViewGroup>
extends ViewGroupManager<T> {
    public ReactClippingViewManager() {
        super(null, 1, null);
    }

    @ReactProp(name="removeClippedSubviews")
    public void setRemoveClippedSubviews(@NotNull T view, boolean removeClippedSubviews) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        UiThreadUtil.assertOnUiThread();
        ((ReactViewGroup)view).setRemoveClippedSubviews(removeClippedSubviews);
    }

    @Override
    public void addView(@NotNull T parent, @NotNull View child, int index) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        UiThreadUtil.assertOnUiThread();
        boolean removeClippedSubviews = ((ReactViewGroup)parent).getRemoveClippedSubviews();
        if (removeClippedSubviews) {
            ((ReactViewGroup)parent).addViewWithSubviewClippingEnabled$ReactAndroid_debug(child, index);
        } else {
            ((ViewGroup)parent).addView(child, index);
        }
    }

    @Override
    public int getChildCount(@NotNull T parent) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        boolean removeClippedSubviews = ((ReactViewGroup)parent).getRemoveClippedSubviews();
        return removeClippedSubviews ? ((ReactViewGroup)parent).getAllChildrenCount$ReactAndroid_debug() : ((ViewGroup)parent).getChildCount();
    }

    @Override
    @Nullable
    public View getChildAt(@NotNull T parent, int index) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        boolean removeClippedSubviews = ((ReactViewGroup)parent).getRemoveClippedSubviews();
        return removeClippedSubviews ? ((ReactViewGroup)parent).getChildAtWithSubviewClippingEnabled$ReactAndroid_debug(index) : ((ViewGroup)parent).getChildAt(index);
    }

    @Override
    public void removeViewAt(@NotNull T parent, int index) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        UiThreadUtil.assertOnUiThread();
        boolean removeClippedSubviews = ((ReactViewGroup)parent).getRemoveClippedSubviews();
        if (removeClippedSubviews) {
            View child = this.getChildAt(parent, index);
            if (child != null) {
                ((ReactViewGroup)parent).removeViewWithSubviewClippingEnabled$ReactAndroid_debug(child);
            }
        } else {
            ((ViewGroup)parent).removeViewAt(index);
        }
    }

    @Override
    public void removeAllViews(@NotNull T parent) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        UiThreadUtil.assertOnUiThread();
        boolean removeClippedSubviews = ((ReactViewGroup)parent).getRemoveClippedSubviews();
        if (removeClippedSubviews) {
            ((ReactViewGroup)parent).removeAllViewsWithSubviewClippingEnabled$ReactAndroid_debug();
        } else {
            ((ViewGroup)parent).removeAllViews();
        }
    }
}

