/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text.frescosupport;

import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import com.facebook.common.logging.FLog;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.text.frescosupport.FrescoBasedReactTextInlineImageSpan;
import com.facebook.react.views.text.internal.ReactTextInlineImageShadowNode;
import com.facebook.react.views.text.internal.span.TextInlineImageSpan;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B+\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J\u0012\u0010\u0018\u001a\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\fH\u0007J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0013H\u0007J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u001eH\u0016J\u0012\u0010!\u001a\u00020\u00152\b\u0010\"\u001a\u0004\u0018\u00010\u0010H\u0007J\b\u0010#\u001a\u0004\u0018\u00010\nJ\b\u0010$\u001a\u0004\u0018\u00010\fJ\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u0014\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003J\b\u0010*\u001a\u0004\u0018\u00010\u0006R \u0010\u0002\u001a\u0014\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/facebook/react/views/text/frescosupport/FrescoBasedReactTextInlineImageShadowNode;", "Lcom/facebook/react/views/text/internal/ReactTextInlineImageShadowNode;", "draweeControllerBuilder", "Lcom/facebook/drawee/controller/AbstractDraweeControllerBuilder;", "Lcom/facebook/imagepipeline/request/ImageRequest;", "callerContext", "", "<init>", "(Lcom/facebook/drawee/controller/AbstractDraweeControllerBuilder;Ljava/lang/Object;)V", "uri", "Landroid/net/Uri;", "headers", "Lcom/facebook/react/bridge/ReadableMap;", "width", "", "resizeMode", "", "height", "tintColor", "", "setSource", "", "sources", "Lcom/facebook/react/bridge/ReadableArray;", "setHeaders", "newHeaders", "setTintColor", "newTintColor", "setWidth", "newWidth", "Lcom/facebook/react/bridge/Dynamic;", "setHeight", "newHeight", "setResizeMode", "newResizeMode", "getUri", "getHeaders", "isVirtual", "", "buildInlineImageSpan", "Lcom/facebook/react/views/text/internal/span/TextInlineImageSpan;", "getDraweeControllerBuilder", "getCallerContext", "Companion", "ReactAndroid_debug"})
public final class FrescoBasedReactTextInlineImageShadowNode
extends ReactTextInlineImageShadowNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AbstractDraweeControllerBuilder<?, ImageRequest, ?, ?> draweeControllerBuilder;
    @Nullable
    private final Object callerContext;
    @Nullable
    private Uri uri;
    @Nullable
    private ReadableMap headers;
    private float width;
    @Nullable
    private String resizeMode;
    private float height;
    private int tintColor;

    public FrescoBasedReactTextInlineImageShadowNode(@NotNull AbstractDraweeControllerBuilder<?, ImageRequest, ?, ?> draweeControllerBuilder, @Nullable Object callerContext) {
        Intrinsics.checkNotNullParameter(draweeControllerBuilder, (String)"draweeControllerBuilder");
        this.draweeControllerBuilder = draweeControllerBuilder;
        this.callerContext = callerContext;
        this.width = Float.NaN;
        this.height = Float.NaN;
    }

    @ReactProp(name="src")
    public final void setSource(@Nullable ReadableArray sources) {
        String string2;
        if (sources == null || sources.size() == 0 || sources.getType(0) != ReadableType.Map) {
            string2 = null;
        } else {
            ReadableMap readableMap = sources.getMap(0);
            if (readableMap == null) {
                String string3 = "Required value was null.";
                throw new IllegalStateException(string3.toString());
            }
            string2 = readableMap.getString("uri");
        }
        String source2 = string2;
        Uri tempUri = null;
        if (source2 != null) {
            try {
                tempUri = Uri.parse(source2);
                if (tempUri.getScheme() == null) {
                    tempUri = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tempUri == null) {
                ThemedReactContext themedReactContext = this.getThemedContext();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)themedReactContext), (String)"getThemedContext(...)");
                tempUri = Companion.getResourceDrawableUri((Context)themedReactContext, source2);
            }
        }
        if (!Intrinsics.areEqual(tempUri, (Object)this.uri)) {
            this.markUpdated();
        }
        this.uri = tempUri;
    }

    @ReactProp(name="headers")
    public final void setHeaders(@Nullable ReadableMap newHeaders) {
        this.headers = newHeaders;
    }

    @ReactProp(name="tintColor", customType="Color")
    public final void setTintColor(int newTintColor) {
        this.tintColor = newTintColor;
    }

    @Override
    public void setWidth(@NotNull Dynamic newWidth) {
        Intrinsics.checkNotNullParameter((Object)newWidth, (String)"newWidth");
        if (newWidth.getType() == ReadableType.Number) {
            this.width = (float)newWidth.asDouble();
        } else {
            FLog.w((String)"ReactNative", (String)"Inline images must not have percentage based width");
            this.width = Float.NaN;
        }
    }

    @Override
    public void setHeight(@NotNull Dynamic newHeight) {
        Intrinsics.checkNotNullParameter((Object)newHeight, (String)"newHeight");
        if (newHeight.getType() == ReadableType.Number) {
            this.height = (float)newHeight.asDouble();
        } else {
            FLog.w((String)"ReactNative", (String)"Inline images must not have percentage based height");
            this.height = Float.NaN;
        }
    }

    @ReactProp(name="resizeMode")
    public final void setResizeMode(@Nullable String newResizeMode) {
        this.resizeMode = newResizeMode;
    }

    @Nullable
    public final Uri getUri() {
        return this.uri;
    }

    @Nullable
    public final ReadableMap getHeaders() {
        return this.headers;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    @NotNull
    public TextInlineImageSpan buildInlineImageSpan() {
        Resources resources = this.getThemedContext().getResources();
        int finalWidth = (int)Math.ceil(this.width);
        int finalHeight = (int)Math.ceil(this.height);
        Intrinsics.checkNotNull((Object)resources);
        return new FrescoBasedReactTextInlineImageSpan(resources, finalHeight, finalWidth, this.tintColor, this.getUri(), this.getHeaders(), this.getDraweeControllerBuilder(), this.getCallerContext(), this.resizeMode);
    }

    @NotNull
    public final AbstractDraweeControllerBuilder<?, ImageRequest, ?, ?> getDraweeControllerBuilder() {
        return this.draweeControllerBuilder;
    }

    @Nullable
    public final Object getCallerContext() {
        return this.callerContext;
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("FrescoBasedReactTextInlineImageShadowNode", LegacyArchitectureLogLevel.ERROR);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lcom/facebook/react/views/text/frescosupport/FrescoBasedReactTextInlineImageShadowNode$Companion;", "", "<init>", "()V", "getResourceDrawableUri", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "name", "", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Uri getResourceDrawableUri(@NotNull Context context, @Nullable String name) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (name == null || ((CharSequence)name).length() == 0) {
                return null;
            }
            String string2 = name;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String formattedName = StringsKt.replace$default((String)string3, (String)"-", (String)"_", (boolean)false, (int)4, null);
            int resId = context.getResources().getIdentifier(formattedName, "drawable", context.getPackageName());
            return new Uri.Builder().scheme("res").path(String.valueOf(resId)).build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

