/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import com.facebook.common.logging.FLog;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.views.text.TextTransform;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000J\b\u0010*\u001a\u00020+H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u0012\u0010\u0019\u001a\u00020\u001a8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\r\"\u0004\b\u001f\u0010\u000fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\rR\u0011\u0010&\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\rR\u0011\u0010(\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\r\u00a8\u0006-"}, d2={"Lcom/facebook/react/views/text/TextAttributes;", "", "<init>", "()V", "allowFontScaling", "", "getAllowFontScaling", "()Z", "setAllowFontScaling", "(Z)V", "fontSize", "", "getFontSize", "()F", "setFontSize", "(F)V", "lineHeight", "getLineHeight", "setLineHeight", "letterSpacing", "getLetterSpacing", "setLetterSpacing", "heightOfTallestInlineViewOrImage", "getHeightOfTallestInlineViewOrImage", "setHeightOfTallestInlineViewOrImage", "textTransform", "Lcom/facebook/react/views/text/TextTransform;", "applyChild", "child", "maxFontSizeMultiplier", "getMaxFontSizeMultiplier", "setMaxFontSizeMultiplier", "effectiveFontSize", "", "getEffectiveFontSize", "()I", "effectiveLineHeight", "getEffectiveLineHeight", "effectiveLetterSpacing", "getEffectiveLetterSpacing", "effectiveMaxFontSizeMultiplier", "getEffectiveMaxFontSizeMultiplier", "toString", "", "Companion", "ReactAndroid_debug"})
public final class TextAttributes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean allowFontScaling = true;
    private float fontSize = Float.NaN;
    private float lineHeight = Float.NaN;
    private float letterSpacing = Float.NaN;
    private float heightOfTallestInlineViewOrImage = Float.NaN;
    @JvmField
    @NotNull
    public TextTransform textTransform = TextTransform.UNSET;
    private float maxFontSizeMultiplier = Float.NaN;
    public static final float DEFAULT_MAX_FONT_SIZE_MULTIPLIER = 0.0f;

    public final boolean getAllowFontScaling() {
        return this.allowFontScaling;
    }

    public final void setAllowFontScaling(boolean bl) {
        this.allowFontScaling = bl;
    }

    public final float getFontSize() {
        return this.fontSize;
    }

    public final void setFontSize(float f) {
        this.fontSize = f;
    }

    public final float getLineHeight() {
        return this.lineHeight;
    }

    public final void setLineHeight(float f) {
        this.lineHeight = f;
    }

    public final float getLetterSpacing() {
        return this.letterSpacing;
    }

    public final void setLetterSpacing(float f) {
        this.letterSpacing = f;
    }

    public final float getHeightOfTallestInlineViewOrImage() {
        return this.heightOfTallestInlineViewOrImage;
    }

    public final void setHeightOfTallestInlineViewOrImage(float f) {
        this.heightOfTallestInlineViewOrImage = f;
    }

    @NotNull
    public final TextAttributes applyChild(@NotNull TextAttributes child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        TextAttributes result = new TextAttributes();
        result.allowFontScaling = this.allowFontScaling;
        result.fontSize = !Float.isNaN(child.fontSize) ? child.fontSize : this.fontSize;
        result.lineHeight = !Float.isNaN(child.lineHeight) ? child.lineHeight : this.lineHeight;
        result.letterSpacing = !Float.isNaN(child.letterSpacing) ? child.letterSpacing : this.letterSpacing;
        result.setMaxFontSizeMultiplier(!Float.isNaN(child.maxFontSizeMultiplier) ? child.maxFontSizeMultiplier : this.maxFontSizeMultiplier);
        result.heightOfTallestInlineViewOrImage = !Float.isNaN(child.heightOfTallestInlineViewOrImage) ? child.heightOfTallestInlineViewOrImage : this.heightOfTallestInlineViewOrImage;
        result.textTransform = child.textTransform != TextTransform.UNSET ? child.textTransform : this.textTransform;
        return result;
    }

    public final float getMaxFontSizeMultiplier() {
        return this.maxFontSizeMultiplier;
    }

    public final void setMaxFontSizeMultiplier(float maxFontSizeMultiplier) {
        if (!(maxFontSizeMultiplier == 0.0f) && maxFontSizeMultiplier < 1.0f && !Float.isNaN(maxFontSizeMultiplier)) {
            FLog.w((String)"ReactNative", (String)"maxFontSizeMultiplier must be NaN, 0, or >= 1");
            this.maxFontSizeMultiplier = Float.NaN;
            return;
        }
        this.maxFontSizeMultiplier = maxFontSizeMultiplier;
    }

    public final int getEffectiveFontSize() {
        float fontSize = !Float.isNaN(this.fontSize) ? this.fontSize : 14.0f;
        return this.allowFontScaling ? (int)Math.ceil(PixelUtil.toPixelFromSP(fontSize, this.getEffectiveMaxFontSizeMultiplier())) : (int)Math.ceil(PixelUtil.toPixelFromDIP(fontSize));
    }

    public final float getEffectiveLineHeight() {
        if (Float.isNaN(this.lineHeight)) {
            return Float.NaN;
        }
        float lineHeight = this.allowFontScaling ? PixelUtil.toPixelFromSP(this.lineHeight, this.getEffectiveMaxFontSizeMultiplier()) : PixelUtil.toPixelFromDIP(this.lineHeight);
        boolean useInlineViewHeight = !Float.isNaN(this.heightOfTallestInlineViewOrImage) && this.heightOfTallestInlineViewOrImage > lineHeight;
        return useInlineViewHeight ? this.heightOfTallestInlineViewOrImage : lineHeight;
    }

    public final float getEffectiveLetterSpacing() {
        if (Float.isNaN(this.letterSpacing)) {
            return Float.NaN;
        }
        float letterSpacingPixels = this.allowFontScaling ? PixelUtil.toPixelFromSP(this.letterSpacing, this.getEffectiveMaxFontSizeMultiplier()) : PixelUtil.toPixelFromDIP(this.letterSpacing);
        return letterSpacingPixels / (float)this.getEffectiveFontSize();
    }

    public final float getEffectiveMaxFontSizeMultiplier() {
        return !Float.isNaN(this.maxFontSizeMultiplier) ? this.maxFontSizeMultiplier : 0.0f;
    }

    @NotNull
    public String toString() {
        return StringsKt.trimIndent((String)("\n    TextAttributes {\n      getAllowFontScaling(): " + this.allowFontScaling + "\n      getFontSize(): " + this.fontSize + "\n      getEffectiveFontSize(): " + this.getEffectiveFontSize() + "\n      getHeightOfTallestInlineViewOrImage(): " + this.heightOfTallestInlineViewOrImage + "\n      getLetterSpacing(): " + this.letterSpacing + "\n      getEffectiveLetterSpacing(): " + this.getEffectiveLetterSpacing() + "\n      getLineHeight(): " + this.lineHeight + "\n      getEffectiveLineHeight(): " + this.getEffectiveLineHeight() + "\n      getTextTransform(): " + this.textTransform + "\n      getMaxFontSizeMultiplier(): " + this.maxFontSizeMultiplier + "\n      getEffectiveMaxFontSizeMultiplier(): " + this.getEffectiveMaxFontSizeMultiplier() + "\n    }\n  "));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/views/text/TextAttributes$Companion;", "", "<init>", "()V", "DEFAULT_MAX_FONT_SIZE_MULTIPLIER", "", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

