/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.os.Build;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.Spannable;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextPaint;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.NativeViewHierarchyOptimizer;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.views.text.FontMetricsUtil;
import com.facebook.react.views.text.ReactBaseTextShadowNode;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.ReactTextViewManagerCallback;
import com.facebook.react.views.text.internal.span.ReactAbsoluteSizeSpan;
import com.facebook.react.views.text.internal.span.TextInlineViewPlaceholderSpan;
import com.facebook.yoga.YogaBaselineFunction;
import com.facebook.yoga.YogaConstants;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u0015\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\tH\u0016J\b\u0010\u001f\u001a\u00020\tH\u0016J\b\u0010 \u001a\u00020\u000fH\u0016J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010%\u001a\u0010\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010'\u0018\u00010&H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006)"}, d2={"Lcom/facebook/react/views/text/ReactTextShadowNode;", "Lcom/facebook/react/views/text/ReactBaseTextShadowNode;", "reactTextViewManagerCallback", "Lcom/facebook/react/views/text/ReactTextViewManagerCallback;", "<init>", "(Lcom/facebook/react/views/text/ReactTextViewManagerCallback;)V", "preparedSpannableText", "Landroid/text/Spannable;", "shouldNotifyOnTextLayout", "", "textMeasureFunction", "Lcom/facebook/yoga/YogaMeasureFunction;", "mTextBaselineFunction", "Lcom/facebook/yoga/YogaBaselineFunction;", "initMeasureFunction", "", "measureSpannedText", "Landroid/text/Layout;", "text", "width", "", "widthMode", "Lcom/facebook/yoga/YogaMeasureMode;", "textAlign", "", "getTextAlign", "()I", "onBeforeLayout", "nativeViewHierarchyOptimizer", "Lcom/facebook/react/uimanager/NativeViewHierarchyOptimizer;", "isVirtualAnchor", "hoistNativeChildren", "markUpdated", "onCollectExtraUpdates", "uiViewOperationQueue", "Lcom/facebook/react/uimanager/UIViewOperationQueue;", "setShouldNotifyOnTextLayout", "calculateLayoutOnChildren", "", "Lcom/facebook/react/uimanager/ReactShadowNode;", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nReactTextShadowNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactTextShadowNode.kt\ncom/facebook/react/views/text/ReactTextShadowNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,350:1\n1#2:351\n*E\n"})
public final class ReactTextShadowNode
extends ReactBaseTextShadowNode {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private Spannable preparedSpannableText;
    private boolean shouldNotifyOnTextLayout;
    @NotNull
    private final YogaMeasureFunction textMeasureFunction;
    @NotNull
    private final YogaBaselineFunction mTextBaselineFunction;
    @NotNull
    private static final TextPaint textPaintInstance = new TextPaint(1);

    @JvmOverloads
    public ReactTextShadowNode(@Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        super(reactTextViewManagerCallback);
        this.textMeasureFunction = (arg_0, arg_1, arg_2, arg_3, arg_4) -> ReactTextShadowNode.textMeasureFunction$lambda$2(this, arg_0, arg_1, arg_2, arg_3, arg_4);
        this.mTextBaselineFunction = (arg_0, arg_1, arg_2) -> ReactTextShadowNode.mTextBaselineFunction$lambda$4(this, arg_0, arg_1, arg_2);
        this.initMeasureFunction();
    }

    public /* synthetic */ ReactTextShadowNode(ReactTextViewManagerCallback reactTextViewManagerCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            reactTextViewManagerCallback = null;
        }
        this(reactTextViewManagerCallback);
    }

    private final void initMeasureFunction() {
        if (!this.isVirtual()) {
            this.setMeasureFunction(this.textMeasureFunction);
            this.setBaselineFunction(this.mTextBaselineFunction);
        }
    }

    private final Layout measureSpannedText(Spannable text, float width, YogaMeasureMode widthMode) {
        Layout.Alignment alignment;
        float width2 = width;
        TextPaint textPaint = textPaintInstance;
        textPaint.setTextSize((float)this.mTextAttributes.getEffectiveFontSize());
        Layout layout2 = null;
        BoringLayout.Metrics boring = BoringLayout.isBoring((CharSequence)((CharSequence)text), (TextPaint)textPaint);
        float desiredWidth = boring == null ? Layout.getDesiredWidth((CharSequence)((CharSequence)text), (TextPaint)textPaint) : Float.NaN;
        boolean unconstrainedWidth = widthMode == YogaMeasureMode.UNDEFINED || width2 < 0.0f;
        switch (this.getTextAlign()) {
            case 3: {
                Layout.Alignment alignment2 = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case 5: {
                Layout.Alignment alignment2 = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case 1: {
                Layout.Alignment alignment2 = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            default: {
                Layout.Alignment alignment2 = alignment = Layout.Alignment.ALIGN_NORMAL;
            }
        }
        if (boring == null && (unconstrainedWidth || !YogaConstants.isUndefined(desiredWidth) && desiredWidth <= width2)) {
            int hintWidth = (int)Math.ceil(desiredWidth);
            StaticLayout.Builder builder = StaticLayout.Builder.obtain((CharSequence)((CharSequence)text), (int)0, (int)text.length(), (TextPaint)textPaint, (int)hintWidth).setAlignment(alignment).setLineSpacing(0.0f, 1.0f).setIncludePad(this.mIncludeFontPadding).setBreakStrategy(this.mTextBreakStrategy).setHyphenationFrequency(this.mHyphenationFrequency);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setHyphenationFrequency(...)");
            StaticLayout.Builder builder2 = builder;
            if (Build.VERSION.SDK_INT >= 26) {
                builder2.setJustificationMode(this.mJustificationMode);
            }
            if (Build.VERSION.SDK_INT >= 28) {
                builder2.setUseLineSpacingFromFallbacks(true);
            }
            StaticLayout staticLayout = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)staticLayout, (String)"build(...)");
            layout2 = (Layout)staticLayout;
        } else if (boring != null && (unconstrainedWidth || (float)boring.width <= width2)) {
            BoringLayout boringLayout = BoringLayout.make((CharSequence)((CharSequence)text), (TextPaint)textPaint, (int)((int)Math.max((double)boring.width, 0.0)), (Layout.Alignment)alignment, (float)1.0f, (float)0.0f, (BoringLayout.Metrics)boring, (boolean)this.mIncludeFontPadding);
            Intrinsics.checkNotNullExpressionValue((Object)boringLayout, (String)"make(...)");
            layout2 = (Layout)boringLayout;
        } else {
            if (Build.VERSION.SDK_INT > 29) {
                width2 = (float)Math.ceil(width2);
            }
            StaticLayout.Builder builder = StaticLayout.Builder.obtain((CharSequence)((CharSequence)text), (int)0, (int)text.length(), (TextPaint)textPaint, (int)((int)width2)).setAlignment(alignment).setLineSpacing(0.0f, 1.0f).setIncludePad(this.mIncludeFontPadding).setBreakStrategy(this.mTextBreakStrategy).setHyphenationFrequency(this.mHyphenationFrequency);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setHyphenationFrequency(...)");
            StaticLayout.Builder builder3 = builder;
            if (Build.VERSION.SDK_INT >= 26) {
                builder3.setJustificationMode(this.mJustificationMode);
            }
            if (Build.VERSION.SDK_INT >= 28) {
                builder3.setUseLineSpacingFromFallbacks(true);
            }
            StaticLayout staticLayout = builder3.build();
            Intrinsics.checkNotNullExpressionValue((Object)staticLayout, (String)"build(...)");
            layout2 = (Layout)staticLayout;
        }
        return layout2;
    }

    private final int getTextAlign() {
        int textAlign = this.mTextAlign;
        if (this.getLayoutDirection() == YogaDirection.RTL) {
            switch (textAlign) {
                case 5: {
                    textAlign = 3;
                    break;
                }
                case 3: {
                    textAlign = 5;
                }
            }
        }
        return textAlign;
    }

    @Override
    public void onBeforeLayout(@NotNull NativeViewHierarchyOptimizer nativeViewHierarchyOptimizer) {
        Intrinsics.checkNotNullParameter((Object)nativeViewHierarchyOptimizer, (String)"nativeViewHierarchyOptimizer");
        this.preparedSpannableText = this.spannedFromShadowNode(this, null, true, nativeViewHierarchyOptimizer);
        this.markUpdated();
    }

    @Override
    public boolean isVirtualAnchor() {
        return false;
    }

    @Override
    public boolean hoistNativeChildren() {
        return true;
    }

    @Override
    public void markUpdated() {
        super.markUpdated();
        super.dirty();
    }

    @Override
    public void onCollectExtraUpdates(@NotNull UIViewOperationQueue uiViewOperationQueue) {
        Intrinsics.checkNotNullParameter((Object)uiViewOperationQueue, (String)"uiViewOperationQueue");
        super.onCollectExtraUpdates(uiViewOperationQueue);
        Spannable spannable = this.preparedSpannableText;
        if (spannable == null) {
            return;
        }
        Spannable text = spannable;
        ReactTextUpdate reactTextUpdate = new ReactTextUpdate(text, -1, this.mContainsImages, this.getPadding(4), this.getPadding(1), this.getPadding(5), this.getPadding(3), this.getTextAlign(), this.mTextBreakStrategy, this.mJustificationMode);
        uiViewOperationQueue.enqueueUpdateExtraData(this.getReactTag(), reactTextUpdate);
    }

    @ReactProp(name="onTextLayout")
    public final void setShouldNotifyOnTextLayout(boolean shouldNotifyOnTextLayout) {
        this.shouldNotifyOnTextLayout = shouldNotifyOnTextLayout;
    }

    @Override
    @Nullable
    public Iterable<ReactShadowNode<?>> calculateLayoutOnChildren() {
        Map map = this.mInlineViews;
        if (map == null || map.isEmpty()) {
            return null;
        }
        Spannable spannable = this.preparedSpannableText;
        if (spannable == null) {
            boolean $i$a$-checkNotNull-ReactTextShadowNode$calculateLayoutOnChildren$text$22 = false;
            String $i$a$-checkNotNull-ReactTextShadowNode$calculateLayoutOnChildren$text$22 = "Spannable element has not been prepared in onBeforeLayout";
            throw new IllegalStateException($i$a$-checkNotNull-ReactTextShadowNode$calculateLayoutOnChildren$text$22.toString());
        }
        Spanned text = (Spanned)spannable;
        Object[] placeholders = (TextInlineViewPlaceholderSpan[])text.getSpans(0, text.length(), TextInlineViewPlaceholderSpan.class);
        List shadowNodes = new ArrayList();
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])placeholders);
        while (iterator2.hasNext()) {
            TextInlineViewPlaceholderSpan placeholder = (TextInlineViewPlaceholderSpan)iterator2.next();
            Map map2 = this.mInlineViews;
            ReactShadowNode child = map2 != null ? (ReactShadowNode)map2.get(placeholder.getReactTag()) : null;
            if (child == null) {
                boolean bl = false;
                String string2 = "Child is null";
                throw new IllegalStateException(string2.toString());
            }
            child.calculateLayout();
            shadowNodes.add(child);
        }
        return shadowNodes;
    }

    @JvmOverloads
    public ReactTextShadowNode() {
        this(null, 1, null);
    }

    private static final long textMeasureFunction$lambda$2(ReactTextShadowNode this$0, YogaNode yogaNode, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
        Object[] sizeSpans;
        Spannable spannable = this$0.preparedSpannableText;
        if (spannable == null) {
            boolean $i$a$-requireNotNull-ReactTextShadowNode$textMeasureFunction$1$text$22 = false;
            String $i$a$-requireNotNull-ReactTextShadowNode$textMeasureFunction$1$text$22 = "Spannable element has not been prepared in onBeforeLayout";
            throw new IllegalArgumentException($i$a$-requireNotNull-ReactTextShadowNode$textMeasureFunction$1$text$22.toString());
        }
        Spannable text = spannable;
        Intrinsics.checkNotNull((Object)((Object)widthMode));
        Layout layout2 = this$0.measureSpannedText(text, width, widthMode);
        if (this$0.mAdjustsFontSizeToFit) {
            int initialFontSize = this$0.mTextAttributes.getEffectiveFontSize();
            int currentFontSize = this$0.mTextAttributes.getEffectiveFontSize();
            int minimumFontSize = (int)Math.max(this$0.mMinimumFontScale * (float)initialFontSize, PixelUtil.toPixelFromDIP(4.0f));
            while (currentFontSize > minimumFontSize && (this$0.mNumberOfLines != -1 && layout2.getLineCount() > this$0.mNumberOfLines || heightMode != YogaMeasureMode.UNDEFINED && (float)layout2.getHeight() > height)) {
                float ratio = (float)(currentFontSize -= Math.max(1, (int)PixelUtil.toPixelFromDIP(1.0f))) / (float)initialFontSize;
                sizeSpans = (ReactAbsoluteSizeSpan[])text.getSpans(0, text.length(), ReactAbsoluteSizeSpan.class);
                Iterator iterator2 = ArrayIteratorKt.iterator((Object[])sizeSpans);
                while (iterator2.hasNext()) {
                    ReactAbsoluteSizeSpan span = (ReactAbsoluteSizeSpan)iterator2.next();
                    text.setSpan((Object)new ReactAbsoluteSizeSpan((int)Math.max((double)((float)span.getSize() * ratio), (double)minimumFontSize)), text.getSpanStart((Object)span), text.getSpanEnd((Object)span), text.getSpanFlags((Object)span));
                    text.removeSpan((Object)span);
                }
                layout2 = this$0.measureSpannedText(text, width, widthMode);
            }
        }
        if (this$0.shouldNotifyOnTextLayout) {
            ThemedReactContext themedReactContext = this$0.getThemedContext();
            CharSequence charSequence = (CharSequence)text;
            Intrinsics.checkNotNull((Object)((Object)themedReactContext));
            WritableArray lines = FontMetricsUtil.getFontMetrics(charSequence, layout2, (Context)themedReactContext);
            Object[] $this$textMeasureFunction_u24lambda_u242_u24lambda_u241 = sizeSpans = Arguments.createMap();
            boolean bl = false;
            $this$textMeasureFunction_u24lambda_u242_u24lambda_u241.putArray("lines", lines);
            Intrinsics.checkNotNullExpressionValue((Object)sizeSpans, (String)"apply(...)");
            Object[] event = sizeSpans;
            if (themedReactContext.hasActiveReactInstance()) {
                themedReactContext.getJSModule(RCTEventEmitter.class).receiveEvent(this$0.getReactTag(), "topTextLayout", (WritableMap)event);
            } else {
                ReactSoftExceptionLogger.logSoftException("ReactTextShadowNode", new ReactNoCrashSoftException("Cannot get RCTEventEmitter, no CatalystInstance"));
            }
        }
        int lineCount = this$0.mNumberOfLines == -1 ? layout2.getLineCount() : (int)Math.min((double)this$0.mNumberOfLines, (double)layout2.getLineCount());
        float layoutWidth = 0.0f;
        if (widthMode == YogaMeasureMode.EXACTLY) {
            layoutWidth = width;
        } else {
            for (int lineIndex = 0; lineIndex < lineCount; ++lineIndex) {
                float lineWidth;
                boolean endsWithNewLine = text.length() > 0 && text.charAt(layout2.getLineEnd(lineIndex) - 1) == '\n';
                float f = lineWidth = endsWithNewLine ? layout2.getLineMax(lineIndex) : layout2.getLineWidth(lineIndex);
                if (!(lineWidth > layoutWidth)) continue;
                layoutWidth = lineWidth;
            }
            if (widthMode == YogaMeasureMode.AT_MOST && layoutWidth > width) {
                layoutWidth = width;
            }
        }
        if (Build.VERSION.SDK_INT > 29) {
            layoutWidth = (float)Math.ceil(layoutWidth);
        }
        float layoutHeight = height;
        if (heightMode != YogaMeasureMode.EXACTLY) {
            layoutHeight = layout2.getLineBottom(lineCount - 1);
            if (heightMode == YogaMeasureMode.AT_MOST && layoutHeight > height) {
                layoutHeight = height;
            }
        }
        return YogaMeasureOutput.make(layoutWidth, layoutHeight);
    }

    private static final float mTextBaselineFunction$lambda$4(ReactTextShadowNode this$0, YogaNode node, float width, float height) {
        Spannable spannable = this$0.preparedSpannableText;
        if (spannable == null) {
            boolean bl = false;
            String string2 = "Spannable element has not been prepared in onBeforeLayout";
            throw new IllegalStateException(string2.toString());
        }
        Spannable text = spannable;
        Layout layout2 = this$0.measureSpannedText(text, width, YogaMeasureMode.EXACTLY);
        return layout2.getLineBaseline(layout2.getLineCount() - 1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/views/text/ReactTextShadowNode$Companion;", "", "<init>", "()V", "textPaintInstance", "Landroid/text/TextPaint;", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

