/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.util.SparseArray;
import android.util.SparseBooleanArray;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.ReactShadowNode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0006J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0006J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0010R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lcom/facebook/react/uimanager/ShadowNodeRegistry;", "", "<init>", "()V", "tagsToCSSNodes", "Landroid/util/SparseArray;", "Lcom/facebook/react/uimanager/ReactShadowNode;", "rootTags", "Landroid/util/SparseBooleanArray;", "threadAsserter", "Lcom/facebook/react/uimanager/ShadowNodeRegistry$SingleThreadAsserter;", "addRootNode", "", "node", "removeRootNode", "tag", "", "addNode", "removeNode", "getNode", "isRootNode", "", "rootNodeCount", "getRootNodeCount", "()I", "getRootTag", "index", "Companion", "SingleThreadAsserter", "ReactAndroid_debug"})
public final class ShadowNodeRegistry {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final SparseArray<ReactShadowNode<?>> tagsToCSSNodes = new SparseArray();
    @NotNull
    private final SparseBooleanArray rootTags = new SparseBooleanArray();
    @NotNull
    private final SingleThreadAsserter threadAsserter = new SingleThreadAsserter();

    public final void addRootNode(@NotNull ReactShadowNode<?> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        this.threadAsserter.assertNow();
        int tag = node.getReactTag();
        this.tagsToCSSNodes.put(tag, node);
        this.rootTags.put(tag, true);
    }

    public final void removeRootNode(int tag) {
        this.threadAsserter.assertNow();
        if (tag == -1) {
            return;
        }
        if (!this.rootTags.get(tag)) {
            throw new IllegalViewOperationException("View with tag " + tag + " is not registered as a root view");
        }
        this.tagsToCSSNodes.remove(tag);
        this.rootTags.delete(tag);
    }

    public final void addNode(@NotNull ReactShadowNode<?> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        this.threadAsserter.assertNow();
        this.tagsToCSSNodes.put(node.getReactTag(), node);
    }

    public final void removeNode(int tag) {
        this.threadAsserter.assertNow();
        if (this.rootTags.get(tag)) {
            throw new IllegalViewOperationException("Trying to remove root node " + tag + " without using removeRootNode!");
        }
        this.tagsToCSSNodes.remove(tag);
    }

    @Nullable
    public final ReactShadowNode<?> getNode(int tag) {
        this.threadAsserter.assertNow();
        return (ReactShadowNode)this.tagsToCSSNodes.get(tag);
    }

    public final boolean isRootNode(int tag) {
        this.threadAsserter.assertNow();
        return this.rootTags.get(tag);
    }

    public final int getRootNodeCount() {
        this.threadAsserter.assertNow();
        return this.rootTags.size();
    }

    public final int getRootTag(int index) {
        this.threadAsserter.assertNow();
        return this.rootTags.keyAt(index);
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("ShadowNodeRegistry", LegacyArchitectureLogLevel.ERROR);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/facebook/react/uimanager/ShadowNodeRegistry$Companion;", "", "<init>", "()V", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/react/uimanager/ShadowNodeRegistry$SingleThreadAsserter;", "", "<init>", "(Lcom/facebook/react/uimanager/ShadowNodeRegistry;)V", "thread", "Ljava/lang/Thread;", "assertNow", "", "ReactAndroid_debug"})
    public final class SingleThreadAsserter {
        @Nullable
        private Thread thread;

        public final void assertNow() {
            Thread currentThread = Thread.currentThread();
            if (this.thread == null) {
                this.thread = currentThread;
            }
            Assertions.assertCondition((boolean)Intrinsics.areEqual((Object)this.thread, (Object)currentThread));
        }
    }
}

