/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.util.Base64;
import com.facebook.common.logging.FLog;
import com.facebook.fbreact.specs.NativeNetworkingAndroidSpec;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.network.OkHttpCallUtil;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.network.CookieJarContainer;
import com.facebook.react.modules.network.ForwardingCookieHandler;
import com.facebook.react.modules.network.HeaderUtil;
import com.facebook.react.modules.network.NetworkInterceptorCreator;
import com.facebook.react.modules.network.OkHttpClientProvider;
import com.facebook.react.modules.network.ProgressListener;
import com.facebook.react.modules.network.ProgressResponseBody;
import com.facebook.react.modules.network.ProgressiveStringDecoder;
import com.facebook.react.modules.network.RequestBodyUtil;
import com.facebook.react.modules.network.ResponseUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.JavaNetCookieJar;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.-DeprecatedUpgrade;
import okio.ByteString;
import okio.GzipSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="Networking")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 `2\u00020\u0001:\u0005\\]^_`B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fB#\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\u000fB!\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\u0010B\u001b\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u000b\u0010\u0011J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\u0015\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b'J\u0015\u0010(\u001a\u00020#2\u0006\u0010&\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b)J\u0015\u0010*\u001a\u00020#2\u0006\u0010&\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b+J\u0015\u0010,\u001a\u00020#2\u0006\u0010&\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b-J\u0015\u0010.\u001a\u00020#2\u0006\u0010&\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b/J\u0015\u00100\u001a\u00020#2\u0006\u0010&\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b1JT\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u0001082\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020!2\u0006\u0010=\u001a\u0002062\u0006\u0010>\u001a\u00020!H\u0016JT\u0010?\u001a\u00020#2\u0006\u00103\u001a\u00020\u00052\b\u00104\u001a\u0004\u0018\u00010\u00052\u0006\u0010@\u001a\u00020\u00182\b\u00107\u001a\u0004\u0018\u0001082\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020!2\u0006\u0010A\u001a\u00020\u00182\u0006\u0010>\u001a\u00020!J\u001c\u0010B\u001a\u0004\u0018\u00010C2\b\u0010D\u001a\u0004\u0018\u00010C2\u0006\u0010@\u001a\u00020\u0018H\u0002J\u0018\u0010E\u001a\u00020#2\u0006\u0010@\u001a\u00020\u00182\u0006\u0010F\u001a\u00020GH\u0002J\u0010\u0010H\u001a\u00020#2\u0006\u0010@\u001a\u00020\u0018H\u0002J\u0010\u0010I\u001a\u00020#2\u0006\u0010@\u001a\u00020\u0018H\u0002J\b\u0010J\u001a\u00020#H\u0002J\u0010\u0010K\u001a\u00020#2\u0006\u00105\u001a\u000206H\u0016J\u0010\u0010L\u001a\u00020#2\u0006\u0010@\u001a\u00020\u0018H\u0002J\u0010\u0010M\u001a\u00020#2\u0006\u0010N\u001a\u00020OH\u0017J\u0012\u0010P\u001a\u00020#2\b\u0010Q\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010R\u001a\u00020#2\u0006\u0010S\u001a\u000206H\u0016J\"\u0010T\u001a\u0004\u0018\u00010U2\u0006\u0010V\u001a\u0002082\u0006\u0010W\u001a\u00020\u00052\u0006\u0010@\u001a\u00020\u0018H\u0002J\u001e\u0010X\u001a\u0004\u0018\u00010Y2\b\u0010Z\u001a\u0004\u0018\u0001082\b\u0010[\u001a\u0004\u0018\u00010:H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lcom/facebook/react/modules/network/NetworkingModule;", "Lcom/facebook/fbreact/specs/NativeNetworkingAndroidSpec;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "defaultUserAgent", "", "client", "Lokhttp3/OkHttpClient;", "networkInterceptorCreators", "", "Lcom/facebook/react/modules/network/NetworkInterceptorCreator;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;Ljava/lang/String;Lokhttp3/OkHttpClient;Ljava/util/List;)V", "context", "(Lcom/facebook/react/bridge/ReactApplicationContext;Ljava/lang/String;Lokhttp3/OkHttpClient;)V", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "(Lcom/facebook/react/bridge/ReactApplicationContext;Ljava/util/List;)V", "(Lcom/facebook/react/bridge/ReactApplicationContext;Ljava/lang/String;)V", "cookieHandler", "Lcom/facebook/react/modules/network/ForwardingCookieHandler;", "cookieJarContainer", "Lcom/facebook/react/modules/network/CookieJarContainer;", "requestIds", "", "", "requestBodyHandlers", "", "Lcom/facebook/react/modules/network/NetworkingModule$RequestBodyHandler;", "uriHandlers", "Lcom/facebook/react/modules/network/NetworkingModule$UriHandler;", "responseHandlers", "Lcom/facebook/react/modules/network/NetworkingModule$ResponseHandler;", "shuttingDown", "", "initialize", "", "invalidate", "addUriHandler", "handler", "addUriHandler$ReactAndroid_debug", "addRequestBodyHandler", "addRequestBodyHandler$ReactAndroid_debug", "addResponseHandler", "addResponseHandler$ReactAndroid_debug", "removeUriHandler", "removeUriHandler$ReactAndroid_debug", "removeRequestBodyHandler", "removeRequestBodyHandler$ReactAndroid_debug", "removeResponseHandler", "removeResponseHandler$ReactAndroid_debug", "sendRequest", "method", "url", "requestIdAsDouble", "", "headers", "Lcom/facebook/react/bridge/ReadableArray;", "data", "Lcom/facebook/react/bridge/ReadableMap;", "responseType", "useIncrementalUpdates", "timeoutAsDouble", "withCredentials", "sendRequestInternal", "requestId", "timeout", "wrapRequestBodyWithProgressEmitter", "Lokhttp3/RequestBody;", "requestBody", "readWithProgress", "responseBody", "Lokhttp3/ResponseBody;", "addRequest", "removeRequest", "cancelAllRequests", "abortRequest", "cancelRequest", "clearCookies", "callback", "Lcom/facebook/react/bridge/Callback;", "addListener", "eventName", "removeListeners", "count", "constructMultipartBody", "Lokhttp3/MultipartBody$Builder;", "body", "contentType", "extractHeaders", "Lokhttp3/Headers;", "headersArray", "requestData", "UriHandler", "RequestBodyHandler", "ResponseHandler", "CustomClientBuilder", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nNetworkingModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkingModule.kt\ncom/facebook/react/modules/network/NetworkingModule\n+ 2 OkHttpClient.kt\nokhttp3/OkHttpClient$Builder\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,847:1\n578#2:848\n1#3:849\n*S KotlinDebug\n*F\n+ 1 NetworkingModule.kt\ncom/facebook/react/modules/network/NetworkingModule\n*L\n296#1:848\n*E\n"})
public final class NetworkingModule
extends NativeNetworkingAndroidSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final ForwardingCookieHandler cookieHandler;
    @Nullable
    private final String defaultUserAgent;
    @Nullable
    private CookieJarContainer cookieJarContainer;
    @NotNull
    private final Set<Integer> requestIds;
    @NotNull
    private final List<RequestBodyHandler> requestBodyHandlers;
    @NotNull
    private final List<UriHandler> uriHandlers;
    @NotNull
    private final List<ResponseHandler> responseHandlers;
    private boolean shuttingDown;
    @NotNull
    public static final String NAME = "Networking";
    @NotNull
    private static final String TAG = "Networking";
    @NotNull
    private static final String CONTENT_ENCODING_HEADER_NAME = "content-encoding";
    @NotNull
    private static final String CONTENT_TYPE_HEADER_NAME = "content-type";
    @NotNull
    private static final String REQUEST_BODY_KEY_STRING = "string";
    @NotNull
    private static final String REQUEST_BODY_KEY_URI = "uri";
    @NotNull
    private static final String REQUEST_BODY_KEY_FORMDATA = "formData";
    @NotNull
    private static final String REQUEST_BODY_KEY_BASE64 = "base64";
    @NotNull
    private static final String USER_AGENT_HEADER_NAME = "user-agent";
    private static final int CHUNK_TIMEOUT_NS = 100000000;
    private static final int MAX_CHUNK_SIZE_BETWEEN_FLUSHES = 8192;
    @Nullable
    private static com.facebook.react.modules.network.CustomClientBuilder customClientBuilder;

    public NetworkingModule(@NotNull ReactApplicationContext reactContext, @Nullable String defaultUserAgent, @NotNull OkHttpClient client, @Nullable List<? extends NetworkInterceptorCreator> networkInterceptorCreators) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        super(reactContext);
        this.cookieHandler = new ForwardingCookieHandler();
        this.requestIds = new HashSet();
        this.requestBodyHandlers = new ArrayList();
        this.uriHandlers = new ArrayList();
        this.responseHandlers = new ArrayList();
        OkHttpClient resolvedClient = client;
        if (networkInterceptorCreators != null) {
            OkHttpClient.Builder clientBuilder = client.newBuilder();
            for (NetworkInterceptorCreator networkInterceptorCreator : networkInterceptorCreators) {
                clientBuilder.addNetworkInterceptor(networkInterceptorCreator.create());
            }
            resolvedClient = clientBuilder.build();
        }
        this.client = resolvedClient;
        CookieJar cookieJar = resolvedClient.-deprecated_cookieJar();
        this.cookieJarContainer = cookieJar instanceof CookieJarContainer ? (CookieJarContainer)cookieJar : null;
        this.defaultUserAgent = defaultUserAgent;
    }

    public NetworkingModule(@NotNull ReactApplicationContext context, @Nullable String defaultUserAgent, @NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this(context, defaultUserAgent, client, null);
    }

    public NetworkingModule(@NotNull ReactApplicationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
        this(context, null, OkHttpClientProvider.createClient(context2), null);
    }

    public NetworkingModule(@NotNull ReactApplicationContext context, @Nullable List<? extends NetworkInterceptorCreator> networkInterceptorCreators) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
        this(context, null, OkHttpClientProvider.createClient(context2), networkInterceptorCreators);
    }

    public NetworkingModule(@NotNull ReactApplicationContext context, @Nullable String defaultUserAgent) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
        this(context, defaultUserAgent, OkHttpClientProvider.createClient(context2), null);
    }

    @Override
    public void initialize() {
        block0: {
            CookieJarContainer cookieJarContainer = this.cookieJarContainer;
            if (cookieJarContainer == null) break block0;
            cookieJarContainer.setCookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)this.cookieHandler));
        }
    }

    @Override
    public void invalidate() {
        this.shuttingDown = true;
        this.cancelAllRequests();
        this.cookieHandler.destroy();
        CookieJarContainer cookieJarContainer = this.cookieJarContainer;
        if (cookieJarContainer != null) {
            cookieJarContainer.removeCookieJar();
        }
        this.requestBodyHandlers.clear();
        this.responseHandlers.clear();
        this.uriHandlers.clear();
    }

    public final void addUriHandler$ReactAndroid_debug(@NotNull UriHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.uriHandlers.add(handler);
    }

    public final void addRequestBodyHandler$ReactAndroid_debug(@NotNull RequestBodyHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.requestBodyHandlers.add(handler);
    }

    public final void addResponseHandler$ReactAndroid_debug(@NotNull ResponseHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.responseHandlers.add(handler);
    }

    public final void removeUriHandler$ReactAndroid_debug(@NotNull UriHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.uriHandlers.remove(handler);
    }

    public final void removeRequestBodyHandler$ReactAndroid_debug(@NotNull RequestBodyHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.requestBodyHandlers.remove(handler);
    }

    public final void removeResponseHandler$ReactAndroid_debug(@NotNull ResponseHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.responseHandlers.remove(handler);
    }

    @Override
    public void sendRequest(@NotNull String method, @NotNull String url, double requestIdAsDouble, @Nullable ReadableArray headers, @Nullable ReadableMap data, @NotNull String responseType, boolean useIncrementalUpdates, double timeoutAsDouble, boolean withCredentials) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)responseType, (String)"responseType");
        int requestId = (int)requestIdAsDouble;
        int timeout = (int)timeoutAsDouble;
        try {
            this.sendRequestInternal(method, url, requestId, headers, data, responseType, useIncrementalUpdates, timeout, withCredentials);
        }
        catch (Throwable th) {
            FLog.e((String)"Networking", (String)("Failed to send url request: " + url), (Throwable)th);
            ResponseUtil.onRequestError(this.getReactApplicationContextIfActiveOrWarn(), requestId, th.getMessage(), th);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void sendRequestInternal(@NotNull String method, @Nullable String url, int requestId, @Nullable ReadableArray headers, @Nullable ReadableMap data, @NotNull String responseType, boolean useIncrementalUpdates, int timeout, boolean withCredentials) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)responseType, (String)"responseType");
        reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
        try {
            uri = Uri.parse((String)url);
            for (UriHandler handler : this.uriHandlers) {
                Intrinsics.checkNotNull((Object)uri);
                if (!handler.supports(uri, responseType)) continue;
                res = handler.fetch(uri);
                ResponseUtil.onResponseReceived(reactApplicationContext, requestId, 200, Arguments.createMap(), url);
                ResponseUtil.onDataReceived(reactApplicationContext, requestId, res);
                ResponseUtil.onRequestSuccess(reactApplicationContext, requestId);
                return;
            }
        }
        catch (IOException e) {
            ResponseUtil.onRequestError(reactApplicationContext, requestId, e.getMessage(), e);
            return;
        }
        requestBuilder = null;
        try {
            v0 = new Request.Builder();
            v1 = url;
            if (v1 == null) {
                v1 = "";
            }
            requestBuilder = v0.url(v1);
        }
        catch (Exception e) {
            ResponseUtil.onRequestError(reactApplicationContext, requestId, e.getMessage(), null);
            return;
        }
        if (requestId != 0) {
            requestBuilder.tag((Object)requestId);
        }
        clientBuilder = this.client.newBuilder();
        com.facebook.react.modules.network.NetworkingModule$Companion.access$applyCustomBuilder(NetworkingModule.Companion, clientBuilder);
        if (!withCredentials) {
            clientBuilder.cookieJar(CookieJar.NO_COOKIES);
        }
        if (useIncrementalUpdates) {
            this_$iv = clientBuilder;
            $i$f$-addNetworkInterceptor = false;
            this_$iv.addNetworkInterceptor(new Interceptor(responseType, reactApplicationContext, requestId){
                final /* synthetic */ String $responseType$inlined;
                final /* synthetic */ ReactApplicationContext $reactApplicationContext$inlined;
                final /* synthetic */ int $requestId$inlined;
                {
                    this.$responseType$inlined = string2;
                    this.$reactApplicationContext$inlined = reactApplicationContext;
                    this.$requestId$inlined = n;
                }

                @NotNull
                public final Response intercept(@NotNull Interceptor.Chain chain) {
                    Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                    Interceptor.Chain chain2 = chain;
                    boolean bl = false;
                    Response originalResponse = chain2.proceed(chain2.request());
                    ResponseBody responseBody2 = originalResponse.-deprecated_body();
                    if (responseBody2 == null) {
                        String string2 = "Required value was null.";
                        throw new IllegalStateException(string2.toString());
                    }
                    ResponseBody originalResponseBody = responseBody2;
                    ProgressResponseBody responseBody3 = new ProgressResponseBody(originalResponseBody, new ProgressListener(this.$responseType$inlined, this.$reactApplicationContext$inlined, this.$requestId$inlined){
                        private long last;
                        final /* synthetic */ String $responseType;
                        final /* synthetic */ ReactApplicationContext $reactApplicationContext;
                        final /* synthetic */ int $requestId;
                        {
                            this.$responseType = $responseType;
                            this.$reactApplicationContext = $reactApplicationContext;
                            this.$requestId = $requestId;
                            this.last = System.nanoTime();
                        }

                        public final long getLast() {
                            return this.last;
                        }

                        public final void setLast(long l) {
                            this.last = l;
                        }

                        public void onProgress(long bytesWritten, long contentLength, boolean done) {
                            long now = System.nanoTime();
                            if (!done && !com.facebook.react.modules.network.NetworkingModule$Companion.access$shouldDispatch(NetworkingModule.Companion, now, this.last)) {
                                return;
                            }
                            if (Intrinsics.areEqual((Object)this.$responseType, (Object)"text")) {
                                return;
                            }
                            ResponseUtil.onDataReceivedProgress(this.$reactApplicationContext, this.$requestId, bytesWritten, contentLength);
                            this.last = now;
                        }
                    });
                    return originalResponse.newBuilder().body((ResponseBody)responseBody3).build();
                }
            });
        }
        if (timeout != this.client.-deprecated_callTimeoutMillis()) {
            clientBuilder.callTimeout((long)timeout, TimeUnit.MILLISECONDS);
        }
        client = clientBuilder.build();
        requestHeaders = this.extractHeaders(headers, data);
        if (requestHeaders == null) {
            ResponseUtil.onRequestError(reactApplicationContext, requestId, "Unrecognized headers format", null);
            return;
        }
        contentType = requestHeaders.get("content-type");
        contentEncoding = requestHeaders.get("content-encoding");
        requestBuilder.headers(requestHeaders);
        handler = null;
        if (data != null) {
            for (RequestBodyHandler curHandler : this.requestBodyHandlers) {
                if (!curHandler.supports(data)) continue;
                handler = curHandler;
                break;
            }
        }
        requestBody = null;
        if (data == null) ** GOTO lbl-1000
        v2 = method.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)v2, (Object)"get")) ** GOTO lbl-1000
        v3 = method.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)v3, (Object)"head")) lbl-1000:
        // 3 sources

        {
            requestBody = RequestBodyUtil.getEmptyBody(method);
        } else {
            v4 = handler;
            if (v4 != null) {
                requestBody = v4.toRequestBody(data, contentType);
            } else if (data.hasKey("string")) {
                if (contentType == null) {
                    ResponseUtil.onRequestError(reactApplicationContext, requestId, "Payload is set but no content-type header specified", null);
                    return;
                }
                body = data.getString("string");
                contentMediaType = MediaType.Companion.-deprecated_parse(contentType);
                if (RequestBodyUtil.isGzipEncoding(contentEncoding)) {
                    requestBody = null;
                    if (contentMediaType != null && body != null) {
                        requestBody = RequestBodyUtil.createGzip(contentMediaType, body);
                    }
                    if (requestBody == null) {
                        ResponseUtil.onRequestError(reactApplicationContext, requestId, "Failed to gzip request body", null);
                        return;
                    }
                } else {
                    if (contentMediaType == null) {
                        v5 = StandardCharsets.UTF_8;
                    } else {
                        v5 = contentMediaType.charset(StandardCharsets.UTF_8);
                        if (v5 == null) {
                            var22_29 = "Required value was null.";
                            throw new IllegalStateException(var22_29.toString());
                        }
                    }
                    charset = v5;
                    if (body == null) {
                        ResponseUtil.onRequestError(reactApplicationContext, requestId, "Received request but body was empty", null);
                        return;
                    }
                    Intrinsics.checkNotNull((Object)charset);
                    v6 = body.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getBytes(...)");
                    requestBody = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (MediaType)contentMediaType, (byte[])v6, (int)0, (int)0, (int)12, null);
                }
            } else if (data.hasKey("base64")) {
                if (contentType == null) {
                    ResponseUtil.onRequestError(reactApplicationContext, requestId, "Payload is set but no content-type header specified", null);
                    return;
                }
                base64String = data.getString("base64");
                if (base64String == null) {
                    contentMediaType = "Required value was null.";
                    throw new IllegalStateException(contentMediaType.toString());
                }
                contentMediaType = MediaType.Companion.-deprecated_parse(contentType);
                if (contentMediaType == null) {
                    ResponseUtil.onRequestError(reactApplicationContext, requestId, "Invalid content type specified: " + contentType, null);
                    return;
                }
                base64DecodedString = ByteString.Companion.-deprecated_decodeBase64(base64String);
                if (base64DecodedString == null) {
                    ResponseUtil.onRequestError(reactApplicationContext, requestId, "Request body base64 string was invalid", null);
                    return;
                }
                requestBody = RequestBody.Companion.create(contentMediaType, base64DecodedString);
            } else if (data.hasKey("uri")) {
                if (contentType == null) {
                    ResponseUtil.onRequestError(reactApplicationContext, requestId, "Payload is set but no content-type header specified", null);
                    return;
                }
                uri = data.getString("uri");
                if (uri == null) {
                    ResponseUtil.onRequestError(reactApplicationContext, requestId, "Request body URI field was set but null", null);
                    return;
                }
                v7 = this.getReactApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getReactApplicationContext(...)");
                fileInputStream = RequestBodyUtil.getFileInputStream((Context)v7, uri);
                if (fileInputStream == null) {
                    ResponseUtil.onRequestError(reactApplicationContext, requestId, "Could not retrieve file for uri " + uri, null);
                    return;
                }
                requestBody = RequestBodyUtil.create(MediaType.Companion.-deprecated_parse(contentType), fileInputStream);
            } else if (data.hasKey("formData")) {
                if (contentType == null) {
                    contentType = "multipart/form-data";
                }
                if ((parts = data.getArray("formData")) == null) {
                    ResponseUtil.onRequestError(reactApplicationContext, requestId, "Received request but form data was empty", null);
                    return;
                }
                v8 = this.constructMultipartBody(parts, contentType, requestId);
                if (v8 == null) {
                    return;
                }
                multipartBuilder = v8;
                requestBody = (RequestBody)multipartBuilder.build();
            } else {
                requestBody = RequestBodyUtil.getEmptyBody(method);
            }
        }
        requestBuilder.method(method, this.wrapRequestBodyWithProgressEmitter(requestBody, requestId));
        this.addRequest(requestId);
        client.newCall(requestBuilder.build()).enqueue(new okhttp3.Callback(this, requestId, reactApplicationContext, responseType, useIncrementalUpdates){
            final /* synthetic */ NetworkingModule this$0;
            final /* synthetic */ int $requestId;
            final /* synthetic */ ReactApplicationContext $reactApplicationContext;
            final /* synthetic */ String $responseType;
            final /* synthetic */ boolean $useIncrementalUpdates;
            {
                this.this$0 = $receiver;
                this.$requestId = $requestId;
                this.$reactApplicationContext = $reactApplicationContext;
                this.$responseType = $responseType;
                this.$useIncrementalUpdates = $useIncrementalUpdates;
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (NetworkingModule.access$getShuttingDown$p(this.this$0)) {
                    return;
                }
                NetworkingModule.access$removeRequest(this.this$0, this.$requestId);
                Object object = e.getMessage();
                if (object == null) {
                    object = "Error while executing request: " + e.getClass().getSimpleName();
                }
                String errorMessage = object;
                ResponseUtil.onRequestError(this.$reactApplicationContext, this.$requestId, errorMessage, e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (NetworkingModule.access$getShuttingDown$p(this.this$0)) {
                    return;
                }
                NetworkingModule.access$removeRequest(this.this$0, this.$requestId);
                ResponseUtil.onResponseReceived(this.$reactApplicationContext, this.$requestId, response.-deprecated_code(), com.facebook.react.modules.network.NetworkingModule$Companion.access$translateHeaders(NetworkingModule.Companion, response.-deprecated_headers()), response.-deprecated_request().-deprecated_url().toString());
                try {
                    Object gzipSource;
                    ResponseBody responseBody2 = response.-deprecated_body();
                    if (responseBody2 == null) {
                        ResponseUtil.onRequestError(this.$reactApplicationContext, this.$requestId, "Response body is null", null);
                        return;
                    }
                    if (StringsKt.equals((String)"gzip", (String)Response.header$default((Response)response, (String)"Content-Encoding", null, (int)2, null), (boolean)true)) {
                        MediaType mediaType;
                        gzipSource = new GzipSource((Source)responseBody2.source());
                        String string2 = Response.header$default((Response)response, (String)"Content-Type", null, (int)2, null);
                        if (string2 != null) {
                            String string3 = string2;
                            MediaType.Companion companion = MediaType.Companion;
                            String p0 = string3;
                            boolean bl = false;
                            mediaType = companion.-deprecated_parse(p0);
                        } else {
                            mediaType = null;
                        }
                        MediaType parsedContentType = mediaType;
                        responseBody2 = ResponseBody.Companion.create(parsedContentType, -1L, -DeprecatedUpgrade.getOkio().buffer((Source)gzipSource));
                    }
                    if (responseBody2 == null) {
                        gzipSource = "Required value was null.";
                        throw new IllegalStateException(gzipSource.toString());
                    }
                    for (ResponseHandler responseHandler : NetworkingModule.access$getResponseHandlers$p(this.this$0)) {
                        if (!responseHandler.supports(this.$responseType)) continue;
                        WritableMap res = responseHandler.toResponseData(responseBody2);
                        ResponseUtil.onDataReceived(this.$reactApplicationContext, this.$requestId, res);
                        ResponseUtil.onRequestSuccess(this.$reactApplicationContext, this.$requestId);
                        return;
                    }
                    if (this.$useIncrementalUpdates && Intrinsics.areEqual((Object)this.$responseType, (Object)"text")) {
                        NetworkingModule.access$readWithProgress(this.this$0, this.$requestId, responseBody2);
                        ResponseUtil.onRequestSuccess(this.$reactApplicationContext, this.$requestId);
                        return;
                    }
                    String responseString = "";
                    if (Intrinsics.areEqual((Object)this.$responseType, (Object)"text")) {
                        try {
                            responseString = responseBody2.string();
                        }
                        catch (IOException e) {
                            if (!StringsKt.equals((String)response.-deprecated_request().-deprecated_method(), (String)"HEAD", (boolean)true)) {
                                ResponseUtil.onRequestError(this.$reactApplicationContext, this.$requestId, e.getMessage(), e);
                            }
                        }
                    } else if (Intrinsics.areEqual((Object)this.$responseType, (Object)"base64")) {
                        responseString = Base64.encodeToString((byte[])responseBody2.bytes(), (int)2);
                    }
                    ResponseUtil.onDataReceived(this.$reactApplicationContext, this.$requestId, responseString);
                    ResponseUtil.onRequestSuccess(this.$reactApplicationContext, this.$requestId);
                }
                catch (IOException e) {
                    ResponseUtil.onRequestError(this.$reactApplicationContext, this.$requestId, e.getMessage(), e);
                }
            }
        });
    }

    private final RequestBody wrapRequestBodyWithProgressEmitter(RequestBody requestBody, int requestId) {
        if (requestBody == null) {
            return null;
        }
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
        return RequestBodyUtil.createProgressRequest(requestBody, new ProgressListener(reactApplicationContext, requestId){
            private long last;
            final /* synthetic */ ReactApplicationContext $reactApplicationContext;
            final /* synthetic */ int $requestId;
            {
                this.$reactApplicationContext = $reactApplicationContext;
                this.$requestId = $requestId;
                this.last = System.nanoTime();
            }

            public final long getLast() {
                return this.last;
            }

            public final void setLast(long l) {
                this.last = l;
            }

            public void onProgress(long bytesWritten, long contentLength, boolean done) {
                long now = System.nanoTime();
                if (done || com.facebook.react.modules.network.NetworkingModule$Companion.access$shouldDispatch(NetworkingModule.Companion, now, this.last)) {
                    ResponseUtil.onDataSend(this.$reactApplicationContext, this.$requestId, bytesWritten, contentLength);
                    this.last = now;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readWithProgress(int requestId, ResponseBody responseBody2) throws IOException {
        Charset charset;
        long totalBytesRead = -1L;
        long contentLength = -1L;
        try {
            Intrinsics.checkNotNull((Object)responseBody2, (String)"null cannot be cast to non-null type com.facebook.react.modules.network.ProgressResponseBody");
            ProgressResponseBody progressResponseBody = (ProgressResponseBody)responseBody2;
            totalBytesRead = progressResponseBody.totalBytesRead();
            contentLength = progressResponseBody.contentLength();
        }
        catch (ClassCastException progressResponseBody) {
            // empty catch block
        }
        if (responseBody2.contentType() == null) {
            charset = StandardCharsets.UTF_8;
        } else {
            MediaType mediaType = responseBody2.contentType();
            charset = mediaType != null ? mediaType.charset(StandardCharsets.UTF_8) : null;
            if (charset == null) {
                boolean $i$a$-checkNotNull-NetworkingModule$readWithProgress$charset$22 = false;
                String $i$a$-checkNotNull-NetworkingModule$readWithProgress$charset$22 = "Null character set for Content-Type: " + responseBody2.contentType();
                throw new IllegalStateException($i$a$-checkNotNull-NetworkingModule$readWithProgress$charset$22.toString());
            }
        }
        Charset charset2 = charset;
        Intrinsics.checkNotNull((Object)charset2);
        ProgressiveStringDecoder streamDecoder = new ProgressiveStringDecoder(charset2);
        try (InputStream inputStream = responseBody2.byteStream();){
            byte[] buffer = new byte[8192];
            int read = 0;
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            while (true) {
                int n;
                int it = n = inputStream.read(buffer);
                boolean bl = false;
                read = it;
                if (n != -1) {
                    ResponseUtil.onIncrementalDataReceived(reactApplicationContext, requestId, streamDecoder.decodeNext(buffer, read), totalBytesRead, contentLength);
                    continue;
                }
                break;
            }
        }
    }

    private final synchronized void addRequest(int requestId) {
        this.requestIds.add(requestId);
    }

    private final synchronized void removeRequest(int requestId) {
        this.requestIds.remove(requestId);
    }

    private final synchronized void cancelAllRequests() {
        Iterator<Integer> iterator2 = this.requestIds.iterator();
        while (iterator2.hasNext()) {
            int requestId = ((Number)iterator2.next()).intValue();
            this.cancelRequest(requestId);
        }
        this.requestIds.clear();
    }

    @Override
    public void abortRequest(double requestIdAsDouble) {
        int requestId = (int)requestIdAsDouble;
        this.cancelRequest(requestId);
        this.removeRequest(requestId);
    }

    private final void cancelRequest(int requestId) {
        OkHttpCallUtil.cancelTag(this.client, requestId);
    }

    @Override
    @ReactMethod
    public void clearCookies(@NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.cookieHandler.clearCookies(callback);
    }

    @Override
    public void addListener(@Nullable String eventName) {
    }

    @Override
    public void removeListeners(double count) {
    }

    private final MultipartBody.Builder constructMultipartBody(ReadableArray body, String contentType, int requestId) {
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder(null, 1, null);
        MediaType mediaType = MediaType.Companion.-deprecated_parse(contentType);
        if (mediaType == null) {
            ResponseUtil.onRequestError(reactApplicationContext, requestId, "Invalid media type.", null);
            return null;
        }
        multipartBuilder.setType(mediaType);
        int n = body.size();
        for (int i = 0; i < n; ++i) {
            Unit unit;
            ReadableMap bodyPart = body.getMap(i);
            if (bodyPart == null) {
                ResponseUtil.onRequestError(reactApplicationContext, requestId, "Unrecognized FormData part.", null);
                return null;
            }
            ReadableArray headersArray = bodyPart.getArray("headers");
            Headers headers = this.extractHeaders(headersArray, null);
            if (headers == null) {
                ResponseUtil.onRequestError(reactApplicationContext, requestId, "Missing or invalid header format for FormData part.", null);
                return null;
            }
            MediaType partContentType = null;
            String partContentTypeStr = headers.get(CONTENT_TYPE_HEADER_NAME);
            if (partContentTypeStr != null) {
                partContentType = MediaType.Companion.-deprecated_parse(partContentTypeStr);
                headers = headers.newBuilder().removeAll(CONTENT_TYPE_HEADER_NAME).build();
            }
            if (bodyPart.hasKey(REQUEST_BODY_KEY_STRING) && bodyPart.getString(REQUEST_BODY_KEY_STRING) != null) {
                String string2 = bodyPart.getString(REQUEST_BODY_KEY_STRING);
                if (string2 == null) {
                    string2 = "";
                }
                String bodyValue = string2;
                unit = multipartBuilder.addPart(headers, RequestBody.Companion.create(partContentType, bodyValue));
                continue;
            }
            if (bodyPart.hasKey(REQUEST_BODY_KEY_URI) && bodyPart.getString(REQUEST_BODY_KEY_URI) != null) {
                if (partContentType == null) {
                    ResponseUtil.onRequestError(reactApplicationContext, requestId, "Binary FormData part needs a content-type header.", null);
                    return null;
                }
                String fileContentUriStr = bodyPart.getString(REQUEST_BODY_KEY_URI);
                if (fileContentUriStr == null) {
                    ResponseUtil.onRequestError(reactApplicationContext, requestId, "Body must have a valid file uri", null);
                    return null;
                }
                ReactApplicationContext reactApplicationContext2 = this.getReactApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)reactApplicationContext2), (String)"getReactApplicationContext(...)");
                InputStream fileInputStream = RequestBodyUtil.getFileInputStream((Context)reactApplicationContext2, fileContentUriStr);
                if (fileInputStream == null) {
                    ResponseUtil.onRequestError(reactApplicationContext, requestId, "Could not retrieve file for uri " + fileContentUriStr, null);
                    return null;
                }
                unit = multipartBuilder.addPart(headers, RequestBodyUtil.create(partContentType, fileInputStream));
                continue;
            }
            ResponseUtil.onRequestError(reactApplicationContext, requestId, "Unrecognized FormData part.", null);
            unit = Unit.INSTANCE;
        }
        return multipartBuilder;
    }

    private final Headers extractHeaders(ReadableArray headersArray, ReadableMap requestData) {
        boolean isGzipSupported;
        if (headersArray == null) {
            return null;
        }
        Headers.Builder headersBuilder = new Headers.Builder();
        int n = headersArray.size();
        for (int headersIdx = 0; headersIdx < n; ++headersIdx) {
            ReadableArray header = headersArray.getArray(headersIdx);
            if (header == null || header.size() != 2) {
                return null;
            }
            String headerName = header.getString(0);
            if (headerName != null) {
                headerName = HeaderUtil.Companion.stripHeaderName(headerName);
            }
            String headerValue = header.getString(1);
            if (headerName == null || headerValue == null) {
                return null;
            }
            headersBuilder.addUnsafeNonAscii(headerName, headerValue);
        }
        if (headersBuilder.get(USER_AGENT_HEADER_NAME) == null && this.defaultUserAgent != null) {
            headersBuilder.add(USER_AGENT_HEADER_NAME, this.defaultUserAgent);
        }
        ReadableMap readableMap = requestData;
        boolean bl = readableMap != null ? readableMap.hasKey(REQUEST_BODY_KEY_STRING) : (isGzipSupported = false);
        if (!isGzipSupported) {
            headersBuilder.removeAll(CONTENT_ENCODING_HEADER_NAME);
        }
        return headersBuilder.build();
    }

    @JvmStatic
    public static final void setCustomClientBuilder(@Nullable com.facebook.react.modules.network.CustomClientBuilder ccb) {
        Companion.setCustomClientBuilder(ccb);
    }

    public static final /* synthetic */ boolean access$getShuttingDown$p(NetworkingModule $this) {
        return $this.shuttingDown;
    }

    public static final /* synthetic */ void access$removeRequest(NetworkingModule $this, int requestId) {
        $this.removeRequest(requestId);
    }

    public static final /* synthetic */ List access$getResponseHandlers$p(NetworkingModule $this) {
        return $this.responseHandlers;
    }

    public static final /* synthetic */ void access$readWithProgress(NetworkingModule $this, int requestId, ResponseBody responseBody2) {
        $this.readWithProgress(requestId, responseBody2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0007J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/facebook/react/modules/network/NetworkingModule$Companion;", "", "<init>", "()V", "NAME", "", "TAG", "CONTENT_ENCODING_HEADER_NAME", "CONTENT_TYPE_HEADER_NAME", "REQUEST_BODY_KEY_STRING", "REQUEST_BODY_KEY_URI", "REQUEST_BODY_KEY_FORMDATA", "REQUEST_BODY_KEY_BASE64", "USER_AGENT_HEADER_NAME", "CHUNK_TIMEOUT_NS", "", "MAX_CHUNK_SIZE_BETWEEN_FLUSHES", "customClientBuilder", "Lcom/facebook/react/modules/network/CustomClientBuilder;", "setCustomClientBuilder", "", "ccb", "applyCustomBuilder", "builder", "Lokhttp3/OkHttpClient$Builder;", "shouldDispatch", "", "now", "", "last", "translateHeaders", "Lcom/facebook/react/bridge/WritableMap;", "headers", "Lokhttp3/Headers;", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void setCustomClientBuilder(@Nullable com.facebook.react.modules.network.CustomClientBuilder ccb) {
            NetworkingModule.customClientBuilder = ccb;
        }

        private final void applyCustomBuilder(OkHttpClient.Builder builder) {
            block0: {
                com.facebook.react.modules.network.CustomClientBuilder customClientBuilder = customClientBuilder;
                if (customClientBuilder == null) break block0;
                customClientBuilder.apply(builder);
            }
        }

        private final boolean shouldDispatch(long now, long last) {
            return last + (long)100000000 < now;
        }

        private final WritableMap translateHeaders(Headers headers) {
            Bundle responseHeaders = new Bundle();
            int n = headers.-deprecated_size();
            for (int i = 0; i < n; ++i) {
                String headerName = headers.name(i);
                if (responseHeaders.containsKey(headerName)) {
                    responseHeaders.putString(headerName, responseHeaders.getString(headerName) + ", " + headers.value(i));
                    continue;
                }
                responseHeaders.putString(headerName, headers.value(i));
            }
            WritableMap writableMap = Arguments.fromBundle(responseHeaders);
            Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"fromBundle(...)");
            return writableMap;
        }

        public static final /* synthetic */ void access$applyCustomBuilder(Companion $this, OkHttpClient.Builder builder) {
            $this.applyCustomBuilder(builder);
        }

        public static final /* synthetic */ WritableMap access$translateHeaders(Companion $this, Headers headers) {
            return $this.translateHeaders(headers);
        }

        public static final /* synthetic */ boolean access$shouldDispatch(Companion $this, long now, long last) {
            return $this.shouldDispatch(now, last);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Deprecated(message="To be removed in a future release. See\n        https://github.com/facebook/react-native/pull/37798#pullrequestreview-1518338914")
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0002\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/modules/network/NetworkingModule$CustomClientBuilder;", "Lcom/facebook/react/modules/network/CustomClientBuilder;", "ReactAndroid_debug"})
    public static interface CustomClientBuilder
    extends com.facebook.react.modules.network.CustomClientBuilder {
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/modules/network/NetworkingModule$RequestBodyHandler;", "", "supports", "", "map", "Lcom/facebook/react/bridge/ReadableMap;", "toRequestBody", "Lokhttp3/RequestBody;", "contentType", "", "ReactAndroid_debug"})
    public static interface RequestBodyHandler {
        public boolean supports(@NotNull ReadableMap var1);

        @Nullable
        public RequestBody toRequestBody(@NotNull ReadableMap var1, @Nullable String var2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/modules/network/NetworkingModule$ResponseHandler;", "", "supports", "", "responseType", "", "toResponseData", "Lcom/facebook/react/bridge/WritableMap;", "body", "Lokhttp3/ResponseBody;", "ReactAndroid_debug"})
    public static interface ResponseHandler {
        public boolean supports(@NotNull String var1);

        @NotNull
        public WritableMap toResponseData(@NotNull ResponseBody var1) throws IOException;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/modules/network/NetworkingModule$UriHandler;", "", "supports", "", "uri", "Landroid/net/Uri;", "responseType", "", "fetch", "Lcom/facebook/react/bridge/WritableMap;", "ReactAndroid_debug"})
    public static interface UriHandler {
        public boolean supports(@NotNull Uri var1, @NotNull String var2);

        @NotNull
        public WritableMap fetch(@NotNull Uri var1) throws IOException;
    }
}

