/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0002\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\u0004\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\u0004\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J$\u0010\u0004\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u0004\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0004\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0004\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0004\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0004\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J0\u0010\u0004\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0004\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000bH\u0017R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/bridge/PromiseImpl;", "Lcom/facebook/react/bridge/Promise;", "resolve", "Lcom/facebook/react/bridge/Callback;", "reject", "<init>", "(Lcom/facebook/react/bridge/Callback;Lcom/facebook/react/bridge/Callback;)V", "", "value", "", "code", "", "message", "throwable", "", "userInfo", "Lcom/facebook/react/bridge/WritableMap;", "Companion", "ReactAndroid_debug"})
@DoNotStrip
public final class PromiseImpl
implements Promise {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private Callback resolve;
    @Nullable
    private Callback reject;
    private static final int ERROR_STACK_FRAME_LIMIT = 50;
    @NotNull
    private static final String ERROR_DEFAULT_CODE = "EUNSPECIFIED";
    @NotNull
    private static final String ERROR_DEFAULT_MESSAGE = "Error not specified.";
    @NotNull
    private static final String ERROR_MAP_KEY_CODE = "code";
    @NotNull
    private static final String ERROR_MAP_KEY_MESSAGE = "message";
    @NotNull
    private static final String ERROR_MAP_KEY_NAME = "name";
    @NotNull
    private static final String ERROR_MAP_KEY_USER_INFO = "userInfo";
    @NotNull
    private static final String ERROR_MAP_KEY_NATIVE_STACK = "nativeStackAndroid";
    @NotNull
    private static final String STACK_FRAME_KEY_CLASS = "class";
    @NotNull
    private static final String STACK_FRAME_KEY_FILE = "file";
    @NotNull
    private static final String STACK_FRAME_KEY_LINE_NUMBER = "lineNumber";
    @NotNull
    private static final String STACK_FRAME_KEY_METHOD_NAME = "methodName";

    @DoNotStrip
    public PromiseImpl(@Nullable Callback resolve, @Nullable Callback reject) {
        this.resolve = resolve;
        this.reject = reject;
    }

    @Override
    public void resolve(@Nullable Object value) {
        block0: {
            Callback callback = this.resolve;
            if (callback == null) break block0;
            Callback callback2 = callback;
            boolean bl = false;
            Object[] objectArray = new Object[]{value};
            callback2.invoke(objectArray);
            this.resolve = null;
            this.reject = null;
        }
    }

    @Override
    public void reject(@NotNull String code, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)code, (String)ERROR_MAP_KEY_CODE);
        this.reject(code, message, null, null);
    }

    @Override
    public void reject(@NotNull String code, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)code, (String)ERROR_MAP_KEY_CODE);
        this.reject(code, null, throwable, null);
    }

    @Override
    public void reject(@NotNull String code, @Nullable String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)code, (String)ERROR_MAP_KEY_CODE);
        this.reject(code, message, throwable, null);
    }

    @Override
    public void reject(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.reject(null, null, throwable, null);
    }

    @Override
    public void reject(@NotNull Throwable throwable, @NotNull WritableMap userInfo) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)ERROR_MAP_KEY_USER_INFO);
        this.reject(null, null, throwable, userInfo);
    }

    @Override
    public void reject(@NotNull String code, @NotNull WritableMap userInfo) {
        Intrinsics.checkNotNullParameter((Object)code, (String)ERROR_MAP_KEY_CODE);
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)ERROR_MAP_KEY_USER_INFO);
        this.reject(code, null, null, userInfo);
    }

    @Override
    public void reject(@NotNull String code, @Nullable Throwable throwable, @NotNull WritableMap userInfo) {
        Intrinsics.checkNotNullParameter((Object)code, (String)ERROR_MAP_KEY_CODE);
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)ERROR_MAP_KEY_USER_INFO);
        this.reject(code, null, throwable, userInfo);
    }

    @Override
    public void reject(@NotNull String code, @Nullable String message, @NotNull WritableMap userInfo) {
        Intrinsics.checkNotNullParameter((Object)code, (String)ERROR_MAP_KEY_CODE);
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)ERROR_MAP_KEY_USER_INFO);
        this.reject(code, message, null, userInfo);
    }

    @Override
    public void reject(@Nullable String code, @Nullable String message, @Nullable Throwable throwable, @Nullable WritableMap userInfo) {
        Object[] objectArray;
        if (this.reject == null) {
            this.resolve = null;
            return;
        }
        WritableNativeMap errorInfo = new WritableNativeMap();
        if (code == null) {
            errorInfo.putString(ERROR_MAP_KEY_CODE, ERROR_DEFAULT_CODE);
        } else {
            errorInfo.putString(ERROR_MAP_KEY_CODE, code);
        }
        if (message != null) {
            errorInfo.putString(ERROR_MAP_KEY_MESSAGE, message);
        } else if (throwable != null) {
            String throwableMessage = throwable.getMessage();
            objectArray = (Object[])throwableMessage;
            if (objectArray == null || objectArray.length() == 0) {
                throwableMessage = throwable.getClass().getCanonicalName();
            }
            errorInfo.putString(ERROR_MAP_KEY_MESSAGE, throwableMessage);
        } else {
            errorInfo.putString(ERROR_MAP_KEY_MESSAGE, ERROR_DEFAULT_MESSAGE);
        }
        if (userInfo != null) {
            errorInfo.putMap(ERROR_MAP_KEY_USER_INFO, userInfo);
        } else {
            errorInfo.putNull(ERROR_MAP_KEY_USER_INFO);
        }
        if (throwable != null) {
            errorInfo.putString(ERROR_MAP_KEY_NAME, throwable.getClass().getCanonicalName());
            StackTraceElement[] stackTrace = throwable.getStackTrace();
            WritableNativeArray nativeStackAndroid = new WritableNativeArray();
            for (int i = 0; i < stackTrace.length && i < 50; ++i) {
                StackTraceElement frame = stackTrace[i];
                WritableMap frameMap = new WritableNativeMap();
                frameMap.putString(STACK_FRAME_KEY_CLASS, frame.getClassName());
                frameMap.putString(STACK_FRAME_KEY_FILE, frame.getFileName());
                frameMap.putInt(STACK_FRAME_KEY_LINE_NUMBER, frame.getLineNumber());
                frameMap.putString(STACK_FRAME_KEY_METHOD_NAME, frame.getMethodName());
                nativeStackAndroid.pushMap(frameMap);
            }
            errorInfo.putArray(ERROR_MAP_KEY_NATIVE_STACK, nativeStackAndroid);
        } else {
            errorInfo.putArray(ERROR_MAP_KEY_NATIVE_STACK, new WritableNativeArray());
        }
        Callback callback = this.reject;
        if (callback != null) {
            objectArray = new Object[]{errorInfo};
            callback.invoke(objectArray);
        }
        this.resolve = null;
        this.reject = null;
    }

    @Override
    @Deprecated(message="Use reject(code, message) instead.", replaceWith=@ReplaceWith(expression="reject(code, message)", imports={}))
    public void reject(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)ERROR_MAP_KEY_MESSAGE);
        this.reject(null, message, null, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/bridge/PromiseImpl$Companion;", "", "<init>", "()V", "ERROR_STACK_FRAME_LIMIT", "", "ERROR_DEFAULT_CODE", "", "ERROR_DEFAULT_MESSAGE", "ERROR_MAP_KEY_CODE", "ERROR_MAP_KEY_MESSAGE", "ERROR_MAP_KEY_NAME", "ERROR_MAP_KEY_USER_INFO", "ERROR_MAP_KEY_NATIVE_STACK", "STACK_FRAME_KEY_CLASS", "STACK_FRAME_KEY_FILE", "STACK_FRAME_KEY_LINE_NUMBER", "STACK_FRAME_KEY_METHOD_NAME", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

