/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public final class ViewManagerRegistry
implements ComponentCallbacks2 {
    private final Map<String, ViewManager> mViewManagers;
    @Nullable
    private final ViewManagerResolver mViewManagerResolver;

    public ViewManagerRegistry(ViewManagerResolver viewManagerResolver) {
        this.mViewManagers = MapBuilder.newHashMap();
        this.mViewManagerResolver = viewManagerResolver;
    }

    public ViewManagerRegistry(List<ViewManager> viewManagerList) {
        HashMap<String, ViewManager> viewManagerMap = MapBuilder.newHashMap();
        for (ViewManager viewManager : viewManagerList) {
            viewManagerMap.put(viewManager.getName(), viewManager);
        }
        this.mViewManagers = viewManagerMap;
        this.mViewManagerResolver = null;
    }

    public ViewManagerRegistry(Map<String, ViewManager> viewManagerMap) {
        this.mViewManagers = viewManagerMap != null ? viewManagerMap : MapBuilder.newHashMap();
        this.mViewManagerResolver = null;
    }

    public synchronized ViewManager get(String className) {
        ViewManager viewManager = this.mViewManagers.get(className);
        if (viewManager != null) {
            return viewManager;
        }
        String rctViewManagerName = "RCT" + className;
        viewManager = this.mViewManagers.get(rctViewManagerName);
        if (viewManager != null) {
            return viewManager;
        }
        if (this.mViewManagerResolver != null) {
            viewManager = this.getViewManagerFromResolver(className);
            if (viewManager != null) {
                return viewManager;
            }
            viewManager = this.getViewManagerFromResolver(rctViewManagerName);
            if (viewManager != null) {
                return viewManager;
            }
            throw new IllegalViewOperationException("Can't find ViewManager '" + className + "' nor '" + rctViewManagerName + "' in ViewManagerRegistry, existing names are: " + this.mViewManagerResolver.getViewManagerNames());
        }
        throw new IllegalViewOperationException("No ViewManager found for class " + className);
    }

    @Nullable
    private ViewManager getViewManagerFromResolver(String className) {
        ViewManager<?, ?> viewManager = null;
        if (this.mViewManagerResolver != null) {
            viewManager = this.mViewManagerResolver.getViewManager(className);
        }
        if (viewManager != null) {
            this.mViewManagers.put(className, viewManager);
        }
        return viewManager;
    }

    @Nullable
    synchronized ViewManager getViewManagerIfExists(String className) {
        ViewManager viewManager = this.mViewManagers.get(className);
        if (viewManager != null) {
            return viewManager;
        }
        if (this.mViewManagerResolver != null) {
            return this.getViewManagerFromResolver(className);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceStopped(int surfaceId) {
        ArrayList<ViewManager> viewManagers;
        ViewManagerRegistry viewManagerRegistry2 = this;
        synchronized (viewManagerRegistry2) {
            viewManagers = new ArrayList<ViewManager>(this.mViewManagers.values());
        }
        Runnable runnable = () -> {
            for (ViewManager viewManager : viewManagers) {
                viewManager.onSurfaceStopped(surfaceId);
            }
        };
        if (UiThreadUtil.isOnUiThread()) {
            runnable.run();
        } else {
            UiThreadUtil.runOnUiThread(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        ArrayList<ViewManager> viewManagers;
        ViewManagerRegistry viewManagerRegistry2 = this;
        synchronized (viewManagerRegistry2) {
            viewManagers = new ArrayList<ViewManager>(this.mViewManagers.values());
        }
        Runnable runnable = () -> {
            for (ViewManager viewManager : viewManagers) {
                viewManager.invalidate();
            }
        };
        if (UiThreadUtil.isOnUiThread()) {
            runnable.run();
        } else {
            UiThreadUtil.runOnUiThread(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrimMemory(int level) {
        ArrayList<ViewManager> viewManagers;
        ViewManagerRegistry viewManagerRegistry2 = this;
        synchronized (viewManagerRegistry2) {
            viewManagers = new ArrayList<ViewManager>(this.mViewManagers.values());
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (ViewManager viewManager : viewManagers) {
                    viewManager.trimMemory();
                }
            }
        };
        if (UiThreadUtil.isOnUiThread()) {
            runnable.run();
        } else {
            UiThreadUtil.runOnUiThread(runnable);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void onLowMemory() {
        this.onTrimMemory(0);
    }
}

