/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.dialog;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.R;
import androidx.appcompat.app.AlertDialog;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.R;
import com.facebook.react.modules.dialog.DialogModule;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B!\b\u0011\u0012\f\u0010\u0005\u001a\b\u0018\u00010\u0006R\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0003\u0010\nJ\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\b\u0018\u00010\u0006R\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/react/modules/dialog/AlertFragment;", "Landroidx/fragment/app/DialogFragment;", "Landroid/content/DialogInterface$OnClickListener;", "<init>", "()V", "listener", "Lcom/facebook/react/modules/dialog/DialogModule$AlertFragmentListener;", "Lcom/facebook/react/modules/dialog/DialogModule;", "arguments", "Landroid/os/Bundle;", "(Lcom/facebook/react/modules/dialog/DialogModule$AlertFragmentListener;Landroid/os/Bundle;)V", "onCreateDialog", "Landroid/app/Dialog;", "savedInstanceState", "onClick", "", "dialog", "Landroid/content/DialogInterface;", "which", "", "onDismiss", "Companion", "ReactAndroid_debug"})
@SuppressLint(value={"fragment_subclass_nonempty_constructor"})
public final class AlertFragment
extends DialogFragment
implements DialogInterface.OnClickListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final DialogModule.AlertFragmentListener listener;
    @NotNull
    public static final String ARG_TITLE = "title";
    @NotNull
    public static final String ARG_MESSAGE = "message";
    @NotNull
    public static final String ARG_BUTTON_POSITIVE = "button_positive";
    @NotNull
    public static final String ARG_BUTTON_NEGATIVE = "button_negative";
    @NotNull
    public static final String ARG_BUTTON_NEUTRAL = "button_neutral";
    @NotNull
    public static final String ARG_ITEMS = "items";

    public AlertFragment() {
        this.listener = null;
    }

    @SuppressLint(value={"ValidFragment"})
    public AlertFragment(@Nullable DialogModule.AlertFragmentListener listener, @Nullable Bundle arguments) {
        this.listener = listener;
        this.setArguments(arguments);
    }

    @NotNull
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        FragmentActivity fragmentActivity = this.requireActivity();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity(...)");
        Context context = (Context)fragmentActivity;
        Bundle bundle = this.requireArguments();
        Intrinsics.checkNotNullExpressionValue((Object)bundle, (String)"requireArguments(...)");
        return Companion.createDialog(context, bundle, this);
    }

    public void onClick(@NotNull DialogInterface dialog, int which) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
            DialogModule.AlertFragmentListener alertFragmentListener = this.listener;
            if (alertFragmentListener == null) break block0;
            alertFragmentListener.onClick(dialog, which);
        }
    }

    public void onDismiss(@NotNull DialogInterface dialog) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
            super.onDismiss(dialog);
            DialogModule.AlertFragmentListener alertFragmentListener = this.listener;
            if (alertFragmentListener == null) break block0;
            alertFragmentListener.onDismiss(dialog);
        }
    }

    @JvmStatic
    @NotNull
    public static final Dialog createDialog(@NotNull Context activityContext, @NotNull Bundle arguments, @NotNull DialogInterface.OnClickListener fragment) {
        return Companion.createDialog(activityContext, arguments, fragment);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J \u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/facebook/react/modules/dialog/AlertFragment$Companion;", "", "<init>", "()V", "ARG_TITLE", "", "ARG_MESSAGE", "ARG_BUTTON_POSITIVE", "ARG_BUTTON_NEGATIVE", "ARG_BUTTON_NEUTRAL", "ARG_ITEMS", "createDialog", "Landroid/app/Dialog;", "activityContext", "Landroid/content/Context;", "arguments", "Landroid/os/Bundle;", "fragment", "Landroid/content/DialogInterface$OnClickListener;", "isAppCompatTheme", "", "getAccessibleTitle", "Landroid/view/View;", "titleText", "createAppCompatDialog", "createAppDialog", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Dialog createDialog(@NotNull Context activityContext, @NotNull Bundle arguments, @NotNull DialogInterface.OnClickListener fragment) {
            Intrinsics.checkNotNullParameter((Object)activityContext, (String)"activityContext");
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            return this.isAppCompatTheme(activityContext) ? this.createAppCompatDialog(activityContext, arguments, fragment) : this.createAppDialog(activityContext, arguments, fragment);
        }

        private final boolean isAppCompatTheme(Context activityContext) {
            TypedArray typedArray = activityContext.obtainStyledAttributes(R.styleable.AppCompatTheme);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
            TypedArray attributes = typedArray;
            boolean isAppCompat = attributes.hasValue(R.styleable.AppCompatTheme_windowActionBar);
            attributes.recycle();
            return isAppCompat;
        }

        private final View getAccessibleTitle(Context activityContext, String titleText) {
            LayoutInflater inflater = LayoutInflater.from((Context)activityContext);
            View view = inflater.inflate(R.layout.alert_title_layout, null);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"inflate(...)");
            View titleContainer = view;
            Object object = Assertions.assertNotNull((Object)titleContainer.findViewById(R.id.alert_title));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assertNotNull(...)");
            TextView accessibleTitle = (TextView)object;
            accessibleTitle.setText((CharSequence)titleText);
            accessibleTitle.setFocusable(true);
            if (Build.VERSION.SDK_INT >= 28) {
                accessibleTitle.setAccessibilityHeading(true);
            } else {
                ViewCompat.setAccessibilityDelegate((View)((View)accessibleTitle), (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(accessibleTitle){
                    final /* synthetic */ TextView $accessibleTitle;
                    {
                        this.$accessibleTitle = $accessibleTitle;
                    }

                    public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat info) {
                        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                        super.onInitializeAccessibilityNodeInfo((View)this.$accessibleTitle, info);
                        info.setHeading(true);
                    }
                });
            }
            return titleContainer;
        }

        private final Dialog createAppCompatDialog(Context activityContext, Bundle arguments, DialogInterface.OnClickListener fragment) {
            AlertDialog.Builder builder = new AlertDialog.Builder(activityContext);
            if (arguments.containsKey(AlertFragment.ARG_TITLE)) {
                String title = (String)Assertions.assertNotNull((Object)arguments.getString(AlertFragment.ARG_TITLE));
                Intrinsics.checkNotNull((Object)title);
                View accessibleTitle = this.getAccessibleTitle(activityContext, title);
                builder.setCustomTitle(accessibleTitle);
            }
            if (arguments.containsKey(AlertFragment.ARG_BUTTON_POSITIVE)) {
                builder.setPositiveButton((CharSequence)arguments.getString(AlertFragment.ARG_BUTTON_POSITIVE), fragment);
            }
            if (arguments.containsKey(AlertFragment.ARG_BUTTON_NEGATIVE)) {
                builder.setNegativeButton((CharSequence)arguments.getString(AlertFragment.ARG_BUTTON_NEGATIVE), fragment);
            }
            if (arguments.containsKey(AlertFragment.ARG_BUTTON_NEUTRAL)) {
                builder.setNeutralButton((CharSequence)arguments.getString(AlertFragment.ARG_BUTTON_NEUTRAL), fragment);
            }
            if (arguments.containsKey(AlertFragment.ARG_MESSAGE)) {
                builder.setMessage((CharSequence)arguments.getString(AlertFragment.ARG_MESSAGE));
            }
            if (arguments.containsKey(AlertFragment.ARG_ITEMS)) {
                builder.setItems(arguments.getCharSequenceArray(AlertFragment.ARG_ITEMS), fragment);
            }
            androidx.appcompat.app.AlertDialog alertDialog = builder.create();
            Intrinsics.checkNotNullExpressionValue((Object)alertDialog, (String)"create(...)");
            return (Dialog)alertDialog;
        }

        @Deprecated(message="non-AppCompat dialogs are deprecated and will be removed in a future version.", replaceWith=@ReplaceWith(expression="createAppCompatDialog(activityContext, arguments, fragment)", imports={}))
        private final Dialog createAppDialog(Context activityContext, Bundle arguments, DialogInterface.OnClickListener fragment) {
            AlertDialog.Builder builder = new AlertDialog.Builder(activityContext);
            if (arguments.containsKey(AlertFragment.ARG_TITLE)) {
                String title = (String)Assertions.assertNotNull((Object)arguments.getString(AlertFragment.ARG_TITLE));
                Intrinsics.checkNotNull((Object)title);
                View accessibleTitle = this.getAccessibleTitle(activityContext, title);
                builder.setCustomTitle(accessibleTitle);
            }
            if (arguments.containsKey(AlertFragment.ARG_BUTTON_POSITIVE)) {
                builder.setPositiveButton((CharSequence)arguments.getString(AlertFragment.ARG_BUTTON_POSITIVE), fragment);
            }
            if (arguments.containsKey(AlertFragment.ARG_BUTTON_NEGATIVE)) {
                builder.setNegativeButton((CharSequence)arguments.getString(AlertFragment.ARG_BUTTON_NEGATIVE), fragment);
            }
            if (arguments.containsKey(AlertFragment.ARG_BUTTON_NEUTRAL)) {
                builder.setNeutralButton((CharSequence)arguments.getString(AlertFragment.ARG_BUTTON_NEUTRAL), fragment);
            }
            if (arguments.containsKey(AlertFragment.ARG_MESSAGE)) {
                builder.setMessage((CharSequence)arguments.getString(AlertFragment.ARG_MESSAGE));
            }
            if (arguments.containsKey(AlertFragment.ARG_ITEMS)) {
                builder.setItems(arguments.getCharSequenceArray(AlertFragment.ARG_ITEMS), fragment);
            }
            AlertDialog alertDialog = builder.create();
            Intrinsics.checkNotNullExpressionValue((Object)alertDialog, (String)"create(...)");
            return (Dialog)alertDialog;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

