/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting.mountitems;

import com.facebook.common.logging.FLog;
import com.facebook.proguard.annotations.DoNotStripAny;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.fabric.events.EventEmitterWrapper;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.SurfaceMountingManager;
import com.facebook.react.fabric.mounting.mountitems.BatchMountItem;
import com.facebook.react.fabric.mounting.mountitems.FabricNameComponentMapping;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.systrace.Systrace;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/facebook/react/fabric/mounting/mountitems/IntBufferBatchMountItem;", "Lcom/facebook/react/fabric/mounting/mountitems/BatchMountItem;", "surfaceId", "", "intBuffer", "", "objBuffer", "", "", "commitNumber", "<init>", "(I[I[Ljava/lang/Object;I)V", "[Ljava/lang/Object;", "intBufferLen", "objBufferLen", "beginMarkers", "", "reason", "", "endMarkers", "execute", "mountingManager", "Lcom/facebook/react/fabric/mounting/MountingManager;", "getSurfaceId", "isBatchEmpty", "", "toString", "Companion", "ReactAndroid_debug"})
@DoNotStripAny
public final class IntBufferBatchMountItem
implements BatchMountItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int surfaceId;
    @NotNull
    private final int[] intBuffer;
    @NotNull
    private final Object[] objBuffer;
    private final int commitNumber;
    private final int intBufferLen;
    private final int objBufferLen;
    @NotNull
    private static final String TAG;
    public static final int INSTRUCTION_FLAG_MULTIPLE = 1;
    public static final int INSTRUCTION_CREATE = 2;
    public static final int INSTRUCTION_DELETE = 4;
    public static final int INSTRUCTION_INSERT = 8;
    public static final int INSTRUCTION_REMOVE = 16;
    public static final int INSTRUCTION_UPDATE_PROPS = 32;
    public static final int INSTRUCTION_UPDATE_STATE = 64;
    public static final int INSTRUCTION_UPDATE_LAYOUT = 128;
    public static final int INSTRUCTION_UPDATE_EVENT_EMITTER = 256;
    public static final int INSTRUCTION_UPDATE_PADDING = 512;
    public static final int INSTRUCTION_UPDATE_OVERFLOW_INSET = 1024;

    public IntBufferBatchMountItem(int surfaceId, @NotNull int[] intBuffer, @NotNull Object[] objBuffer, int commitNumber) {
        Intrinsics.checkNotNullParameter((Object)intBuffer, (String)"intBuffer");
        Intrinsics.checkNotNullParameter((Object)objBuffer, (String)"objBuffer");
        this.surfaceId = surfaceId;
        this.intBuffer = intBuffer;
        this.objBuffer = objBuffer;
        this.commitNumber = commitNumber;
        this.intBufferLen = this.intBuffer.length;
        this.objBufferLen = this.objBuffer.length;
    }

    private final void beginMarkers(String reason) {
        Systrace.beginSection(0L, "IntBufferBatchMountItem::" + reason);
        if (this.commitNumber > 0) {
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_BATCH_EXECUTION_START, null, this.commitNumber);
        }
    }

    private final void endMarkers() {
        if (this.commitNumber > 0) {
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_BATCH_EXECUTION_END, null, this.commitNumber);
        }
        Systrace.endSection(0L);
    }

    @Override
    public void execute(@NotNull MountingManager mountingManager) {
        Intrinsics.checkNotNullParameter((Object)mountingManager, (String)"mountingManager");
        SurfaceMountingManager surfaceMountingManager = mountingManager.getSurfaceManager(this.surfaceId);
        if (surfaceMountingManager == null) {
            Object[] objectArray = new Object[]{this.surfaceId};
            FLog.e((String)TAG, (String)"Skipping batch of MountItems; no SurfaceMountingManager found for [%d].", (Object[])objectArray);
            return;
        }
        if (surfaceMountingManager.isStopped()) {
            Object[] objectArray = new Object[]{this.surfaceId};
            FLog.e((String)TAG, (String)"Skipping batch of MountItems; was stopped [%d].", (Object[])objectArray);
            return;
        }
        if (ReactNativeFeatureFlags.enableFabricLogs()) {
            FLog.d((String)TAG, (String)"Executing IntBufferBatchMountItem on surface [%d]", (Object)this.surfaceId);
        }
        this.beginMarkers("mountViews");
        int i = 0;
        int j = 0;
        while (i < this.intBufferLen) {
            int rawType = this.intBuffer[i++];
            int type = rawType & 0xFFFFFFFE;
            int numInstructions = (rawType & 1) != 0 ? this.intBuffer[i++] : 1;
            String[] stringArray = new String[]{"numInstructions", String.valueOf(numInstructions)};
            String[] args = stringArray;
            Systrace.beginSection(0L, "IntBufferBatchMountItem::mountInstructions::" + IntBufferBatchMountItem.Companion.nameForInstructionString(type), args, args.length);
            block13: for (int k = 0; k < numInstructions; ++k) {
                switch (type) {
                    case 2: {
                        String string2;
                        if ((string2 = (String)this.objBuffer[j++]) == null) {
                            string2 = "";
                        }
                        String componentName = string2;
                        String fabricComponentName = FabricNameComponentMapping.getFabricComponentName(componentName);
                        surfaceMountingManager.createView(fabricComponentName, this.intBuffer[i++], (ReadableMap)this.objBuffer[j++], (StateWrapper)this.objBuffer[j++], (EventEmitterWrapper)((Object)this.objBuffer[j++]), this.intBuffer[i++] == 1);
                        continue block13;
                    }
                    case 4: {
                        surfaceMountingManager.deleteView(this.intBuffer[i++]);
                        continue block13;
                    }
                    case 8: {
                        int tag = this.intBuffer[i++];
                        int parentTag = this.intBuffer[i++];
                        surfaceMountingManager.addViewAt(parentTag, tag, this.intBuffer[i++]);
                        continue block13;
                    }
                    case 16: {
                        surfaceMountingManager.removeViewAt(this.intBuffer[i++], this.intBuffer[i++], this.intBuffer[i++]);
                        continue block13;
                    }
                    case 32: {
                        surfaceMountingManager.updateProps(this.intBuffer[i++], (ReadableMap)this.objBuffer[j++]);
                        continue block13;
                    }
                    case 64: {
                        surfaceMountingManager.updateState(this.intBuffer[i++], (StateWrapper)this.objBuffer[j++]);
                        continue block13;
                    }
                    case 128: {
                        int reactTag = this.intBuffer[i++];
                        int parentTag = this.intBuffer[i++];
                        int x = this.intBuffer[i++];
                        int y = this.intBuffer[i++];
                        int width = this.intBuffer[i++];
                        int height = this.intBuffer[i++];
                        int displayType = this.intBuffer[i++];
                        int layoutDirection = this.intBuffer[i++];
                        surfaceMountingManager.updateLayout(reactTag, parentTag, x, y, width, height, displayType, layoutDirection);
                        continue block13;
                    }
                    case 512: {
                        surfaceMountingManager.updatePadding(this.intBuffer[i++], this.intBuffer[i++], this.intBuffer[i++], this.intBuffer[i++], this.intBuffer[i++]);
                        continue block13;
                    }
                    case 1024: {
                        int reactTag = this.intBuffer[i++];
                        int overflowInsetLeft = this.intBuffer[i++];
                        int overflowInsetTop = this.intBuffer[i++];
                        int overflowInsetRight = this.intBuffer[i++];
                        int overflowInsetBottom = this.intBuffer[i++];
                        surfaceMountingManager.updateOverflowInset(reactTag, overflowInsetLeft, overflowInsetTop, overflowInsetRight, overflowInsetBottom);
                        continue block13;
                    }
                    case 256: {
                        EventEmitterWrapper eventEmitterWrapper = (EventEmitterWrapper)((Object)this.objBuffer[j++]);
                        if (eventEmitterWrapper == null) continue block13;
                        surfaceMountingManager.updateEventEmitter(this.intBuffer[i++], eventEmitterWrapper);
                        continue block13;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid type argument to IntBufferBatchMountItem: " + type + " at index: " + i);
                    }
                }
            }
            Systrace.endSection(0L);
        }
        this.endMarkers();
    }

    @Override
    public int getSurfaceId() {
        return this.surfaceId;
    }

    @Override
    public boolean isBatchEmpty() {
        return this.intBufferLen == 0;
    }

    @NotNull
    public String toString() {
        try {
            StringBuilder s = new StringBuilder();
            Locale locale = Locale.ROOT;
            String string2 = "IntBufferBatchMountItem [surface:%d]:\n";
            Object[] objectArray = new Object[]{this.surfaceId};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            s.append(string3);
            int i = 0;
            int j = 0;
            while (i < this.intBufferLen) {
                int rawType = this.intBuffer[i++];
                int type = rawType & 0xFFFFFFFE;
                int numInstructions = (rawType & 1) != 0 ? this.intBuffer[i++] : 1;
                block15: for (int k = 0; k < numInstructions; ++k) {
                    switch (type) {
                        case 2: {
                            String string4;
                            if ((string4 = (String)this.objBuffer[j++]) == null) {
                                string4 = "";
                            }
                            String componentName = string4;
                            Object fabricComponentName = FabricNameComponentMapping.getFabricComponentName(componentName);
                            j += 3;
                            Object object2 = Locale.ROOT;
                            String string5 = "CREATE [%d] - layoutable:%d - %s\n";
                            Object[] objectArray2 = new Object[]{this.intBuffer[i++], this.intBuffer[i++], fabricComponentName};
                            String string6 = String.format((Locale)object2, string5, Arrays.copyOf(objectArray2, objectArray2.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
                            StringBuilder stringBuilder = s.append(string6);
                            continue block15;
                        }
                        case 4: {
                            Object fabricComponentName = Locale.ROOT;
                            String string7 = "DELETE [%d]\n";
                            Object object2 = new Object[]{this.intBuffer[i++]};
                            String string8 = String.format((Locale)fabricComponentName, string7, Arrays.copyOf(object2, ((Object[])object2).length));
                            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(...)");
                            StringBuilder stringBuilder = s.append(string8);
                            continue block15;
                        }
                        case 8: {
                            Object fabricComponentName = Locale.ROOT;
                            String string7 = "INSERT [%d]->[%d] @%d\n";
                            Object object2 = new Object[]{this.intBuffer[i++], this.intBuffer[i++], this.intBuffer[i++]};
                            String string9 = String.format((Locale)fabricComponentName, string7, Arrays.copyOf(object2, ((Object[])object2).length));
                            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(...)");
                            StringBuilder stringBuilder = s.append(string9);
                            continue block15;
                        }
                        case 16: {
                            Object fabricComponentName = Locale.ROOT;
                            String string7 = "REMOVE [%d]->[%d] @%d\n";
                            Object object2 = new Object[]{this.intBuffer[i++], this.intBuffer[i++], this.intBuffer[i++]};
                            String string10 = String.format((Locale)fabricComponentName, string7, Arrays.copyOf(object2, ((Object[])object2).length));
                            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"format(...)");
                            StringBuilder stringBuilder = s.append(string10);
                            continue block15;
                        }
                        case 32: {
                            Object object;
                            Object props = this.objBuffer[j++];
                            if (FabricUIManager.IS_DEVELOPMENT_ENVIRONMENT) {
                                object = props;
                                if (object == null || (object = object.toString()) == null) {
                                    object = "<null>";
                                }
                            } else {
                                object = "<hidden>";
                            }
                            Object propsString = object;
                            Object object2 = Locale.ROOT;
                            String string5 = "UPDATE PROPS [%d]: %s\n";
                            Object[] objectArray2 = new Object[]{this.intBuffer[i++], propsString};
                            String string11 = String.format((Locale)object2, string5, Arrays.copyOf(objectArray2, objectArray2.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"format(...)");
                            StringBuilder stringBuilder = s.append(string11);
                            continue block15;
                        }
                        case 64: {
                            Object object;
                            StateWrapper state = (StateWrapper)this.objBuffer[j++];
                            if (FabricUIManager.IS_DEVELOPMENT_ENVIRONMENT) {
                                object = state;
                                if (object == null || (object = object.toString()) == null) {
                                    object = "<null>";
                                }
                            } else {
                                object = "<hidden>";
                            }
                            Object stateString = object;
                            Object object2 = Locale.ROOT;
                            String string5 = "UPDATE STATE [%d]: %s\n";
                            Object[] objectArray2 = new Object[]{this.intBuffer[i++], stateString};
                            String string12 = String.format((Locale)object2, string5, Arrays.copyOf(objectArray2, objectArray2.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"format(...)");
                            StringBuilder stringBuilder = s.append(string12);
                            continue block15;
                        }
                        case 128: {
                            Locale locale2 = Locale.ROOT;
                            String string7 = "UPDATE LAYOUT [%d]->[%d]: x:%d y:%d w:%d h:%d displayType:%d layoutDirection:%d\n";
                            Object object2 = new Object[]{this.intBuffer[i++], this.intBuffer[i++], this.intBuffer[i++], this.intBuffer[i++], this.intBuffer[i++], this.intBuffer[i++], this.intBuffer[i++], this.intBuffer[i++]};
                            String string13 = String.format(locale2, string7, Arrays.copyOf(object2, ((Object[])object2).length));
                            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"format(...)");
                            StringBuilder stringBuilder = s.append(string13);
                            continue block15;
                        }
                        case 512: {
                            Locale locale2 = Locale.ROOT;
                            String string7 = "UPDATE PADDING [%d]: top:%d right:%d bottom:%d left:%d\n";
                            Object object2 = new Object[]{this.intBuffer[i++], this.intBuffer[i++], this.intBuffer[i++], this.intBuffer[i++], this.intBuffer[i++]};
                            String string14 = String.format(locale2, string7, Arrays.copyOf(object2, ((Object[])object2).length));
                            Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"format(...)");
                            StringBuilder stringBuilder = s.append(string14);
                            continue block15;
                        }
                        case 1024: {
                            Locale locale2 = Locale.ROOT;
                            String string7 = "UPDATE OVERFLOWINSET [%d]: left:%d top:%d right:%d bottom:%d\n";
                            Object object2 = new Object[]{this.intBuffer[i++], this.intBuffer[i++], this.intBuffer[i++], this.intBuffer[i++], this.intBuffer[i++]};
                            String string15 = String.format(locale2, string7, Arrays.copyOf(object2, ((Object[])object2).length));
                            Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"format(...)");
                            StringBuilder stringBuilder = s.append(string15);
                            continue block15;
                        }
                        case 256: {
                            ++j;
                            Locale locale2 = Locale.ROOT;
                            String string7 = "UPDATE EVENTEMITTER [%d]\n";
                            Object object2 = new Object[]{this.intBuffer[i++]};
                            String string16 = String.format(locale2, string7, Arrays.copyOf(object2, ((Object[])object2).length));
                            Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"format(...)");
                            StringBuilder stringBuilder = s.append(string16);
                            continue block15;
                        }
                        default: {
                            FLog.e((String)TAG, (String)("String so far: " + s));
                            throw new IllegalArgumentException("Invalid type argument to IntBufferBatchMountItem: " + type + " at index: " + i);
                        }
                    }
                }
            }
            String string17 = s.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"toString(...)");
            return string17;
        }
        catch (Exception e) {
            FLog.e((String)TAG, (String)"Caught exception trying to print", (Throwable)e);
            StringBuilder ss = new StringBuilder();
            for (int ii = 0; ii < this.intBufferLen; ++ii) {
                ss.append(this.intBuffer[ii]);
                ss.append(", ");
            }
            FLog.e((String)TAG, (String)ss.toString());
            for (int jj = 0; jj < this.objBufferLen; ++jj) {
                FLog.e((String)TAG, (String)(this.objBuffer[jj] != null ? String.valueOf(this.objBuffer[jj]) : "null"));
            }
            return "";
        }
    }

    static {
        String string2 = IntBufferBatchMountItem.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
        TAG = string2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\tH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/react/fabric/mounting/mountitems/IntBufferBatchMountItem$Companion;", "", "<init>", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "INSTRUCTION_FLAG_MULTIPLE", "", "INSTRUCTION_CREATE", "INSTRUCTION_DELETE", "INSTRUCTION_INSERT", "INSTRUCTION_REMOVE", "INSTRUCTION_UPDATE_PROPS", "INSTRUCTION_UPDATE_STATE", "INSTRUCTION_UPDATE_LAYOUT", "INSTRUCTION_UPDATE_EVENT_EMITTER", "INSTRUCTION_UPDATE_PADDING", "INSTRUCTION_UPDATE_OVERFLOW_INSET", "nameForInstructionString", "type", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        private final String nameForInstructionString(int type) {
            return switch (type) {
                case 2 -> "CREATE";
                case 4 -> "DELETE";
                case 8 -> "INSERT";
                case 16 -> "REMOVE";
                case 32 -> "UPDATE_PROPS";
                case 64 -> "UPDATE_STATE";
                case 128 -> "UPDATE_LAYOUT";
                case 512 -> "UPDATE_PADDING";
                case 1024 -> "UPDATE_OVERFLOW_INSET";
                case 256 -> "UPDATE_EVENT_EMITTER";
                default -> "UNKNOWN";
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

