/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.defaults;

import android.app.Application;
import android.content.Context;
import com.facebook.react.JSEngineResolutionAlgorithm;
import com.facebook.react.ReactHost;
import com.facebook.react.ReactNativeHost;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactPackageTurboModuleManagerDelegate;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UIManagerProvider;
import com.facebook.react.common.annotations.UnstableReactNativeAPI;
import com.facebook.react.defaults.DefaultComponentsRegistry;
import com.facebook.react.defaults.DefaultReactHost;
import com.facebook.react.defaults.DefaultTurboModuleManagerDelegate;
import com.facebook.react.fabric.ComponentFactory;
import com.facebook.react.fabric.FabricUIManagerProviderImpl;
import com.facebook.react.runtime.JSCInstance;
import com.facebook.react.runtime.JSRuntimeFactory;
import com.facebook.react.runtime.hermes.HermesInstance;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.ViewManagerResolver;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0014J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0016J!\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0001\u00a2\u0006\u0002\b\u0019R\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lcom/facebook/react/defaults/DefaultReactNativeHost;", "Lcom/facebook/react/ReactNativeHost;", "application", "Landroid/app/Application;", "<init>", "(Landroid/app/Application;)V", "getReactPackageTurboModuleManagerDelegateBuilder", "Lcom/facebook/react/ReactPackageTurboModuleManagerDelegate$Builder;", "getUIManagerProvider", "Lcom/facebook/react/bridge/UIManagerProvider;", "getJSEngineResolutionAlgorithm", "Lcom/facebook/react/JSEngineResolutionAlgorithm;", "clear", "", "isNewArchEnabled", "", "()Z", "isHermesEnabled", "()Ljava/lang/Boolean;", "toReactHost", "Lcom/facebook/react/ReactHost;", "context", "Landroid/content/Context;", "jsRuntimeFactory", "Lcom/facebook/react/runtime/JSRuntimeFactory;", "toReactHost$ReactAndroid_debug", "ReactAndroid_debug"})
public abstract class DefaultReactNativeHost
extends ReactNativeHost {
    protected DefaultReactNativeHost(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application);
    }

    @Override
    @Nullable
    protected ReactPackageTurboModuleManagerDelegate.Builder getReactPackageTurboModuleManagerDelegateBuilder() {
        return this.isNewArchEnabled() ? (ReactPackageTurboModuleManagerDelegate.Builder)new DefaultTurboModuleManagerDelegate.Builder() : null;
    }

    @Override
    @Nullable
    protected UIManagerProvider getUIManagerProvider() {
        return this.isNewArchEnabled() ? arg_0 -> DefaultReactNativeHost.getUIManagerProvider$lambda$0(this, arg_0) : null;
    }

    @Override
    @Nullable
    protected JSEngineResolutionAlgorithm getJSEngineResolutionAlgorithm() {
        JSEngineResolutionAlgorithm jSEngineResolutionAlgorithm;
        Boolean bl = this.isHermesEnabled();
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            jSEngineResolutionAlgorithm = JSEngineResolutionAlgorithm.HERMES;
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            jSEngineResolutionAlgorithm = JSEngineResolutionAlgorithm.JSC;
        } else if (bl == null) {
            jSEngineResolutionAlgorithm = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jSEngineResolutionAlgorithm;
    }

    @Override
    public void clear() {
        super.clear();
        DefaultReactHost.INSTANCE.invalidate$ReactAndroid_debug();
    }

    protected boolean isNewArchEnabled() {
        return false;
    }

    @Nullable
    protected Boolean isHermesEnabled() {
        return null;
    }

    @UnstableReactNativeAPI
    @NotNull
    public final ReactHost toReactHost$ReactAndroid_debug(@NotNull Context context, @Nullable JSRuntimeFactory jsRuntimeFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JSRuntimeFactory jSRuntimeFactory = jsRuntimeFactory;
        if (jSRuntimeFactory == null) {
            jSRuntimeFactory = Intrinsics.areEqual((Object)this.isHermesEnabled(), (Object)false) ? (JSRuntimeFactory)new JSCInstance() : (JSRuntimeFactory)new HermesInstance();
        }
        JSRuntimeFactory concreteJSRuntimeFactory = jSRuntimeFactory;
        List<ReactPackage> list = this.getPackages();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPackages(...)");
        String string2 = this.getJSMainModuleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getJSMainModuleName(...)");
        String string3 = this.getBundleAssetName();
        if (string3 == null) {
            string3 = "index";
        }
        return DefaultReactHost.getDefaultReactHost$default(context, list, string2, string3, this.getJSBundleFile(), concreteJSRuntimeFactory, this.getUseDeveloperSupport(), null, 128, null);
    }

    public static /* synthetic */ ReactHost toReactHost$ReactAndroid_debug$default(DefaultReactNativeHost defaultReactNativeHost, Context context, JSRuntimeFactory jSRuntimeFactory, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toReactHost");
        }
        if ((n & 2) != 0) {
            jSRuntimeFactory = null;
        }
        return defaultReactNativeHost.toReactHost$ReactAndroid_debug(context, jSRuntimeFactory);
    }

    private static final UIManager getUIManagerProvider$lambda$0(DefaultReactNativeHost this$0, ReactApplicationContext reactApplicationContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactApplicationContext), (String)"reactApplicationContext");
        ComponentFactory componentFactory = new ComponentFactory();
        DefaultComponentsRegistry.register(componentFactory);
        ViewManagerRegistry viewManagerRegistry2 = this$0.getLazyViewManagersEnabled() ? new ViewManagerRegistry(new ViewManagerResolver(this$0){
            final /* synthetic */ DefaultReactNativeHost this$0;
            {
                this.this$0 = $receiver;
            }

            public ViewManager getViewManager(String viewManagerName) {
                Intrinsics.checkNotNullParameter((Object)viewManagerName, (String)"viewManagerName");
                return this.this$0.getReactInstanceManager().createViewManager(viewManagerName);
            }

            public Collection<String> getViewManagerNames() {
                return this.this$0.getReactInstanceManager().getViewManagerNames();
            }
        }) : new ViewManagerRegistry(this$0.getReactInstanceManager().getOrCreateViewManagers(reactApplicationContext));
        return new FabricUIManagerProviderImpl(componentFactory, viewManagerRegistry2).createUIManager(reactApplicationContext);
    }
}

